/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sms.alarm;

import com.tridium.alarm.ack.BAlarmAcknowledger;
import com.tridium.sms.BSmsMessage;
import com.tridium.sms.util.SmsToolkit;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BUuid;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BSmsAlarmAcknowledger
extends BAlarmAcknowledger {
    public static final Property lastSmsMessageReceived = BSmsAlarmAcknowledger.newProperty((int)67, (BValue)new BSmsMessage(), null);
    public static final Action received = BSmsAlarmAcknowledger.newAction((int)24, (BValue)new BSmsMessage(), null);
    public static final Type TYPE;
    private static final BIcon icon;
    static /* synthetic */ Class class$com$tridium$sms$alarm$BSmsAlarmAcknowledger;
    static /* synthetic */ Class class$javax$baja$user$BUser;

    public final BSmsMessage getLastSmsMessageReceived() {
        return (BSmsMessage)this.get(lastSmsMessageReceived);
    }

    public final void setLastSmsMessageReceived(BSmsMessage bSmsMessage) {
        this.set(lastSmsMessageReceived, (BValue)bSmsMessage, null);
    }

    public final void received(BSmsMessage bSmsMessage) {
        this.invoke(received, (BValue)bSmsMessage, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final BIcon getIcon() {
        return icon;
    }

    public final IFuture post(Action action, BValue bValue, Context context) {
        if (action == received) {
            this.post((Runnable)new Invocation((BComponent)this, action, bValue, context));
            return null;
        }
        return super.post(action, bValue, context);
    }

    public final void doReceived(BSmsMessage bSmsMessage) {
        BUuid bUuid;
        Object object;
        if (this.getStatus().isDisabled()) {
            return;
        }
        if (log.isTraceOn()) {
            log.trace("Processing received sms: " + bSmsMessage.getPhoneNumbers());
        }
        this.incTotalMessagesReceivedToday();
        this.getLastSmsMessageReceived().copyFrom((BComplex)bSmsMessage);
        String string = bSmsMessage.getMessage();
        int n = string.toUpperCase().indexOf("UUID:");
        if (n <= -1) {
            this.doFail("Could not find UUID in SMS Message to ack alarm");
            return;
        }
        String string2 = bSmsMessage.getPhoneNumbers();
        String string3 = null;
        try {
            object = (BUserService)Sys.getService((Type)BUserService.TYPE);
            Class clazz = class$javax$baja$user$BUser;
            if (clazz == null) {
                clazz = class$javax$baja$user$BUser = BSmsAlarmAcknowledger.class("[Ljavax.baja.user.BUser;", false);
            }
            bUuid = (BUser[])object.getChildren(clazz);
            int n2 = 0;
            while (n2 < ((BUser[])bUuid).length) {
                String string4 = SmsToolkit.removeSpaceCharacters(bUuid[n2].getCellPhoneNumber());
                if (string4.equals(string2) || BSmsAlarmAcknowledger.removePlus(string4).equals(BSmsAlarmAcknowledger.removePlus(string2))) {
                    string3 = bUuid[n2].getName();
                    break;
                }
                ++n2;
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            String string5 = "Unable to find User Service";
            log.error(string5, (Throwable)serviceNotFoundException);
            this.doFail(string5);
            return;
        }
        if (string3 == null) {
            this.doFail("Non user attempted to ack alarm via sms: " + string2);
            return;
        }
        try {
            object = string.substring(n + "UUID:".length(), n + 36 + "UUID:".length());
            if (log.isTraceOn()) {
                log.trace("Recieved alarm ack sms: " + (String)object + " user: " + string3);
            }
            bUuid = (BUuid)BUuid.DEFAULT.decodeFromString((String)object);
            this.ackAlarm(bUuid, string3);
        }
        catch (Exception exception) {
            bUuid = "Could not decode UUID from received SMS Message";
            log.error((String)bUuid, (Throwable)exception);
            this.doFail((String)bUuid);
        }
    }

    private static final String removePlus(String string) {
        if (string.length() > 0 && string.charAt(0) == '+') {
            return string.substring(1, string.length());
        }
        return string;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$sms$alarm$BSmsAlarmAcknowledger;
        if (clazz == null) {
            clazz = class$com$tridium$sms$alarm$BSmsAlarmAcknowledger = BSmsAlarmAcknowledger.class("[Lcom.tridium.sms.alarm.BSmsAlarmAcknowledger;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((BIcon)BIcon.make((String)"module://sms/res/sms.png"), (BIcon)BIcon.std((String)"badges/new.png"));
    }
}

