/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sms;

import com.tridium.sms.BAbstractSmsTransport;
import com.tridium.sms.BSmsElement;
import com.tridium.sms.BSmsMessage;
import com.tridium.sms.SmsException;
import com.tridium.sms.ping.BBasicPingMonitor;
import com.tridium.sms.ping.BIBasicPingMonitorParent;
import com.tridium.sms.ping.BIPingable;
import com.tridium.sms.serial.BSerialSmsTransport;
import com.tridium.sms.util.BSmsWorker;
import com.tridium.sms.util.SmsToolkit;
import javax.baja.data.BIDataValue;
import javax.baja.license.Feature;
import javax.baja.nav.BINavNode;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.BTypeSpec;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BSmsService
extends BAbstractService
implements BIPingable,
BIBasicPingMonitorParent {
    public static final Property worker = BSmsService.newProperty((int)4, (BValue)new BSmsWorker(), null);
    public static final Property transportType = BSmsService.newProperty((int)0, (BValue)BTypeSpec.make((String)"sms:SerialSmsTransport"), (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"sms:AbstractSmsTransport")));
    public static final Property transport = BSmsService.newProperty((int)0, (BValue)new BSerialSmsTransport(), null);
    public static final Property monitor = BSmsService.newProperty((int)0, (BValue)new BBasicPingMonitor(), null);
    public static final Property signalStrength = BSmsService.newProperty((int)1, (BValue)new BStatusNumeric(), (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"sms:SignalStrengthFE")));
    public static final Property maxQueueSize = BSmsService.newProperty((int)0, (int)100, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    public static final Property queueSize = BSmsService.newProperty((int)3, (int)0, null);
    public static final Property processQueueInterval = BSmsService.newProperty((int)0, (BValue)BRelTime.make((long)90000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)3000L)));
    public static final Property maxSendablePerDay = BSmsService.newProperty((int)0, (int)100, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    public static final Property numberSentToday = BSmsService.newProperty((int)3, (int)0, null);
    public static final Property lastMessageSentTime = BSmsService.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property useEscapeCharacters = BSmsService.newProperty((int)0, (boolean)true, null);
    public static final Property readMessagesInterval = BSmsService.newProperty((int)0, (BValue)BRelTime.make((long)75000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)2000L)));
    public static final Action ping = BSmsService.newAction((int)16, null);
    public static final Action send = BSmsService.newAction((int)0, (BValue)new BSmsMessage(), null);
    public static final Action clearQueue = BSmsService.newAction((int)128, null);
    public static final Action processQueue = BSmsService.newAction((int)16, null);
    public static final Action resetNumberSentToday = BSmsService.newAction((int)128, null);
    public static final Action readMessages = BSmsService.newAction((int)16, null);
    public static final Topic received = BSmsService.newTopic((int)0, null);
    public static final Type TYPE;
    public static final String DEFAULT = "default";
    private static final BIcon icon;
    private static Type[] serviceTypes;
    private Clock.Ticket resetTicket;
    private Clock.Ticket processQueueTicket;
    private Clock.Ticket readMessagesTicket;
    static /* synthetic */ Class class$com$tridium$sms$BSmsService;
    static /* synthetic */ Class class$com$tridium$sms$BSmsElement;
    static /* synthetic */ Class class$javax$baja$nav$BINavNode;

    public final BSmsWorker getWorker() {
        return (BSmsWorker)this.get(worker);
    }

    public final void setWorker(BSmsWorker bSmsWorker) {
        this.set(worker, (BValue)bSmsWorker, null);
    }

    public final BTypeSpec getTransportType() {
        return (BTypeSpec)this.get(transportType);
    }

    public final void setTransportType(BTypeSpec bTypeSpec) {
        this.set(transportType, (BValue)bTypeSpec, null);
    }

    public final BAbstractSmsTransport getTransport() {
        return (BAbstractSmsTransport)this.get(transport);
    }

    public final void setTransport(BAbstractSmsTransport bAbstractSmsTransport) {
        this.set(transport, (BValue)bAbstractSmsTransport, null);
    }

    public final BBasicPingMonitor getMonitor() {
        return (BBasicPingMonitor)this.get(monitor);
    }

    public final void setMonitor(BBasicPingMonitor bBasicPingMonitor) {
        this.set(monitor, (BValue)bBasicPingMonitor, null);
    }

    public final BStatusNumeric getSignalStrength() {
        return (BStatusNumeric)this.get(signalStrength);
    }

    public final void setSignalStrength(BStatusNumeric bStatusNumeric) {
        this.set(signalStrength, (BValue)bStatusNumeric, null);
    }

    public final int getMaxQueueSize() {
        return this.getInt(maxQueueSize);
    }

    public final void setMaxQueueSize(int n) {
        this.setInt(maxQueueSize, n, null);
    }

    public final int getQueueSize() {
        return this.getInt(queueSize);
    }

    public final void setQueueSize(int n) {
        this.setInt(queueSize, n, null);
    }

    public final BRelTime getProcessQueueInterval() {
        return (BRelTime)this.get(processQueueInterval);
    }

    public final void setProcessQueueInterval(BRelTime bRelTime) {
        this.set(processQueueInterval, (BValue)bRelTime, null);
    }

    public final int getMaxSendablePerDay() {
        return this.getInt(maxSendablePerDay);
    }

    public final void setMaxSendablePerDay(int n) {
        this.setInt(maxSendablePerDay, n, null);
    }

    public final int getNumberSentToday() {
        return this.getInt(numberSentToday);
    }

    public final void setNumberSentToday(int n) {
        this.setInt(numberSentToday, n, null);
    }

    public final BAbsTime getLastMessageSentTime() {
        return (BAbsTime)this.get(lastMessageSentTime);
    }

    public final void setLastMessageSentTime(BAbsTime bAbsTime) {
        this.set(lastMessageSentTime, (BValue)bAbsTime, null);
    }

    public final boolean getUseEscapeCharacters() {
        return this.getBoolean(useEscapeCharacters);
    }

    public final void setUseEscapeCharacters(boolean bl) {
        this.setBoolean(useEscapeCharacters, bl, null);
    }

    public final BRelTime getReadMessagesInterval() {
        return (BRelTime)this.get(readMessagesInterval);
    }

    public final void setReadMessagesInterval(BRelTime bRelTime) {
        this.set(readMessagesInterval, (BValue)bRelTime, null);
    }

    public final void ping() {
        this.invoke(ping, null, null);
    }

    public final void send(BSmsMessage bSmsMessage) {
        this.invoke(send, (BValue)bSmsMessage, null);
    }

    public final void clearQueue() {
        this.invoke(clearQueue, null, null);
    }

    public final void processQueue() {
        this.invoke(processQueue, null, null);
    }

    public final void resetNumberSentToday() {
        this.invoke(resetNumberSentToday, null, null);
    }

    public final void readMessages() {
        this.invoke(readMessages, null, null);
    }

    public final void fireReceived(BSmsMessage bSmsMessage) {
        this.fire(received, (BValue)bSmsMessage, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final void serviceStarted() throws Exception {
        Class clazz = class$com$tridium$sms$BSmsElement;
        if (clazz == null) {
            clazz = class$com$tridium$sms$BSmsElement = BSmsService.class("[Lcom.tridium.sms.BSmsElement;", false);
        }
        BSmsElement[] bSmsElementArray = (BSmsElement[])this.getChildren(clazz);
        this.setQueueSize(bSmsElementArray.length);
    }

    public final void serviceStopped() throws Exception {
    }

    public final Type[] getServiceTypes() {
        return serviceTypes;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "sms");
    }

    public final BINavNode[] getNavChildren() {
        BINavNode[] bINavNodeArray = super.getNavChildren();
        Class clazz = class$javax$baja$nav$BINavNode;
        if (clazz == null) {
            clazz = class$javax$baja$nav$BINavNode = BSmsService.class("[Ljavax.baja.nav.BINavNode;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < bINavNodeArray.length) {
            BComplex bComplex;
            if (!bINavNodeArray[n].asObject().isComplex() || !(bComplex = (BComplex)bINavNodeArray[n]).getPropertyInParent().isFrozen()) {
                array.add((Object)bINavNodeArray[n]);
            }
            ++n;
        }
        return (BINavNode[])array.trim();
    }

    public final void started() throws Exception {
        if (Sys.isStationStarted()) {
            this.init();
        }
    }

    public final void stationStarted() throws Exception {
        this.init();
    }

    private final void init() {
        if (SmsToolkit.log.isTraceOn()) {
            SmsToolkit.log.trace("*** Starting Sms Service ***");
        }
        this.checkTransportType();
        Class clazz = class$com$tridium$sms$BSmsElement;
        if (clazz == null) {
            clazz = class$com$tridium$sms$BSmsElement = BSmsService.class("[Lcom.tridium.sms.BSmsElement;", false);
        }
        this.setQueueSize(this.getChildren(clazz).length);
        this.getMonitor().addPingable(this);
        this.restartResetTimer();
    }

    public final void stopped() {
        this.stopProcessQueueTimer();
        this.stopReadMessagesTimer();
        this.stopResetTimer();
        this.getMonitor().removePingable(this);
    }

    public final void added(Property property, Context context) {
        if (this.isRunning() && property.getType().equals(BSmsElement.TYPE)) {
            BSmsElement bSmsElement = (BSmsElement)this.get(property);
            bSmsElement.setAdded(BAbsTime.now());
            this.incrementQueue();
            this.checkQueueSize();
            this.processQueue();
            if (this.isDisabled()) {
                SmsToolkit.log.warning("SMS Message added to disabled SMS Service!");
            }
        }
    }

    public final void removed(Property property, BValue bValue, Context context) {
        if (this.isRunning() && bValue instanceof BSmsElement) {
            this.decrementQueue();
        }
    }

    public final void changed(Property property, Context context) {
        if (this.isRunning()) {
            if (property.equals((Object)maxQueueSize)) {
                this.checkQueueSize();
            } else if (property.equals((Object)transportType) || property.equals((Object)transport)) {
                this.checkTransportType();
            } else if (property.equals((Object)enabled)) {
                if (this.getEnabled()) {
                    this.ping();
                    this.processQueue();
                }
            } else if (property.equals((Object)processQueueInterval)) {
                this.restartProcessQueueTimer();
            } else if (property.equals((Object)readMessagesInterval)) {
                this.restartReadMessagesTimer();
            } else if (property.equals((Object)monitor)) {
                this.ping();
            }
        }
    }

    private final void checkTransportType() {
        if (!this.getTransportType().getResolvedType().equals(this.getTransport().getType())) {
            this.setTransport((BAbstractSmsTransport)this.getTransportType().getInstance());
        }
    }

    public final BIcon getIcon() {
        return icon;
    }

    public final void clockChanged(BRelTime bRelTime) {
        this.restartResetTimer();
    }

    public final IFuture post(Action action, BValue bValue, Context context) {
        this.getWorker().post((Runnable)new Invocation((BComponent)this, action, bValue, context));
        return null;
    }

    public final void atSteadyState() {
        this.restartProcessQueueTimer();
        this.restartReadMessagesTimer();
    }

    public static final BSmsService getService() {
        return (BSmsService)Sys.getService((Type)TYPE);
    }

    private final synchronized void incrementQueue() {
        this.setQueueSize(this.getQueueSize() + 1);
    }

    private final synchronized void decrementQueue() {
        this.setQueueSize(this.getQueueSize() - 1);
    }

    public final void doSend(BSmsMessage bSmsMessage) {
        BSmsMessage bSmsMessage2 = (BSmsMessage)bSmsMessage.newCopy();
        BSmsElement bSmsElement = new BSmsElement(bSmsMessage2);
        this.add("sms?", (BValue)bSmsElement, 2053);
    }

    private final void checkQueueSize() {
        if (this.getQueueSize() > this.getMaxQueueSize()) {
            int n = this.getQueueSize() - this.getMaxQueueSize();
            int n2 = 0;
            while (n2 < n) {
                this.removeFirstElement();
                ++n2;
            }
        }
    }

    private final void removeFirstElement() {
        BSmsElement[] bSmsElementArray;
        Class clazz = class$com$tridium$sms$BSmsElement;
        if (clazz == null) {
            clazz = class$com$tridium$sms$BSmsElement = BSmsService.class("[Lcom.tridium.sms.BSmsElement;", false);
        }
        if ((bSmsElementArray = (BSmsElement[])this.getChildren(clazz)) != null && bSmsElementArray.length > 0) {
            this.remove((BComplex)bSmsElementArray[0]);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Max SMS Message Queue size exceeded! Removing message from queue: ");
            stringBuffer.append(bSmsElementArray[0].getMessage().getPhoneNumbers());
            stringBuffer.append(" - ");
            stringBuffer.append(bSmsElementArray[0].getMessage().getMessage());
            SmsToolkit.log.warning(stringBuffer.toString());
        }
    }

    public final void doClearQueue() {
        Class clazz = class$com$tridium$sms$BSmsElement;
        if (clazz == null) {
            clazz = class$com$tridium$sms$BSmsElement = BSmsService.class("[Lcom.tridium.sms.BSmsElement;", false);
        }
        BSmsElement[] bSmsElementArray = (BSmsElement[])this.getChildren(clazz);
        int n = 0;
        while (n < bSmsElementArray.length) {
            this.remove((BComplex)bSmsElementArray[n]);
            ++n;
        }
    }

    public final void doResetNumberSentToday() {
        this.setNumberSentToday(0);
        this.restartResetTimer();
        this.processQueue();
        if (SmsToolkit.log.isTraceOn()) {
            SmsToolkit.log.trace("Reset number of text messages sent today");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void doProcessQueue() {
        try {
            if (!this.isRunning()) {
                Object var2_1 = null;
                this.restartProcessQueueTimer();
                return;
            }
            BSmsElement[] bSmsElementArray = null;
            if (!this.isDisabled() && !this.isFatalFault() && !this.isDown() && this.getTransport().isCommsActive()) {
                Class clazz;
                if (SmsToolkit.log.isTraceOn()) {
                    SmsToolkit.log.trace("Processing sms queue");
                }
                if ((clazz = class$com$tridium$sms$BSmsElement) == null) {
                    clazz = class$com$tridium$sms$BSmsElement = BSmsService.class("[Lcom.tridium.sms.BSmsElement;", false);
                }
                bSmsElementArray = (BSmsElement[])this.getChildren(clazz);
                int n = 0;
                while (n < bSmsElementArray.length) {
                    if (this.getNumberSentToday() >= this.getMaxSendablePerDay()) break;
                    try {
                        if (bSmsElementArray[n].getMessage().send()) {
                            this.remove((BComplex)bSmsElementArray[n]);
                        }
                        this.configOk();
                        if (this.getNumberSentToday() >= this.getMaxSendablePerDay()) {
                            SmsToolkit.log.warning("Cannot send anymore SMS text messages for today. Exceeded day limit!");
                        }
                        if (this.isDisabled() || this.isFatalFault() || !this.isRunning()) {
                            break;
                        }
                    }
                    catch (Exception exception) {
                        try {
                            bSmsElementArray[n].setSendAttempts(bSmsElementArray[n].getSendAttempts() + 1);
                            SmsToolkit.log.error("Sending SMS message", (Throwable)exception);
                            this.configFail(exception.getMessage());
                        }
                        catch (Exception exception2) {
                            SmsToolkit.log.error("Fatal error sending SMS message", (Throwable)exception);
                        }
                    }
                    ++n;
                }
            }
            Object var2_3 = null;
            this.restartProcessQueueTimer();
            return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.restartProcessQueueTimer();
            throw throwable;
        }
    }

    public final void doReadMessages() {
        if (!this.isDisabled() && !this.isFatalFault() && !this.isDown() && this.getTransport().isCommsActive()) {
            try {
                BSmsMessage[] bSmsMessageArray = this.getTransport().readMessages();
                if (bSmsMessageArray != null) {
                    int n = 0;
                    while (n < bSmsMessageArray.length) {
                        this.fireReceived(bSmsMessageArray[n]);
                        ++n;
                    }
                    this.pingOk();
                }
            }
            catch (SmsException smsException) {
                this.pingFail(smsException.getMessage());
            }
        }
    }

    public final void doPing() {
        if (!this.isDisabled() && !this.isFatalFault() && this.getMonitor().getPingEnabled() && this.getTransport().isCommsActive()) {
            try {
                this.getTransport().ping();
                this.pingOk();
            }
            catch (SmsException smsException) {
                this.pingFail(smsException.getMessage());
            }
            if (!this.isDown()) {
                BStatusNumeric bStatusNumeric = new BStatusNumeric(0.0);
                try {
                    bStatusNumeric = new BStatusNumeric(this.getTransport().getSignalStrength());
                    if (bStatusNumeric.getValue() <= 0.0 && this.getSignalStrength().getValue() > 0.0) {
                        SmsToolkit.log.warning("Low signal strength detected!");
                    }
                    this.pingOk();
                }
                catch (SmsException smsException) {
                    this.pingFail(smsException.getMessage());
                }
                this.setSignalStrength(bStatusNumeric);
            } else {
                this.setSignalStrength(new BStatusNumeric(0.0));
            }
        } else {
            this.setSignalStrength(new BStatusNumeric(0.0));
        }
    }

    public final void pingOk() {
        this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)false));
    }

    public final void pingFail(String string) {
        this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)true));
    }

    public final boolean isDown() {
        return this.getStatus().isDown();
    }

    private final void restartReadMessagesTimer() {
        this.stopReadMessagesTimer();
        this.readMessagesTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getReadMessagesInterval(), (Action)readMessages, null);
    }

    private final void stopReadMessagesTimer() {
        if (this.readMessagesTicket != null) {
            this.readMessagesTicket.cancel();
            this.readMessagesTicket = null;
        }
    }

    private final void restartProcessQueueTimer() {
        this.stopProcessQueueTimer();
        this.processQueueTicket = Clock.schedule((BComponent)this, (BRelTime)this.getProcessQueueInterval(), (Action)processQueue, null);
    }

    private final void stopProcessQueueTimer() {
        if (this.processQueueTicket != null) {
            this.processQueueTicket.cancel();
            this.processQueueTicket = null;
        }
    }

    private final void restartResetTimer() {
        this.stopResetTimer();
        BAbsTime bAbsTime = BAbsTime.now();
        BAbsTime bAbsTime2 = bAbsTime.nextDay();
        BAbsTime bAbsTime3 = bAbsTime2.timeOfDay(0, 0, 0, 0);
        this.resetTicket = Clock.schedule((BComponent)this, (BAbsTime)bAbsTime3, (Action)resetNumberSentToday, null);
    }

    private final void stopResetTimer() {
        if (this.resetTicket != null) {
            this.resetTicket.cancel();
            this.resetTicket = null;
        }
    }

    public final void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startTable(true);
        spyWriter.trTitle((Object)"SMS Outstanding Message Queue", 5);
        spyWriter.w((Object)"<tr>");
        spyWriter.th((Object)"Name");
        spyWriter.th((Object)"Added");
        spyWriter.th((Object)"Send Attempts");
        spyWriter.th((Object)"Phone Numbers");
        spyWriter.th((Object)"Message");
        spyWriter.w((Object)"</tr>");
        Class clazz = class$com$tridium$sms$BSmsElement;
        if (clazz == null) {
            clazz = class$com$tridium$sms$BSmsElement = BSmsService.class("[Lcom.tridium.sms.BSmsElement;", false);
        }
        BSmsElement[] bSmsElementArray = (BSmsElement[])this.getChildren(clazz);
        int n = 0;
        while (n < bSmsElementArray.length) {
            spyWriter.w((Object)"<tr>");
            spyWriter.td((Object)bSmsElementArray[n].getName());
            spyWriter.td((Object)bSmsElementArray[n].getAdded());
            spyWriter.td((Object)new Integer(bSmsElementArray[n].getSendAttempts()));
            BSmsMessage bSmsMessage = bSmsElementArray[n].getMessage();
            spyWriter.td((Object)bSmsMessage.getPhoneNumbers());
            spyWriter.td((Object)bSmsMessage.getMessage());
            spyWriter.w((Object)"</tr>");
            ++n;
        }
        spyWriter.endTable();
        super.spy(spyWriter);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.resetTicket = null;
        this.processQueueTicket = null;
        this.readMessagesTicket = null;
    }

    public BSmsService() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$sms$BSmsService;
        if (clazz == null) {
            clazz = class$com$tridium$sms$BSmsService = BSmsService.class("[Lcom.tridium.sms.BSmsService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://sms/res/smsService.png");
        serviceTypes = new Type[]{TYPE};
    }
}

