/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sms;

import com.tridium.sms.BSmsService;
import com.tridium.sms.SmsException;
import com.tridium.sms.util.SmsToolkit;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BSmsMessage
extends BStruct {
    public static final Property id = BSmsMessage.newProperty((int)5, (int)0, null);
    public static final Property phoneNumbers = BSmsMessage.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"sms:PhoneNumbersFE")));
    public static final Property message = BSmsMessage.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Type TYPE;
    private static final int MAX_CHAR_SIZE = 140;
    private static final BIcon icon;
    static /* synthetic */ Class class$com$tridium$sms$BSmsMessage;

    public final int getId() {
        return this.getInt(id);
    }

    public final void setId(int n) {
        this.setInt(id, n, null);
    }

    public final String getPhoneNumbers() {
        return this.getString(phoneNumbers);
    }

    public final void setPhoneNumbers(String string) {
        this.setString(phoneNumbers, string, null);
    }

    public final String getMessage() {
        return this.getString(message);
    }

    public final void setMessage(String string) {
        this.setString(message, string, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final BIcon getIcon() {
        return icon;
    }

    final boolean send() throws SmsException {
        String[] stringArray;
        String string = this.getMessage();
        if (this.getService().getUseEscapeCharacters()) {
            string = new String(SmsToolkit.filterForEscapeCharacters(string));
        }
        if (string.length() > 140) {
            string = string.substring(0, 140);
        }
        if ((stringArray = TextUtil.splitAndTrim((String)this.getPhoneNumbers(), (char)';')).length <= 0) {
            throw new SmsException(SmsToolkit.getText("smsMessage.invalidNumber"));
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (this.getService().getNumberSentToday() >= this.getService().getMaxSendablePerDay()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(";");
                }
                stringBuffer.append(stringArray[n]);
            } else {
                try {
                    if (SmsToolkit.isValidPhoneNumber(stringArray[n])) {
                        this.getService().getTransport().send(SmsToolkit.removeSpaceCharacters(stringArray[n]), string);
                        this.getService().setNumberSentToday(this.getService().getNumberSentToday() + 1);
                        this.getService().setLastMessageSentTime(BAbsTime.now());
                    } else {
                        SmsToolkit.log.error(stringArray[n] + " is not a valid number, skipping");
                    }
                }
                catch (Exception exception) {
                    try {
                        SmsToolkit.log.error("Unable to send sms message", (Throwable)exception);
                        bl = true;
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(";");
                        }
                        stringBuffer.append(stringArray[n]);
                    }
                    catch (Exception exception2) {
                        SmsToolkit.log.error("Fatal error. Unable to send sms message", (Throwable)exception2);
                    }
                }
            }
            ++n;
        }
        String string2 = stringBuffer.toString();
        this.setPhoneNumbers(string2);
        if (string2.length() == 0) {
            return true;
        }
        if (this.getService().getNumberSentToday() >= this.getService().getMaxSendablePerDay() && !bl) {
            return false;
        }
        throw new SmsException(SmsToolkit.getText("smsMessage.errorUnsent") + ": " + string2);
    }

    private final BSmsService getService() {
        return (BSmsService)this.getParent().getParent();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BSmsMessage() {
    }

    public BSmsMessage(String string, String string2) {
        this.setPhoneNumbers(string);
        this.setMessage(string2);
    }

    static {
        Class clazz = class$com$tridium$sms$BSmsMessage;
        if (clazz == null) {
            clazz = class$com$tridium$sms$BSmsMessage = BSmsMessage.class("[Lcom.tridium.sms.BSmsMessage;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://sms/res/smsMessage.png");
    }
}

