/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.ImageLoaderListener;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.image.FileFormat;

public class ImageLoader {
    public ImageData[] data;
    public int logicalScreenWidth;
    public int logicalScreenHeight;
    public int backgroundPixel;
    public int repeatCount;
    Vector imageLoaderListeners;

    void reset() {
        this.data = null;
        this.logicalScreenWidth = 0;
        this.logicalScreenHeight = 0;
        this.backgroundPixel = -1;
        this.repeatCount = 1;
    }

    public ImageData[] load(InputStream stream) {
        if (stream == null) {
            SWT.error(4);
        }
        this.reset();
        this.data = FileFormat.load(stream, this);
        return this.data;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ImageData[] load(String filename) {
        if (filename == null) {
            SWT.error(4);
        }
        stream = null;
        try {
            try {
                stream = Compatibility.newFileInputStream(filename);
                var5_3 = this.load(stream);
                var4_4 = null;
            }
            catch (IOException e) {
                SWT.error(39, e);
                ** GOTO lbl-1000
            }
        }
        catch (Throwable var3_11) {
            var4_5 = null;
            try {
                if (stream == null) throw var3_11;
                stream.close();
                throw var3_11;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw var3_11;
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return var5_3;
        }
        if (stream == null) return var5_3;
        stream.close();
        return var5_3;
lbl-1000:
        // 1 sources

        {
            var4_6 = null;
        }
        try {}
        catch (IOException e) {
            return null;
        }
        if (stream == null) return null;
        stream.close();
        return null;
    }

    public void save(OutputStream stream, int format) {
        if (stream == null) {
            SWT.error(4);
        }
        FileFormat.save(stream, format, this);
    }

    public void save(String filename, int format) {
        if (filename == null) {
            SWT.error(4);
        }
        OutputStream stream = null;
        try {
            stream = Compatibility.newFileOutputStream(filename);
        }
        catch (IOException e) {
            SWT.error(39, e);
        }
        this.save(stream, format);
        try {
            stream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void addImageLoaderListener(ImageLoaderListener listener) {
        if (listener == null) {
            SWT.error(4);
        }
        if (this.imageLoaderListeners == null) {
            this.imageLoaderListeners = new Vector();
        }
        this.imageLoaderListeners.addElement(listener);
    }

    public void removeImageLoaderListener(ImageLoaderListener listener) {
        if (listener == null) {
            SWT.error(4);
        }
        if (this.imageLoaderListeners == null) {
            return;
        }
        this.imageLoaderListeners.removeElement(listener);
    }

    public boolean hasListeners() {
        boolean bl = false;
        if (this.imageLoaderListeners != null && this.imageLoaderListeners.size() > 0) {
            bl = true;
        }
        return bl;
    }

    public void notifyListeners(ImageLoaderEvent event) {
        if (!this.hasListeners()) {
            return;
        }
        int size = this.imageLoaderListeners.size();
        int i = 0;
        while (i < size) {
            ImageLoaderListener listener = (ImageLoaderListener)this.imageLoaderListeners.elementAt(i);
            listener.imageDataLoaded(event);
            ++i;
        }
    }

    public ImageLoader() {
        this.reset();
    }
}

