/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import javax.baja.gx.Geom;
import javax.baja.gx.IRectGeom;
import javax.baja.sys.BDouble;

public final class RectGeom
extends Geom
implements IRectGeom {
    public double x;
    public double y;
    public double width;
    public double height;

    public final int getGeomCase() {
        return 2;
    }

    public final double x() {
        return this.x;
    }

    public final double y() {
        return this.y;
    }

    public final double width() {
        return this.width;
    }

    public final double height() {
        return this.height;
    }

    public final void set(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public final void set(IRectGeom r) {
        this.set(r.x(), r.y(), r.width(), r.height());
    }

    public final void translate(double dx, double dy) {
        this.x += dx;
        this.y += dy;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof RectGeom) {
            RectGeom r = (RectGeom)obj;
            boolean bl = false;
            if (this.x == r.x && this.y == r.y && this.width == r.width && this.height == r.height) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final String toString() {
        return BDouble.encode((double)this.x) + ',' + BDouble.encode((double)this.y) + ',' + BDouble.encode((double)this.width) + ',' + BDouble.encode((double)this.height);
    }

    public static final RectGeom intersection(IRectGeom a, IRectGeom b, RectGeom result) {
        return RectGeom.intersection(a.x(), a.y(), a.width(), a.height(), b.x(), b.y(), b.width(), b.height(), result);
    }

    public static final RectGeom intersection(double ax, double ay, double aw, double ah, double bx, double by, double bw, double bh, RectGeom result) {
        double ax2 = ax + aw;
        double ay2 = ay + ah;
        double bx2 = bx + bw;
        double by2 = by + bh;
        if (ax < bx) {
            ax = bx;
        }
        if (ay < by) {
            ay = by;
        }
        if (ax2 > bx2) {
            ax2 = bx2;
        }
        if (ay2 > by2) {
            ay2 = by2;
        }
        ax2 -= ax;
        ay2 -= ay;
        if (result == null) {
            result = new RectGeom();
        }
        result.set(ax, ay, ax2, ay2);
        return result;
    }

    public static final RectGeom bounds(IRectGeom a, IRectGeom b, RectGeom result) {
        return RectGeom.bounds(a.x(), a.y(), a.width(), a.height(), b.x(), b.y(), b.width(), b.height(), result);
    }

    public static final RectGeom bounds(IRectGeom a, double bx, double by, double bw, double bh, RectGeom result) {
        return RectGeom.bounds(a.x(), a.y(), a.width(), a.height(), bx, by, bw, bh, result);
    }

    public static final RectGeom bounds(double ax, double ay, double aw, double ah, double bx, double by, double bw, double bh, RectGeom result) {
        double x1 = Math.min(ax, bx);
        double x2 = Math.max(ax + aw, bx + bw);
        double y1 = Math.min(ay, by);
        double y2 = Math.max(ay + ah, by + bh);
        if (result == null) {
            result = new RectGeom();
        }
        result.set(x1, y1, x2 - x1, y2 - y1);
        return result;
    }

    public RectGeom(IRectGeom r) {
        this.set(r.x(), r.y(), r.width(), r.height());
    }

    public RectGeom(double x, double y, double width, double height) {
        this.set(x, y, width, height);
    }

    public RectGeom(double width, double height) {
        this.set(0.0, 0.0, width, height);
    }

    public RectGeom() {
        this.set(0.0, 0.0, 0.0, 0.0);
    }
}

