/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import javax.baja.gx.Geom;
import javax.baja.gx.IPathGeom;

public final class PathGeom
extends Geom
implements IPathGeom {
    private IPathGeom.Segment[] segments;
    private int size;

    public final int getGeomCase() {
        return 5;
    }

    public final IPathGeom.Segment[] segments() {
        IPathGeom.Segment[] copy = new IPathGeom.Segment[this.size];
        System.arraycopy(this.segments, 0, copy, 0, this.size);
        return copy;
    }

    public final IPathGeom.Segment segment(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.segments[index];
    }

    public final int size() {
        return this.size;
    }

    public final void closePath() {
        this.add(new IPathGeom.ClosePath());
    }

    public final void moveTo(boolean abs, double x, double y) {
        this.add(new IPathGeom.MoveTo(abs, x, y));
    }

    public final void lineTo(boolean abs, double x, double y) {
        this.add(new IPathGeom.LineTo(abs, x, y));
    }

    public final void hlineTo(boolean abs, double x) {
        this.add(new IPathGeom.HLineTo(abs, x));
    }

    public final void vlineTo(boolean abs, double y) {
        this.add(new IPathGeom.VLineTo(abs, y));
    }

    public final void curveTo(boolean abs, double x2, double y2, double x1, double y1, double x, double y) {
        this.add(new IPathGeom.CurveTo(abs, x2, y2, x1, y1, x, y));
    }

    public final void smoothCurveTo(boolean abs, double x2, double y2, double x, double y) {
        this.add(new IPathGeom.SmoothCurveTo(abs, x2, y2, x, y));
    }

    public final void quadTo(boolean abs, double x1, double y1, double x, double y) {
        this.add(new IPathGeom.QuadTo(abs, x1, y1, x, y));
    }

    public final void smoothQuadTo(boolean abs, double x, double y) {
        this.add(new IPathGeom.SmoothQuadTo(abs, x, y));
    }

    public final void arcTo(boolean abs, double rx, double ry, double xAxisRotation, boolean largeArcFlag, boolean sweepFlag, double x, double y) {
        this.add(new IPathGeom.ArcTo(abs, rx, ry, xAxisRotation, largeArcFlag, sweepFlag, x, y));
    }

    public final void add(IPathGeom.Segment segment) {
        if (this.size >= this.segments.length) {
            int newSize = Math.max(this.size * 2, 4);
            IPathGeom.Segment[] temp = new IPathGeom.Segment[newSize];
            System.arraycopy(this.segments, 0, temp, 0, this.size);
            this.segments = temp;
        }
        this.segments[this.size++] = segment;
        this.dirty();
    }

    public final void clear() {
        this.size = 0;
        this.dirty();
    }

    public final boolean equals(Object obj) {
        if (obj instanceof PathGeom) {
            PathGeom o = (PathGeom)obj;
            if (this.size != o.size) {
                return false;
            }
            return PathGeom.equals(this.segments, o.segments, this.size);
        }
        return false;
    }

    public final String toString() {
        return PathGeom.toString(this.segments, this.size);
    }

    static final boolean equals(IPathGeom.Segment[] a, IPathGeom.Segment[] b, int size) {
        int i = 0;
        while (i < size) {
            if (!a[i].equals(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static final String toString(IPathGeom.Segment[] segments, int size) {
        IPathGeom.Segment lastSeg = null;
        char lastCommand = '\u0000';
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < size) {
            IPathGeom.Segment thisSeg;
            char thisCommand;
            if (i > 0) {
                s.append(' ');
            }
            if (lastCommand != (thisCommand = (thisSeg = segments[i]).getCommand())) {
                s.append(thisCommand);
                lastCommand = thisCommand;
            }
            thisSeg.toString(s);
            lastSeg = thisSeg;
            ++i;
        }
        return s.toString();
    }

    public PathGeom(IPathGeom path) {
        this.segments = path.segments();
        this.size = path.size();
    }

    public PathGeom(IPathGeom.Segment[] segments, int size) {
        this.segments = (IPathGeom.Segment[])segments.clone();
        this.size = size;
    }

    public PathGeom() {
        this.segments = new IPathGeom.Segment[10];
        this.size = 0;
    }
}

