/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import com.tridium.gx.parser.Parser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.gx.IPoint;
import javax.baja.gx.Point;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BTransform
extends BSimple {
    public static final int TRANSLATE = 1;
    public static final int SCALE = 2;
    public static final int ROTATE = 3;
    public static final int SKEW_X = 4;
    public static final int SKEW_Y = 5;
    public static final BTransform DEFAULT = BTransform.make(new Transform[0]);
    public static final Type TYPE;
    Transform[] transforms;
    String string;
    BTransform inverse;
    Matrix matrix;
    Object awtSupport;
    static /* synthetic */ Class class$javax$baja$gx$BTransform;

    public static final BTransform make(Transform[] transforms) {
        return new BTransform(transforms);
    }

    public static final BTransform make(Transform transform) {
        return new BTransform(transform);
    }

    public static final BTransform makeTranslate(double x, double y) {
        return BTransform.make(new Translate(x, y));
    }

    public static final BTransform makeScale(double x, double y) {
        return BTransform.make(new Scale(x, y));
    }

    public static final BTransform makeRotate(double angle) {
        return BTransform.make(new Rotate(angle));
    }

    public static final BTransform makeSkewX(double angle) {
        return BTransform.make(new SkewX(angle));
    }

    public static final BTransform makeSkewY(double angle) {
        return BTransform.make(new SkewY(angle));
    }

    public static final BTransform make(String s) {
        Parser parser = new Parser(s);
        BTransform x = parser.parseTransform();
        if (x == null || !parser.isEnd()) {
            throw new IllegalArgumentException(s);
        }
        return x;
    }

    final void calcMatrix() {
        if (this.transforms.length == 1) {
            this.matrix = this.transforms[0].toMatrix();
        } else {
            this.matrix = new Matrix();
            int i = 0;
            while (i < this.transforms.length) {
                this.matrix.multiply(this.transforms[i].toMatrix(), this.matrix);
                ++i;
            }
        }
    }

    public final int size() {
        return this.transforms.length;
    }

    public final Transform getTransform(int index) {
        return this.transforms[index];
    }

    public final Transform[] getTransforms() {
        return (Transform[])this.transforms.clone();
    }

    public final BTransform getInverse() {
        if (this.inverse == null) {
            Transform[] inverses = new Transform[this.transforms.length];
            int i = 0;
            while (i < inverses.length) {
                inverses[i] = this.transforms[this.transforms.length - i - 1].getInverse();
                ++i;
            }
            this.inverse = BTransform.make(inverses);
        }
        return this.inverse;
    }

    public final Point transform(IPoint point, Point result) {
        if (result == null) {
            result = new Point();
        }
        return this.matrix.transform(point, result);
    }

    public final int hashCode() {
        try {
            return this.encodeToString().hashCode();
        }
        catch (Throwable e) {
            return System.identityHashCode((Object)this);
        }
    }

    public final boolean equals(Object obj) {
        if (obj instanceof BTransform) {
            BTransform x = (BTransform)((Object)obj);
            if (this.transforms.length != x.transforms.length) {
                return false;
            }
            int i = 0;
            while (i < this.transforms.length) {
                if (!this.transforms[i].equals(x.transforms[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public final void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public final BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public final String encodeToString() throws IOException {
        if (this.string == null) {
            if (this.transforms.length == 1) {
                this.string = this.transforms[0].toString();
            } else {
                StringBuffer s = new StringBuffer();
                int i = 0;
                while (i < this.transforms.length) {
                    if (i > 0) {
                        s.append(' ');
                    }
                    s.append(this.transforms[i]);
                    ++i;
                }
                this.string = s.toString();
            }
        }
        return this.string;
    }

    public final BObject decodeFromString(String s) throws IOException {
        return BTransform.make(s);
    }

    public final Type getType() {
        return TYPE;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 201: {
                return this.awtSupport;
            }
            case 202: {
                this.awtSupport = a;
                return null;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BTransform(Transform[] transforms) {
        this.transforms = (Transform[])transforms.clone();
        this.calcMatrix();
    }

    private BTransform(Transform transform) {
        this.transforms = new Transform[]{transform};
        this.calcMatrix();
    }

    static {
        Class clazz = class$javax$baja$gx$BTransform;
        if (clazz == null) {
            clazz = class$javax$baja$gx$BTransform = BTransform.class("[Ljavax.baja.gx.BTransform;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    public static class Translate
    extends Transform {
        double x;
        double y;

        public int getTransformCase() {
            return 1;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        Transform getInverse() {
            return new Translate(-this.x, -this.y);
        }

        Matrix toMatrix() {
            Matrix matrix = new Matrix();
            matrix.e = this.x;
            matrix.f = this.y;
            return matrix;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Translate) {
                Translate t = (Translate)obj;
                boolean bl = false;
                if (this.x == t.x && this.y == t.y) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("translate(").append(BDouble.encode((double)this.x));
            if (this.y != 0.0) {
                s.append(',').append(BDouble.encode((double)this.y));
            }
            s.append(')');
            return s.toString();
        }

        public Translate(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }

    public static class Scale
    extends Transform {
        double x;
        double y;

        public int getTransformCase() {
            return 2;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        Transform getInverse() {
            return new Scale(1.0 / this.x, 1.0 / this.y);
        }

        Matrix toMatrix() {
            Matrix matrix = new Matrix();
            matrix.a = this.x;
            matrix.d = this.y;
            return matrix;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Scale) {
                Scale t = (Scale)obj;
                boolean bl = false;
                if (this.x == t.x && this.y == t.y) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("scale(").append(BDouble.encode((double)this.x));
            if (this.y != 0.0) {
                s.append(',').append(BDouble.encode((double)this.y));
            }
            s.append(')');
            return s.toString();
        }

        public Scale(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }

    public static class Rotate
    extends Transform {
        double angle;

        public int getTransformCase() {
            return 3;
        }

        public double getAngle() {
            return this.angle;
        }

        Transform getInverse() {
            return new Rotate(-this.angle);
        }

        Matrix toMatrix() {
            double radians = this.angle / 180.0 * Math.PI;
            Matrix matrix = new Matrix();
            matrix.a = Math.cos(radians);
            matrix.b = Math.sin(radians);
            matrix.c = -Math.sin(radians);
            matrix.d = Math.cos(radians);
            return matrix;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Rotate) {
                Rotate t = (Rotate)obj;
                boolean bl = false;
                if (this.angle == t.angle) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("rotate(").append(BDouble.encode((double)this.angle)).append(')');
            return s.toString();
        }

        public Rotate(double angle) {
            this.angle = angle;
        }
    }

    public static class SkewX
    extends Transform {
        double angle;

        public int getTransformCase() {
            return 4;
        }

        public double getAngle() {
            return this.angle;
        }

        Transform getInverse() {
            return new SkewX(-this.angle);
        }

        Matrix toMatrix() {
            Matrix matrix = new Matrix();
            matrix.c = Math.tan(this.angle / 180.0 * Math.PI);
            return matrix;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SkewX) {
                SkewX t = (SkewX)obj;
                boolean bl = false;
                if (this.angle == t.angle) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("skewX(").append(BDouble.encode((double)this.angle)).append(')');
            return s.toString();
        }

        public SkewX(double angle) {
            this.angle = angle;
        }
    }

    public static class SkewY
    extends Transform {
        double angle;

        public int getTransformCase() {
            return 5;
        }

        public double getAngle() {
            return this.angle;
        }

        Transform getInverse() {
            return new SkewY(-this.angle);
        }

        Matrix toMatrix() {
            Matrix matrix = new Matrix();
            matrix.b = Math.tan(this.angle / 180.0 * Math.PI);
            return matrix;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SkewY) {
                SkewY t = (SkewY)obj;
                boolean bl = false;
                if (this.angle == t.angle) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("skewY(").append(BDouble.encode((double)this.angle)).append(')');
            return s.toString();
        }

        public SkewY(double angle) {
            this.angle = angle;
        }
    }

    public static abstract class Transform {
        public abstract int getTransformCase();

        abstract Transform getInverse();

        abstract Matrix toMatrix();
    }

    static class Matrix {
        double a = 1.0;
        double b;
        double c;
        double d = 1.0;
        double e;
        double f;

        public Point transform(IPoint arg, Point result) {
            double x = arg.x();
            double y = arg.y();
            result.x = this.a * x + this.c * y + this.e;
            result.y = this.b * x + this.d * y + this.f;
            return result;
        }

        public Matrix multiply(Matrix arg, Matrix result) {
            double a = this.a;
            double b = this.b;
            double c = this.c;
            double d = this.d;
            double e = this.e;
            double f = this.f;
            double m = arg.a;
            double n = arg.b;
            double o = arg.c;
            double p = arg.d;
            double q = arg.e;
            double r = arg.f;
            result.a = a * m + c * n;
            result.c = a * o + c * p;
            result.e = a * q + c * r + e;
            result.b = b * m + d * n;
            result.d = b * o + d * p;
            result.f = b * q + d * r + f;
            return result;
        }

        Matrix() {
        }
    }
}

