/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import com.tridium.gx.parser.Parser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BPen
extends BSimple {
    public static final int CAP_BUTT = 101;
    public static final int CAP_SQUARE = 102;
    public static final int CAP_ROUND = 103;
    public static final int JOIN_MITER = 201;
    public static final int JOIN_ROUND = 202;
    public static final int JOIN_BEVEL = 203;
    private static double[] noDash = new double[0];
    public static final BPen DEFAULT = BPen.make(1.0);
    public static final Type TYPE;
    private double width;
    private int cap;
    private int join;
    private double[] dash;
    private String string;
    private Object awtSupport;
    static /* synthetic */ Class class$javax$baja$gx$BPen;

    public static final BPen make(double width) {
        return BPen.make(width, 101, 201, null);
    }

    public static final BPen make(double width, double[] dash) {
        return BPen.make(width, 101, 201, dash);
    }

    public static final BPen make(double width, int cap, int join, double[] dash) {
        return new BPen(width, cap, join, dash);
    }

    public static final BPen make(String s) {
        Parser parser = new Parser(s);
        BPen x = parser.parsePen();
        if (x == null || !parser.isEnd()) {
            throw new IllegalArgumentException(s);
        }
        return x;
    }

    public final double getWidth() {
        return this.width;
    }

    public final int getCap() {
        return this.cap;
    }

    public final int getJoin() {
        return this.join;
    }

    public final double[] getDash() {
        if (this.dash.length == 0) {
            return this.dash;
        }
        return (double[])this.dash.clone();
    }

    public final int hashCode() {
        int n = 0;
        if (this.dash != null) {
            n = this.dash.length;
        }
        int len = n;
        long hash = 23L + (long)len;
        int i = 0;
        while (i < len) {
            hash = hash * 37L + Double.doubleToRawLongBits(this.dash[i]);
            ++i;
        }
        hash = hash * 37L + Double.doubleToRawLongBits(this.width);
        hash = hash * 37L + (long)this.cap;
        hash = hash * 37L + (long)this.join;
        return (int)(hash >>> 32) ^ (int)hash;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof BPen) {
            BPen x = (BPen)((Object)obj);
            if (this.dash.length != x.dash.length) {
                return false;
            }
            int i = 0;
            while (i < this.dash.length) {
                if (this.dash[i] != x.dash[i]) {
                    return false;
                }
                ++i;
            }
            boolean bl = false;
            if (this.width == x.width && this.cap == x.cap && this.join == x.join) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public final BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public final String encodeToString() throws IOException {
        if (this.string == null) {
            StringBuffer s = new StringBuffer();
            s.append(BDouble.encode((double)this.width));
            if (this.cap != 101) {
                s.append(' ').append(this.getCapString());
            }
            if (this.join != 201) {
                s.append(' ').append(this.getJoinString());
            }
            if (this.dash.length > 0) {
                s.append(" dash(");
                int i = 0;
                while (i < this.dash.length) {
                    if (i > 0) {
                        s.append(',');
                    }
                    s.append(BDouble.encode((double)this.dash[i]));
                    ++i;
                }
                s.append(')');
            }
            this.string = s.toString();
        }
        return this.string;
    }

    final String getCapString() {
        switch (this.cap) {
            case 101: {
                return "capButt";
            }
            case 102: {
                return "capSquare";
            }
            case 103: {
                return "capRound";
            }
        }
        throw new IllegalStateException();
    }

    final String getJoinString() {
        switch (this.join) {
            case 201: {
                return "joinMiter";
            }
            case 202: {
                return "joinRound";
            }
            case 203: {
                return "joinBevel";
            }
        }
        throw new IllegalStateException();
    }

    public final BObject decodeFromString(String s) throws IOException {
        return BPen.make(s);
    }

    public final Type getType() {
        return TYPE;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 201: {
                return this.awtSupport;
            }
            case 202: {
                this.awtSupport = a;
                return null;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BPen(double width, int cap, int join, double[] dash) {
        if (width < 0.0) {
            throw new IllegalArgumentException("width " + width);
        }
        if (cap != 101 && cap != 102 && cap != 103) {
            throw new IllegalArgumentException("cap " + cap);
        }
        if (join != 201 && join != 202 && join != 203) {
            throw new IllegalArgumentException("join " + join);
        }
        if (dash == null) {
            dash = noDash;
        }
        this.width = width;
        this.cap = cap;
        this.join = join;
        this.dash = dash;
    }

    static {
        Class clazz = class$javax$baja$gx$BPen;
        if (clazz == null) {
            clazz = class$javax$baja$gx$BPen = BPen.class("[Ljavax.baja.gx.BPen;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

