/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import com.tridium.gx.GxEnv;
import com.tridium.gx.ImagePeer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BImage
extends BSimple {
    public static final BImage NULL;
    public static final BImage DEFAULT;
    public static final Type TYPE;
    private BOrdList ordList;
    private boolean loadLocal;
    private BOrdList absOrdList;
    private ImagePeer peer;
    private Object awtSupport;
    private BImage disabled;
    private BImage highlighted;
    static /* synthetic */ Class class$javax$baja$gx$BImage;

    public static final BImage make(BIcon icon) {
        if (icon == null) {
            return NULL;
        }
        BImage image = (BImage)((Object)icon.fw(203));
        if (image == null) {
            image = BImage.make(icon.getOrdList());
            icon.fw(204, (Object)image, null, null, null);
        }
        return image;
    }

    public static final BImage make(BOrdList ordList) {
        return new BImage(ordList);
    }

    public static final BImage make(BOrd ord) {
        return BImage.make(BOrdList.make((BOrd)ord));
    }

    public static final BImage make(String ordList) {
        if (ordList.equals("null")) {
            return NULL;
        }
        if (ordList.equals("new")) {
            return new BImage(BOrdList.NULL);
        }
        return BImage.make(BOrdList.make((String)ordList));
    }

    public static final BImage make(byte[] buf) {
        return GxEnv.get().makeImage(buf);
    }

    public static final BImage make(double width, double height) {
        return GxEnv.get().makeImage(width, height);
    }

    public final BOrdList getOrdList() {
        return this.ordList;
    }

    public final BOrdList getAbsoluteOrdList() {
        return this.absOrdList;
    }

    public final void setBaseOrd(BOrd baseOrd) {
        if (baseOrd == null || this.loadLocal) {
            this.absOrdList = this.ordList;
        } else {
            BOrd[] ords = this.ordList.toArray();
            int i = 0;
            while (i < ords.length) {
                if (!ords[i].isNull()) {
                    ords[i] = BOrd.make((BOrd)baseOrd, (BOrd)ords[i]).normalize();
                }
                ++i;
            }
            this.absOrdList = BOrdList.make((BOrd[])ords);
        }
        this.awtSupport = null;
        this.peer = null;
    }

    public final boolean isLoaded() {
        return this.peer().isLoaded();
    }

    public final BImage sync() {
        this.peer().sync();
        return this;
    }

    public final boolean animate() {
        return this.peer().animate();
    }

    public final Graphics getGraphics() {
        return this.peer().getGraphics();
    }

    public final double getWidth() {
        return this.peer().getWidth();
    }

    public final double getHeight() {
        return this.peer().getHeight();
    }

    public final int[] getPixels() {
        return this.peer().getPixels();
    }

    public final void setPixels(int[] pixels) {
        this.peer().setPixels(pixels);
    }

    public final void dispose() {
        if (this.awtSupport instanceof ImagePeer) {
            ((ImagePeer)this.awtSupport).dispose();
        }
        if (this.peer != null) {
            this.peer.dispose();
        }
        this.awtSupport = null;
        this.peer = null;
    }

    public final BImage getDisabledImage() {
        if (this.disabled == null) {
            this.disabled = GxEnv.get().makeDisabled(this);
        }
        return this.disabled;
    }

    public final BImage getHighlightedImage() {
        if (this.highlighted == null) {
            this.highlighted = GxEnv.get().makeHighlighted(this);
        }
        return this.highlighted;
    }

    public final BImage transform(BTransform transform) {
        double th;
        double w = this.getWidth();
        double h = this.getHeight();
        Point c0 = transform.transform(new Point(0.0, 0.0), null);
        Point c1 = transform.transform(new Point(w, 0.0), null);
        Point c2 = transform.transform(new Point(w, h), null);
        Point c3 = transform.transform(new Point(0.0, h), null);
        double minw = Math.min(c0.x, Math.min(c1.x, Math.min(c2.x, c3.x)));
        double minh = Math.min(c0.y, Math.min(c1.y, Math.min(c2.y, c3.y)));
        double maxw = Math.max(c0.x, Math.max(c1.x, Math.max(c2.x, c3.x)));
        double maxh = Math.max(c0.y, Math.max(c1.y, Math.max(c2.y, c3.y)));
        double tx = -minw;
        double ty = -minh;
        double tw = maxw - minw;
        if (tw < 1.0) {
            tw = 1.0;
        }
        if ((th = maxh - minh) < 1.0) {
            th = 1.0;
        }
        BImage buf = BImage.make(tw, th);
        Graphics g = buf.getGraphics();
        g.translate(tx, ty);
        g.transform(transform);
        g.drawImage(this, 0.0, 0.0);
        return buf;
    }

    public final boolean isNull() {
        boolean bl = false;
        if (this == NULL) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        return this.ordList.hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BImage) {
            BImage x = (BImage)((Object)obj);
            if (this.ordList.isNull() || x.ordList.isNull()) {
                return false;
            }
            return this.ordList.equals((Object)x.ordList);
        }
        return false;
    }

    public final void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public final BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public final String encodeToString() {
        if (this.isNull()) {
            return "null";
        }
        return this.ordList.encodeToString();
    }

    public final BObject decodeFromString(String s) throws IOException {
        return BImage.make(s);
    }

    public final Type getType() {
        return TYPE;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 201: {
                return this.awtSupport;
            }
            case 202: {
                this.awtSupport = a;
                return null;
            }
            case 205: {
                this.setBaseOrd((BOrd)a);
                return null;
            }
            case 206: {
                return this.peer();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private final ImagePeer peer() {
        if (this.peer == null) {
            this.peer = GxEnv.get().makeImagePeer(this);
        }
        return this.peer;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BImage(BOrdList ordList) {
        this.ordList = ordList;
        this.absOrdList = ordList;
        this.loadLocal = ordList.toString().startsWith("module:");
    }

    static {
        DEFAULT = NULL = BImage.make(BOrdList.NULL);
        Class clazz = class$javax$baja$gx$BImage;
        if (clazz == null) {
            clazz = class$javax$baja$gx$BImage = BImage.class("[Ljavax.baja.gx.BImage;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

