/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import com.tridium.gx.FontPeer;
import com.tridium.gx.GxEnv;
import com.tridium.gx.parser.Parser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Hashtable;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BFont
extends BSimple {
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNDERLINE = 4;
    private static Hashtable cache = new Hashtable();
    public static final BFont DEFAULT = BFont.make("sans-serif", 12.0);
    public static final BFont NULL = new BFont("null", 0.0, 0, "null");
    public static final Type TYPE;
    private String name;
    private double size;
    private int style;
    private boolean antiAliased;
    private String string;
    private FontPeer peer;
    private Object awtSupport;
    static /* synthetic */ Class class$javax$baja$gx$BFont;

    public static final BFont make(String name, double size) {
        return BFont.make(name, size, 0);
    }

    public static final BFont make(String name, double size, int style) {
        if (name == null || (style & 0xFFFFFFF8) != 0) {
            throw new IllegalArgumentException();
        }
        StringBuffer s = new StringBuffer();
        if ((style & 1) != 0) {
            s.append("bold ");
        }
        if ((style & 2) != 0) {
            s.append("italic ");
        }
        if ((style & 4) != 0) {
            s.append("underline ");
        }
        s.append(BDouble.encode((double)size)).append("pt ");
        s.append(name);
        String string = s.toString();
        BFont font = (BFont)((Object)cache.get(string));
        if (font == null) {
            font = new BFont(name, size, style, string);
            cache.put(string, font);
        }
        return font;
    }

    public static final BFont make(String s) {
        Parser parser = new Parser(s);
        BFont x = parser.parseFont();
        if (x == null || !parser.isEnd()) {
            throw new IllegalArgumentException(s);
        }
        return x;
    }

    public static final BFont make(BFont font, int style) {
        return BFont.make(font.getName(), font.getSize(), style);
    }

    public static final BFont make(BFont font, double size) {
        return BFont.make(font.getName(), size, font.getStyle());
    }

    public final String getName() {
        return this.name;
    }

    public final double getSize() {
        return this.size;
    }

    public final int getStyle() {
        return this.style;
    }

    public final boolean isBold() {
        boolean bl = false;
        if ((this.style & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isItalic() {
        boolean bl = false;
        if ((this.style & 2) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isUnderline() {
        boolean bl = false;
        if ((this.style & 4) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isAntiAliased() {
        return this.antiAliased;
    }

    public final double getLeading() {
        return this.peer().getLeading();
    }

    public final double getAscent() {
        return this.peer().getAscent();
    }

    public final double getDescent() {
        return this.peer().getDescent();
    }

    public final double getHeight() {
        return this.peer().getHeight();
    }

    public final double getMaxAscent() {
        return this.peer().getMaxAscent();
    }

    public final double getMaxDescent() {
        return this.peer().getMaxDescent();
    }

    public final double width(int c) {
        return this.peer().width(c);
    }

    public final double width(String s) {
        if (s == null) {
            return 0.0;
        }
        return this.peer().width(s);
    }

    public final double width(char[] data, int off, int len) {
        return this.peer().width(data, off, len);
    }

    public final boolean isNull() {
        boolean bl = false;
        if (this == NULL) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        return this.string.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj instanceof BFont) {
            return this.string.equals(((BFont)((Object)obj)).string);
        }
        return false;
    }

    public final void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public final BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public final String encodeToString() throws IOException {
        return this.string;
    }

    public final BObject decodeFromString(String s) throws IOException {
        return BFont.make(s);
    }

    public final Type getType() {
        return TYPE;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 201: {
                return this.awtSupport;
            }
            case 202: {
                this.awtSupport = a;
                return null;
            }
            case 206: {
                return this.peer();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    final FontPeer peer() {
        if (this.peer == null) {
            this.peer = GxEnv.get().makeFontPeer(this);
        }
        return this.peer;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.antiAliased = true;
    }

    private BFont(String name, double size, int style, String string) {
        this.this();
        this.name = name;
        this.size = size;
        this.style = style;
        this.string = string;
        this.antiAliased = true;
    }

    static {
        cache.put("null", NULL);
        Class clazz = class$javax$baja$gx$BFont;
        if (clazz == null) {
            clazz = class$javax$baja$gx$BFont = BFont.class("[Ljavax.baja.gx.BFont;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

