/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import com.tridium.gx.parser.Parser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BPoint;
import javax.baja.gx.IPoint;
import javax.baja.naming.BOrd;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBrush
extends BSimple {
    public static final int PAD = 1;
    public static final int REFLECT = 2;
    public static final int REPEAT = 3;
    public static final int TILE_FALSE = 0;
    public static final int TILE_TRUE = 1;
    public static final int TILE_X = 2;
    public static final int TILE_Y = 3;
    public static final int CENTER = 0;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final BBrush NULL = BBrush.makeSolid(BColor.NULL);
    public static final BBrush DEFAULT = BBrush.makeSolid(BColor.black);
    public static final Type TYPE;
    private Paint paint;
    private Object awtSupport;
    static /* synthetic */ Class class$javax$baja$gx$BBrush;

    public static final BBrush makeSolid(BColor solid) {
        if (solid.brush == null) {
            solid.brush = new BBrush(new Solid(solid));
        }
        return solid.brush;
    }

    public static final BBrush makeInverse(BColor inverse) {
        return new BBrush(new Inverse(inverse));
    }

    public static final BBrush makeLinearGradient(Stop[] stops) {
        return BBrush.makeLinearGradient(stops, 1, 0.0);
    }

    public static final BBrush makeLinearGradient(Stop[] stops, int spread, double angle) {
        return new BBrush(new LinearGradient(stops, spread, angle));
    }

    public static final BBrush makeRadialGradient(Stop[] stops) {
        return BBrush.makeRadialGradient(stops, 1, BPoint.make(50.0, 50.0), 50.0);
    }

    public static final BBrush makeRadialGradient(Stop[] stops, int spread, IPoint center, double radius) {
        return BBrush.makeRadialGradient(stops, spread, center, radius, center);
    }

    public static final BBrush makeRadialGradient(Stop[] stops, int spread, IPoint center, double radius, IPoint focal) {
        return new BBrush(new RadialGradient(stops, spread, center, radius, focal));
    }

    public static final BBrush makeImage(BImage image, int tile, int halign, int valign) {
        return new BBrush(new Image(image, tile, halign, valign));
    }

    public static final BBrush makeImage(BImage image) {
        return BBrush.makeImage(image, 0, 0, 0);
    }

    public static final BBrush make(String s) {
        Parser parser = new Parser(s);
        BBrush x = parser.parseBrush();
        if (x == null || !parser.isEnd()) {
            throw new IllegalArgumentException(s);
        }
        return x;
    }

    public final Paint getPaint() {
        return this.paint;
    }

    public final boolean isNull() {
        boolean bl = false;
        if (this == NULL) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        String paintStr = this.paint != null ? this.paint.toString() : null;
        int n = 0;
        if (paintStr != null) {
            n = paintStr.hashCode();
        }
        return n;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof BBrush) {
            return this.paint.equals(((BBrush)((Object)obj)).paint);
        }
        return false;
    }

    public final void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public final BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public final String encodeToString() throws IOException {
        return this.paint.toString();
    }

    public final BObject decodeFromString(String s) throws IOException {
        return BBrush.make(s);
    }

    public static final Stop stop(double offset, BColor color) {
        return new Stop(offset, color);
    }

    public final Type getType() {
        return TYPE;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 201: {
                return this.awtSupport;
            }
            case 202: {
                this.awtSupport = a;
                return null;
            }
            case 205: {
                this.setBaseOrd((BOrd)a);
                return null;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private final void setBaseOrd(BOrd baseOrd) {
        if (this.paint instanceof Image) {
            BImage img = ((Image)this.paint).getImage();
            img.setBaseOrd(baseOrd);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BBrush(Paint paint) {
        this.paint = paint;
    }

    static {
        Class clazz = class$javax$baja$gx$BBrush;
        if (clazz == null) {
            clazz = class$javax$baja$gx$BBrush = BBrush.class("[Ljavax.baja.gx.BBrush;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    public static class Solid
    extends Paint {
        final BColor color;

        public BColor getColor() {
            return this.color;
        }

        public boolean equals(Object obj) {
            boolean bl = false;
            if (this.getClass() == obj.getClass() && this.color.equals((Object)((Solid)obj).color)) {
                bl = true;
            }
            return bl;
        }

        public String toString() {
            return this.color.encodeToString();
        }

        Solid(BColor color) {
            this.color = color;
        }
    }

    public static class Inverse
    extends Solid {
        public String toString() {
            return "inverse(" + this.color.encodeToString() + ')';
        }

        Inverse(BColor color) {
            super(color);
        }
    }

    public static class LinearGradient
    extends Gradient {
        final double angle;

        public double getAngle() {
            return this.angle;
        }

        boolean doEquals(Gradient g) {
            LinearGradient x = (LinearGradient)g;
            boolean bl = false;
            if (this.angle == x.angle) {
                bl = true;
            }
            return bl;
        }

        String getStringStart() {
            return "linearGradient";
        }

        void doString(StringBuffer s) {
            if (this.angle != 0.0) {
                s.append(" angle(").append(BDouble.encode((double)this.angle)).append(')');
            }
        }

        LinearGradient(Stop[] stops, int spread, double angle) {
            super(stops, spread);
            this.angle = angle;
        }
    }

    public static class RadialGradient
    extends Gradient {
        final BPoint center;
        final double radius;
        final BPoint focal;

        public BPoint getCenter() {
            return this.center;
        }

        public double getRadius() {
            return this.radius;
        }

        public BPoint getFocal() {
            return this.focal;
        }

        boolean doEquals(Gradient g) {
            RadialGradient x = (RadialGradient)g;
            boolean bl = false;
            if (this.center.equals(x.center) && this.radius == x.radius && this.focal.equals(x.focal)) {
                bl = true;
            }
            return bl;
        }

        String getStringStart() {
            return "radialGradient";
        }

        void doString(StringBuffer s) {
            if (this.center.x != 50.0 || this.center.y != 50.0) {
                s.append(" c(").append(BDouble.encode((double)this.center.x)).append("% ").append(BDouble.encode((double)this.center.y)).append("%)");
            }
            if (this.radius != 50.0) {
                s.append(" r(").append(BDouble.encode((double)this.radius)).append("%)");
            }
            if (this.focal.x != this.center.x || this.focal.y != this.center.y) {
                s.append(" f(").append(BDouble.encode((double)this.focal.x)).append("% ").append(BDouble.encode((double)this.focal.y)).append("%)");
            }
        }

        RadialGradient(Stop[] stops, int spread, IPoint center, double radius, IPoint focal) {
            super(stops, spread);
            this.center = BPoint.make(center);
            this.radius = radius;
            this.focal = BPoint.make(focal);
        }
    }

    public static class Image
    extends Paint {
        final BImage image;
        final int tile;
        final int halign;
        final int valign;
        String string;

        public BImage getImage() {
            return this.image;
        }

        public int getTile() {
            return this.tile;
        }

        public int getHalign() {
            return this.halign;
        }

        public int getValign() {
            return this.valign;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Image) {
                Image x = (Image)obj;
                boolean bl = false;
                if (this.image.equals((Object)x.image) && this.tile == x.tile && this.halign == x.halign && this.valign == x.valign) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public String toString() {
            if (this.string == null) {
                StringBuffer s = new StringBuffer();
                String source = this.image.toString();
                s.append("image( source(").append(source).append(") ");
                switch (this.tile) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        s.append("tile(true) ");
                        break;
                    }
                    case 2: {
                        s.append("tile(x) ");
                        break;
                    }
                    case 3: {
                        s.append("tile(y) ");
                        break;
                    }
                }
                switch (this.halign) {
                    case 3: {
                        s.append("halign(left) ");
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 4: {
                        s.append("halign(right) ");
                        break;
                    }
                }
                switch (this.valign) {
                    case 1: {
                        s.append("valign(top) ");
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 2: {
                        s.append("valign(bottom) ");
                        break;
                    }
                }
                s.append(")");
                this.string = s.toString();
            }
            return this.string;
        }

        Image(BImage image, int tile, int halign, int valign) {
            if (image == null) {
                throw new NullPointerException("image");
            }
            if (tile != 1 && tile != 0 && tile != 2 && tile != 3) {
                throw new IllegalArgumentException("tile");
            }
            if (halign != 3 && halign != 0 && halign != 4) {
                throw new IllegalArgumentException("halign");
            }
            if (valign != 1 && valign != 0 && valign != 2) {
                throw new IllegalArgumentException("valign");
            }
            this.image = image;
            this.tile = tile;
            this.halign = halign;
            this.valign = valign;
        }
    }

    public static abstract class Paint {
        public abstract String toString();

        Paint() {
        }
    }

    public static final class Stop {
        final double offset;
        final BColor color;

        public final double getOffset() {
            return this.offset;
        }

        public final BColor getColor() {
            return this.color;
        }

        public final boolean equals(Object obj) {
            if (obj instanceof Stop) {
                Stop x = (Stop)obj;
                boolean bl = false;
                if (this.offset == x.offset && this.color.equals((Object)x.color)) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public final String toString() {
            return "stop(" + BDouble.encode((double)this.offset) + "% " + (Object)((Object)this.color) + ')';
        }

        Stop(double offset, BColor color) {
            if (color == null) {
                throw new NullPointerException();
            }
            this.offset = offset;
            this.color = color;
        }
    }

    public static abstract class Gradient
    extends Paint {
        final Stop[] stops;
        final int spread;
        String string;

        public Stop[] getStops() {
            return (Stop[])this.stops.clone();
        }

        public int getSpread() {
            return this.spread;
        }

        public final boolean equals(Object obj) {
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Gradient x = (Gradient)obj;
            if (this.spread != x.spread) {
                return false;
            }
            if (this.stops.length != x.stops.length) {
                return false;
            }
            int i = 0;
            while (i < this.stops.length) {
                if (!this.stops[i].equals(x.stops[i])) {
                    return false;
                }
                ++i;
            }
            return this.doEquals(x);
        }

        abstract boolean doEquals(Gradient var1);

        public final String toString() {
            if (this.string == null) {
                StringBuffer s = new StringBuffer(64);
                s.append(this.getStringStart());
                s.append('(');
                if (this.spread == 2) {
                    s.append(" reflect");
                } else if (this.spread == 3) {
                    s.append(" repeat");
                }
                this.doString(s);
                int i = 0;
                while (i < this.stops.length) {
                    s.append(' ').append(this.stops[i]);
                    ++i;
                }
                s.append(" )");
                this.string = s.toString();
            }
            return this.string;
        }

        abstract String getStringStart();

        abstract void doString(StringBuffer var1);

        Gradient(Stop[] stops, int spread) {
            if (spread != 1 && spread != 2 && spread != 3) {
                throw new IllegalArgumentException("spread");
            }
            this.stops = (Stop[])stops.clone();
            this.spread = spread;
        }
    }
}

