/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.gx.IPoint;
import javax.baja.gx.Point;

public class PointMap {
    private int searchRadius;
    private Map xTree;

    public Object put(double x, double y, Object value) {
        PointKey xKey = new PointKey((int)x, this.searchRadius);
        PointKey yKey = new PointKey((int)y, this.searchRadius);
        TreeMap<PointKey, Object> yTree = (TreeMap<PointKey, Object>)this.xTree.get(xKey);
        if (yTree == null) {
            yTree = new TreeMap<PointKey, Object>();
            this.xTree.put(xKey, yTree);
        }
        return yTree.put(yKey, value);
    }

    public Object get(double x, double y) {
        PointKey xKey = new PointKey((int)x, this.searchRadius);
        PointKey yKey = new PointKey((int)y, this.searchRadius);
        Map yTree = (Map)this.xTree.get(xKey);
        if (yTree == null) {
            return null;
        }
        return yTree.get(yKey);
    }

    public IPoint[] getKeys() {
        ArrayList<Point> keys = new ArrayList<Point>();
        Iterator itx = this.xTree.keySet().iterator();
        while (itx.hasNext()) {
            PointKey xKey = (PointKey)itx.next();
            Map yTree = (Map)this.xTree.get(xKey);
            Iterator ity = yTree.keySet().iterator();
            while (ity.hasNext()) {
                PointKey yKey = (PointKey)ity.next();
                keys.add(new Point(xKey.val, yKey.val));
            }
        }
        return keys.toArray(new Point[0]);
    }

    public Object[] getValues() {
        ArrayList values = new ArrayList();
        Iterator itx = this.xTree.keySet().iterator();
        while (itx.hasNext()) {
            PointKey xKey = (PointKey)itx.next();
            Map yTree = (Map)this.xTree.get(xKey);
            Iterator ity = yTree.keySet().iterator();
            while (ity.hasNext()) {
                PointKey yKey = (PointKey)ity.next();
                values.add(yTree.get(yKey));
            }
        }
        return values.toArray(new Object[0]);
    }

    public PointMap(int searchRadius) {
        this.searchRadius = searchRadius;
        this.xTree = new TreeMap();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class PointKey
    implements Comparable {
        int val;
        int fudgeFactor;

        public int compareTo(Object o) {
            PointKey treeKey = (PointKey)o;
            if (Math.abs(this.val - treeKey.val) <= this.fudgeFactor) {
                return 0;
            }
            return this.val - treeKey.val;
        }

        public boolean equals(Object obj) {
            boolean bl = false;
            if (this.compareTo(obj) == 0) {
                bl = true;
            }
            return bl;
        }

        private PointKey(int val, int fudgeFactor) {
            this.val = val;
            this.fudgeFactor = fudgeFactor;
        }
    }
}

