/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.util;

import javax.baja.gx.IRectGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;

public abstract class GeomUtil {
    public static final double NEAR = 3.0;

    public static int nearest(Point pnt, Point[] segs, boolean closed) {
        double d;
        double dist = GeomUtil.dist(pnt, segs[0], segs[1]);
        int idx = 0;
        int i = 1;
        while (i < segs.length - 1) {
            double d2 = GeomUtil.dist(pnt, segs[i], segs[i + 1]);
            if (d2 < dist) {
                dist = d2;
                idx = i;
            }
            ++i;
        }
        if (closed && (d = GeomUtil.dist(pnt, segs[segs.length - 1], segs[0])) < dist) {
            dist = d;
            idx = segs.length - 1;
        }
        return idx;
    }

    public static double dist(Point pnt, Point[] segs) {
        double dist = GeomUtil.dist(pnt, segs[0], segs[1]);
        int i = 1;
        while (i < segs.length - 1) {
            dist = Math.min(dist, GeomUtil.dist(pnt, segs[i], segs[i + 1]));
            ++i;
        }
        return dist;
    }

    public static double dist(Point pntA, Point pnt1, Point pnt2) {
        double dist;
        if (pnt1.equals(pnt2)) {
            dist = GeomUtil.dist(pntA, pnt1);
        } else if (pnt1.y == pnt2.y) {
            double minX = Math.min(pnt1.x, pnt2.x);
            double maxX = Math.max(pnt1.x, pnt2.x);
            dist = pntA.x < minX || pntA.x > maxX ? Math.min(GeomUtil.dist(pntA, pnt1), GeomUtil.dist(pntA, pnt2)) : Math.abs(pntA.y - pnt1.y);
        } else if (pnt1.x == pnt2.x) {
            double minY = Math.min(pnt1.y, pnt2.y);
            double maxY = Math.max(pnt1.y, pnt2.y);
            dist = pntA.y < minY || pntA.y > maxY ? Math.min(GeomUtil.dist(pntA, pnt1), GeomUtil.dist(pntA, pnt2)) : Math.abs(pntA.x - pnt1.x);
        } else {
            Point foot = GeomUtil.getFoot(pntA, pnt1, pnt2);
            double minX = Math.min(pnt1.x, pnt2.x);
            double maxX = Math.max(pnt1.x, pnt2.x);
            dist = foot.x >= minX && foot.x <= maxX ? GeomUtil.dist(pntA, foot) : Math.min(GeomUtil.dist(pntA, pnt1), GeomUtil.dist(pntA, pnt2));
        }
        return dist;
    }

    public static double dist(Point pntA, Point pntB) {
        return Math.sqrt(Math.pow(pntA.x - pntB.x, 2) + Math.pow(pntA.y - pntB.y, 2));
    }

    public static RectGeom makeRectangle(double X0, double Y0, double X1, double Y1) {
        double minX = Math.min(X0, X1);
        double minY = Math.min(Y0, Y1);
        double maxX = Math.max(X0, X1);
        double maxY = Math.max(Y0, Y1);
        return new RectGeom(minX, minY, maxX - minX, maxY - minY);
    }

    public static boolean contains(IRectGeom outer, IRectGeom inner) {
        if (GeomUtil.isDegenerate(outer)) {
            return false;
        }
        if (GeomUtil.isDegenerate(inner)) {
            boolean bl = false;
            if (outer.contains(inner.x(), inner.y()) && outer.contains(inner.x() + inner.width(), inner.y() + inner.height())) {
                bl = true;
            }
            return bl;
        }
        return outer.contains(inner);
    }

    private static final boolean isDegenerate(IRectGeom rect) {
        boolean bl = false;
        if (rect.width() == 0.0 || rect.height() == 0.0) {
            bl = true;
        }
        return bl;
    }

    private static final Point getFoot(Point pntA, Point pnt1, Point pnt2) {
        if (pnt1.equals(pnt2)) {
            throw new IllegalArgumentException();
        }
        if (pnt1.y == pnt2.y) {
            return new Point(pntA.x, pnt1.y);
        }
        if (pnt1.x == pnt2.x) {
            return new Point(pnt1.x, pntA.y);
        }
        double m = (pnt1.y - pnt2.y) / (pnt1.x - pnt2.x);
        double b = pnt1.y - m * pnt1.x;
        double fX = (m * pntA.y + pntA.x - m * b) / (m * m + 1.0);
        double fY = (m * m * pntA.y + m * pntA.x + b) / (m * m + 1.0);
        return new Point(fX, fY);
    }
}

