/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.micro.awt;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.baja.sys.Sys;

public class MicroFontWriter {
    boolean verbose = false;
    boolean moreVerbose = false;
    Font[] defaultFonts = new Font[]{new Font("Arial", 0, 16), new Font("Arial", 1, 16), new Font("Arial", 2, 16), new Font("Arial", 3, 16), new Font("Courier New", 0, 12), new Font("Courier New", 1, 12), new Font("Courier New", 2, 12), new Font("Courier New", 3, 12), new Font("Tahoma", 0, 11), new Font("Tahoma", 1, 11), new Font("Tahoma", 2, 11), new Font("Tahoma", 3, 11)};
    Font[] asianFonts = new Font[]{new Font("Arial Unicode MS", 0, 12), new Font("NSimSun", 0, 12), new Font("MS Mincho", 0, 12), new Font("GulimChe", 0, 12), new Font("Gulim", 0, 12)};
    String[] asianPdfFontNames = new String[]{"STSong-Light", "STSong-Light", "KozMinPro-Regular", "HYGoThic-Medium", "HYGoThic-Medium"};

    public void run() {
        System.out.println("------------------------");
        System.out.println("  MicroFontWriter 3000  ");
        System.out.println("------------------------");
        this.generateFontFiles(this.defaultFonts, false);
        this.generateFontFiles(this.asianFonts, true);
    }

    private void generateFontFiles(Font[] fonts, boolean useGlyphCount) {
        for (int i = 0; i < fonts.length; ++i) {
            try {
                System.out.println("[" + this.toStr(fonts[i]) + "]");
                System.out.println(" family: " + fonts[i].getFamily());
                FontInfo info = this.makeFontInfo(fonts[i]);
                this.header(info, useGlyphCount);
                this.glyphs(info, useGlyphCount);
                this.pdf(info, useGlyphCount);
                info.out.flush();
                info.out.close();
                continue;
            }
            catch (Exception e) {
                System.out.println(" ### FAILED: " + this.toStr(fonts[i]) + " ####");
                e.printStackTrace();
            }
        }
    }

    private FontInfo makeFontInfo(Font font) throws Exception {
        FontInfo info = new FontInfo();
        info.name = this.toStr(font);
        info.font = font;
        info.fm = Toolkit.getDefaultToolkit().getFontMetrics(info.font);
        String path = "d:\\niagara\\r38\\util\\kits\\fonts\\src\\" + info.name + ".font";
        info.out = new OutStream(new GZIPOutputStream(new FileOutputStream(path)));
        return info;
    }

    private void header(FontInfo info, boolean useGlyphCount) throws Exception {
        int gc = 256;
        if (useGlyphCount) {
            gc = info.font.getNumGlyphs();
        }
        int ver = 1;
        int fl = info.fm.getLeading();
        int fh = info.fm.getHeight();
        int fa = info.fm.getAscent();
        int fd = info.fm.getDescent();
        if (this.verbose) {
            System.out.println("  - glyphs:  " + gc);
            System.out.println("  - ver:     " + ver);
            System.out.println("  - leading: " + fl);
            System.out.println("  - height:  " + fh);
            System.out.println("  - ascent:  " + fa);
            System.out.println("  - descent: " + fd);
        }
        info.out.u2(gc);
        info.out.u1(ver);
        info.out.u1(fl);
        info.out.u1(fh);
        info.out.u1(fa);
        info.out.u1(fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void glyphs(FontInfo info, boolean useGlyphCount) throws Exception {
        BufferedImage img = new BufferedImage(100, 100, 2);
        Graphics g = img.getGraphics();
        try {
            char gc = '\u0100';
            if (useGlyphCount) {
                gc = info.font.getNumGlyphs();
            }
            for (char ch = '\u0000'; ch < gc; ch = (char)(ch + '\u0001')) {
                int[] pixels;
                int len;
                String s = "" + ch;
                int w = info.fm.stringWidth(s);
                int h = info.fm.getHeight();
                g.setColor(Color.BLACK);
                g.fillRect(0, 0, 100, 100);
                g.setColor(Color.WHITE);
                g.setFont(info.font);
                g.drawString(s, 0, info.fm.getAscent());
                if (w < 0) {
                    w *= -1;
                }
                if ((len = (pixels = this.getPixels(img, w, h)).length) > 65535) {
                    System.out.println("glyph buf len too big: " + len + "; w,h=" + w + "," + h);
                    throw new RuntimeException("glyph buf len too big: " + len + "; w,h=" + w + "," + h);
                }
                info.out.u2(len);
                for (int j = 0; j < h; ++j) {
                    for (int i = 0; i < w; ++i) {
                        int v;
                        int n = v = pixels[j * w + i] == -16777216 ? 0 : 1;
                        if (this.moreVerbose) {
                            System.out.print(v == 1 ? "#" : ".");
                        }
                        info.out.u1(v);
                    }
                    if (!this.moreVerbose) continue;
                    System.out.print("\n");
                }
                if (!this.moreVerbose) continue;
                System.out.print("\n");
            }
        }
        finally {
            g.dispose();
        }
    }

    private int[] getPixels(Image img, int w, int h) throws Exception {
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, w, h, pixels, 0, w);
        pg.grabPixels();
        return pixels;
    }

    private void pdf(FontInfo info, boolean useGlyphCount) throws Exception {
        Font f = new Font(info.font.getName(), info.font.getStyle(), 72);
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(f);
        String ps = f.getPSName();
        int fl = fm.getLeading();
        int fh = fm.getHeight();
        int fa = fm.getAscent();
        int fd = fm.getDescent();
        if (this.verbose) {
            System.out.println("  - pdf.psName:  " + ps);
            System.out.println("  - pdf.leading: " + fl);
            System.out.println("  - pdf.height:  " + fh);
            System.out.println("  - pdf.ascent:  " + fa);
            System.out.println("  - pdf.descent: " + fd);
        }
        info.out.utf(ps);
        info.out.u1(fl);
        info.out.u1(fh);
        info.out.u1(fa);
        info.out.u1(fd);
        int gc = 256;
        if (useGlyphCount) {
            gc = info.font.getNumGlyphs();
        }
        for (int i = 0; i < gc; ++i) {
            info.out.u1(fm.charWidth((char)i));
        }
    }

    private String toStr(Font font) {
        return this.getStyle(font) + font.getSize() + "pt " + font.getName();
    }

    private String getStyle(Font font) {
        int s = font.getStyle();
        if ((s & 3) == 3) {
            return "bold italic ";
        }
        if ((s & 2) == 2) {
            return "italic ";
        }
        if ((s & 1) == 1) {
            return "bold ";
        }
        return "";
    }

    public static void main(String[] args) {
        Sys.getRegistry().getModules();
        MicroFontWriter w = new MicroFontWriter();
        if (args.length > 0) {
            if (args[0].equals("-v")) {
                w.verbose = true;
            }
            if (args[0].equals("-vv")) {
                w.verbose = true;
                w.moreVerbose = true;
            }
        }
        w.run();
    }

    class OutStream
    extends DataOutputStream {
        public OutStream(OutputStream stream) {
            super(stream);
        }

        public void u1(int b) throws IOException {
            this.write(0xFF & b);
        }

        public void u2(int b) throws IOException {
            this.write(0xFF & b >> 8);
            this.write(0xFF & b);
        }

        public void utf(String s) throws IOException {
            this.writeUTF(s);
        }
    }

    class FontInfo {
        public String name;
        public Font font;
        public FontMetrics fm;
        public OutStream out;

        FontInfo() {
        }
    }
}

