/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.micro;

import com.tridium.gx.ImagePeer;
import com.tridium.gx.micro.MicroEnv;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MicroImagePeer
implements ImagePeer {
    double width;
    double height;
    int[] data;
    BImage image;

    public Graphics getGraphics() {
        return null;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public boolean animate() {
        return false;
    }

    public void dispose() {
        this.data = null;
        this.height = 0.0;
        this.width = 0.0;
    }

    public boolean isLoaded() {
        boolean bl = false;
        if (this.data != null) {
            bl = true;
        }
        return bl;
    }

    public void sync() {
        if (this.image.getOrdList().isNull() || this.image.getOrdList().size() == 0) {
            return;
        }
        BOrd ord = this.image.getOrdList().get(0);
        try {
            BIFile file = (BIFile)ord.resolve().get();
            ImageLoader loader = new ImageLoader();
            ImageData imageData = loader.load(file.getInputStream())[0];
            this.height = imageData.height;
            this.width = imageData.width;
            this.data = new int[(int)(this.width * this.height)];
            int[] scanline = new int[imageData.width];
            int y = 0;
            while (y < imageData.height) {
                imageData.getPixels(0, y, imageData.width, scanline, 0);
                int x = 0;
                while (x < scanline.length) {
                    int blue;
                    int green;
                    int red;
                    int alpha = imageData.alpha != -1 ? imageData.alpha : (imageData.alphaData != null ? imageData.alphaData[x + y * imageData.width] : 255);
                    if (imageData.palette.isDirect) {
                        int pixel = scanline[x];
                        red = pixel & imageData.palette.redMask;
                        red = imageData.palette.redShift < 0 ? red >>> -imageData.palette.redShift : red << imageData.palette.redShift;
                        green = pixel & imageData.palette.greenMask;
                        green = imageData.palette.greenShift < 0 ? green >>> -imageData.palette.greenShift : green << imageData.palette.greenShift;
                        blue = pixel & imageData.palette.blueMask;
                        blue = imageData.palette.blueShift < 0 ? blue >>> -imageData.palette.blueShift : blue << imageData.palette.blueShift;
                    } else {
                        RGB rgb = imageData.palette.getRGBs()[scanline[x]];
                        red = rgb.red;
                        green = rgb.green;
                        blue = rgb.blue;
                    }
                    this.data[x + y * imageData.width] = (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
                    ++x;
                }
                ++y;
            }
        }
        catch (UnresolvedException e) {
            if (MicroEnv.log.isLoggable(2)) {
                MicroEnv.log.warning("MicroEnv: Cannot resolve image \"" + ord + '\"', (Throwable)e);
            }
            e.printStackTrace();
        }
        catch (Throwable e) {
            if (MicroEnv.log.isTraceOn()) {
                MicroEnv.log.error("MicroEnv: Cannot load image \"" + ord + '\"', e);
            }
            e.printStackTrace();
        }
    }

    public int[] getPixels() {
        if (this.data == null) {
            return new int[0];
        }
        int[] copy = new int[this.data.length];
        System.arraycopy(this.data, 0, copy, 0, this.data.length);
        return copy;
    }

    public void setPixels(int[] pixels) {
        if ((double)pixels.length != this.width * this.height) {
            throw new IllegalStateException("MicroImagePeer: pixels.length != width x height");
        }
        this.data = pixels;
    }

    private final /* synthetic */ void this() {
        this.width = 0.0;
        this.height = 0.0;
        this.data = null;
    }

    private MicroImagePeer() throws Exception {
        this.this();
    }

    public MicroImagePeer(BImage image) {
        this.this();
        this.image = image;
    }
}

