/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.micro;

import com.tridium.gx.micro.MicroFont;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.gx.BFont;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.Sys;

public class MicroFontReader {
    private static BIFile[] files;
    static HashMap cache;
    static boolean verbose;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MicroFont read(BFont bfont) {
        mfont = (MicroFont)MicroFontReader.cache.get((Object)bfont);
        if (mfont != null) {
            if (MicroFontReader.verbose == false) return mfont;
            System.out.println("Get from cache: " + (Object)bfont);
            return mfont;
        }
        in = null;
        try {
            try {
                name = (int)bfont.getSize() + "pt " + bfont.getName();
                size = (int)bfont.getSize();
                style = bfont.getStyle();
                mfont = new MicroFont(bfont.getName(), style, size);
                if (bfont.isItalic()) {
                    name = "italic " + name;
                }
                if (bfont.isBold()) {
                    name = "bold " + name;
                }
                if (MicroFontReader.verbose) {
                    System.out.println("Reading [" + name + ".font]");
                }
                ord = BOrd.make((String)("module://fonts/" + name + ".font"));
                if (MicroFontReader.verbose) {
                    System.out.println("  - ord: " + ord);
                }
                file = (BIFile)ord.resolve().get();
                in = new InStream(new BufferedInputStream(new GZIPInputStream(file.getInputStream())));
                glyphCount = in.u2();
                ver = in.u1();
                if (ver != 1) {
                    throw new Exception("MicroFont version not supported: " + ver);
                }
                mfont.leading = in.u1();
                mfont.height = in.u1();
                mfont.ascent = in.u1();
                mfont.descent = in.u1();
                if (MicroFontReader.verbose) {
                    System.out.println("  - glyphs:  " + glyphCount);
                    System.out.println("  - version: " + ver);
                    System.out.println("  - leading: " + mfont.leading);
                    System.out.println("  - height:  " + mfont.height);
                    System.out.println("  - ascent:  " + mfont.ascent);
                    System.out.println("  - descent: " + mfont.descent);
                }
                mfont.glyphs = new MicroFont.Glyph[glyphCount];
                i = 0;
                while (true) {
                    if (i >= glyphCount) {
                        mfont.psName = in.utf();
                        mfont.pdfLeading = in.u1();
                        mfont.pdfHeight = in.u1();
                        mfont.pdfAscent = in.u1();
                        mfont.pdfDescent = in.u1();
                        if (MicroFontReader.verbose) {
                            System.out.println("  - PDF name: " + mfont.psName);
                            System.out.println("  - PDF leading: " + mfont.pdfLeading);
                            System.out.println("  - PDF height:  " + mfont.pdfHeight);
                            System.out.println("  - PDF ascent:  " + mfont.pdfAscent);
                            System.out.println("  - PDF descent: " + mfont.pdfDescent);
                        }
                        break;
                    }
                    len = in.u2();
                    buf = new byte[len];
                    read = in.read(buf);
                    if (read != len) {
                        throw new IllegalStateException("Not enough bytes read: " + read + '/' + len);
                    }
                    mfont.glyphs[i] = new MicroFont.Glyph();
                    mfont.glyphs[i].width = len / mfont.height;
                    mfont.glyphs[i].buf = buf;
                    ++i;
                }
                mfont.pdfWidths = new byte[glyphCount];
                i = 0;
                while (true) {
                    block24: {
                        if (i < glyphCount) break block24;
                        if (MicroFontReader.verbose) {
                            System.out.println("Adding to cache: " + (Object)bfont);
                        }
                        MicroFontReader.cache.put(bfont, mfont);
                        break;
                    }
                    mfont.pdfWidths[i] = (byte)in.u1();
                    ++i;
                }
            }
            catch (UnresolvedException ue) {
                var5_16 = null;
                var4_18 = null;
                try {
                    in.close();
                    return var5_16;
                }
                catch (Exception e) {
                    // empty catch block
                }
                return var5_16;
            }
            catch (Exception e) {
                System.out.println("Failed to read " + (Object)bfont);
                e.printStackTrace();
                var5_17 = null;
                var4_19 = null;
                ** try [egrp 2[TRYBLOCK] [5 : 923->930)] { 
lbl96:
                // 1 sources

                in.close();
                return var5_17;
lbl98:
                // 1 sources

                catch (Exception e) {
                    // empty catch block
                }
                return var5_17;
            }
        }
        catch (Throwable var3_26) {
            var4_20 = null;
            ** try [egrp 2[TRYBLOCK] [5 : 923->930)] { 
lbl105:
            // 1 sources

            in.close();
            throw var3_26;
lbl107:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
            throw var3_26;
        }
        {
            var4_21 = null;
            try {}
            catch (Exception e) {
                return mfont;
            }
            in.close();
            return mfont;
        }
    }

    public static BFont findRelative(BFont font) {
        if (font.getName().equals("monospaced") || font.getName().equals("Courier")) {
            return MicroFontReader.findRelative(BFont.make("Courier New", font.getSize(), font.getStyle()));
        }
        if (files == null) {
            BOrd ord = BOrd.make((String)"module://fonts/");
            BIDirectory dir = (BIDirectory)ord.resolve().get();
            files = dir.listFiles();
        }
        int i = 0;
        while (i < files.length) {
            String n = files[i].getFileName();
            if (n.indexOf(font.getName()) != -1) {
                boolean italic;
                boolean bl = false;
                if (n.indexOf("bold") != -1) {
                    bl = true;
                }
                boolean bold = bl;
                boolean bl2 = false;
                if (n.indexOf("italic") != -1) {
                    bl2 = italic = true;
                }
                if (!(font.isBold() && !bold || !font.isBold() && bold || font.isItalic() && !italic || !font.isItalic() && italic)) {
                    return BFont.make(n.substring(0, n.length() - ".font".length()));
                }
            }
            ++i;
        }
        if (font.isBold() || font.isItalic()) {
            return MicroFontReader.findRelative(BFont.make(font.getName(), font.getSize(), 0));
        }
        return MicroFontReader.findRelative(BFont.make("Arial", font.getSize(), font.getStyle()));
    }

    public static void main(String[] args) {
        Sys.getRegistry().getModules();
        BFont[] defaultFonts = new BFont[]{BFont.make("Arial", 16.0, 0), BFont.make("Courier New", 12.0, 0), BFont.make("Tahoma", 11.0, 0), BFont.make("Arial Unicode MS", 12.0, 0), BFont.make("NSimSun", 12.0, 0), BFont.make("MS Mincho", 12.0, 0), BFont.make("GulimChe", 12.0, 0), BFont.make("Gulim", 12.0, 0)};
        if (args.length > 0) {
            verbose = true;
        }
        int i = 0;
        while (i < defaultFonts.length) {
            MicroFontReader.read(defaultFonts[i]);
            ++i;
        }
    }

    static {
        cache = new HashMap();
        verbose = false;
    }

    static class InStream
    extends DataInputStream {
        public int u1() throws IOException {
            return 0xFF & this.read();
        }

        public int u2() throws IOException {
            return (0xFF & this.read()) << 8 | 0xFF & this.read();
        }

        public String utf() throws IOException {
            return this.readUTF();
        }

        public InStream(InputStream stream) {
            super(stream);
        }
    }
}

