/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.micro;

import com.tridium.gx.FontPeer;
import com.tridium.gx.micro.MicroFont;

public class MicroFontPeer
implements FontPeer {
    public MicroFont font;
    double targetSize;
    double factor;

    public double getLeading() {
        return this.factor == 0.0 ? (double)this.font.leading : (double)this.font.pdfLeading * this.factor;
    }

    public double getAscent() {
        return this.factor == 0.0 ? (double)this.font.ascent : (double)this.font.pdfAscent * this.factor;
    }

    public double getDescent() {
        return this.factor == 0.0 ? (double)this.font.descent : (double)this.font.pdfDescent * this.factor;
    }

    public double getHeight() {
        return this.factor == 0.0 ? (double)this.font.height : (double)this.font.pdfHeight * this.factor;
    }

    public double getMaxAscent() {
        return this.getAscent();
    }

    public double getMaxDescent() {
        return this.getDescent();
    }

    public double width(int c) {
        if (c < 0 || c > this.font.glyphs.length) {
            c = 87;
        }
        return this.factor == 0.0 ? (double)this.font.glyphs[c].width : (double)this.font.pdfWidths[c] * this.factor;
    }

    public double width(String s) {
        return this.width(s.toCharArray(), 0, s.length());
    }

    public double width(char[] data, int off, int len) {
        double w = 0.0;
        int i = 0;
        while (i < len) {
            w += this.width(data[i + off]);
            ++i;
        }
        return w;
    }

    public String getName() {
        return this.font.name;
    }

    public String getPostScriptName() {
        return this.font.psName;
    }

    public double getSize() {
        return this.factor == 0.0 ? (double)this.font.size : this.targetSize;
    }

    public int getPdfLeading() {
        return this.font.pdfLeading;
    }

    public int getPdfHeight() {
        return this.font.pdfHeight;
    }

    public int getPdfAscent() {
        return this.font.pdfAscent;
    }

    public int getPdfDescent() {
        return this.font.pdfDescent;
    }

    public byte[] getPdfWidths() {
        return this.font.pdfWidths;
    }

    public MicroFontPeer(MicroFont font, double targetSize) {
        this.font = font;
        this.targetSize = targetSize;
        this.factor = (double)font.size == targetSize ? 0.0 : targetSize / 72.0;
    }
}

