/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.micro;

import com.tridium.gx.DefaultGeomPeer;
import com.tridium.gx.FontPeer;
import com.tridium.gx.GeomPeer;
import com.tridium.gx.GxEnv;
import com.tridium.gx.ImagePeer;
import com.tridium.gx.micro.MicroFont;
import com.tridium.gx.micro.MicroFontPeer;
import com.tridium.gx.micro.MicroFontReader;
import com.tridium.gx.micro.MicroImagePeer;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.IGeom;
import javax.baja.log.Log;

public class MicroEnv
extends GxEnv {
    static Log log = Log.getLog((String)"gx.image");

    public boolean isRotationSupported() {
        return true;
    }

    public FontPeer makeFontPeer(BFont font) {
        return MicroEnv.peer(font);
    }

    public GeomPeer makeGeomPeer(IGeom geom) {
        return DefaultGeomPeer.make(geom);
    }

    public ImagePeer makeImagePeer(BImage image) {
        return MicroEnv.peer(image);
    }

    public BImage makeImage(byte[] data) {
        throw new UnsupportedOperationException("Memory images not supported.");
    }

    public BImage makeImage(double width, double height) {
        throw new UnsupportedOperationException("Memory images not supported.");
    }

    public static MicroFontPeer peer(BFont font) {
        BFont rel;
        MicroFont mfont = MicroFontReader.read(font);
        if (mfont == null && (rel = MicroFontReader.findRelative(font)) != null) {
            mfont = MicroFontReader.read(rel);
        }
        if (mfont == null) {
            throw new RuntimeException("MicroEnv: Could not find peer for: " + (Object)((Object)font));
        }
        return new MicroFontPeer(mfont, font.getSize());
    }

    public static MicroImagePeer peer(BImage image) {
        return new MicroImagePeer(image);
    }
}

