/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt.se;

import com.tridium.gx.awt.AwtEnv;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import javax.baja.gx.BBrush;
import org.apache.batik.ext.awt.RadialGradientPaint;

public class AwtRadialGradient
implements Paint,
PaintContext {
    private BBrush.RadialGradient gradient;
    private float[] frac;
    private Color[] cols;
    private double cx;
    private double cy;
    private double radius;
    private double fx;
    private double fy;
    private PaintContext context;

    public AwtRadialGradient(BBrush.RadialGradient gradient) {
        this.gradient = gradient;
        BBrush.Stop[] stops = gradient.getStops();
        this.frac = new float[stops.length];
        this.cols = new Color[stops.length];
        for (int i = 0; i < stops.length; ++i) {
            this.frac[i] = (float)stops[i].getOffset() / 100.0f;
            this.cols[i] = AwtEnv.peer(stops[i].getColor());
        }
        this.cx = gradient.getCenter().x / 100.0;
        this.cy = gradient.getCenter().y / 100.0;
        this.radius = gradient.getRadius() / 100.0;
        this.fx = gradient.getFocal().x / 100.0;
        this.fy = gradient.getFocal().y / 100.0;
    }

    public int getTransparency() {
        return 2;
    }

    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        float tempCx = (float)(userBounds.getX() + userBounds.getWidth() * this.cx);
        float tempCy = (float)(userBounds.getY() + userBounds.getHeight() * this.cy);
        float tempFx = (float)(userBounds.getX() + userBounds.getWidth() * this.fx);
        float tempFy = (float)(userBounds.getY() + userBounds.getHeight() * this.fy);
        float tempR = (float)(Math.max(userBounds.getWidth(), userBounds.getHeight()) * this.radius);
        RadialGradientPaint paint = new RadialGradientPaint(tempCx, tempCy, tempR, tempFx, tempFy, this.frac, this.cols);
        this.context = paint.createContext(cm, deviceBounds, userBounds, xform, hints);
        return this;
    }

    public void dispose() {
        this.context.dispose();
    }

    public ColorModel getColorModel() {
        return this.context.getColorModel();
    }

    public Raster getRaster(int x, int y, int w, int h) {
        return this.context.getRaster(x, y, w, h);
    }
}

