/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt.se;

import com.tridium.gx.awt.AwtEnv;
import com.tridium.gx.awt.AwtImagePeer;
import com.tridium.gx.awt.ImageData;
import com.tridium.gx.awt.se.TexturedImagePaint;
import com.tridium.gx.awt.se.UntiledImagePaint;
import com.tridium.gx.awt.se.XTiledImagePaint;
import com.tridium.gx.awt.se.YTiledImagePaint;
import java.awt.Image;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;

abstract class AwtImagePaint
implements Paint,
PaintContext {
    protected BBrush.Image brush;
    protected boolean loaded;
    protected PaintContext unloadedContext;
    protected BufferedImage buffer;
    protected int bufW;
    protected int bufH;

    static AwtImagePaint make(BBrush.Image brush) {
        try {
            AwtEnv.peer((BImage)brush.getImage()).data.repaintOnLoad = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        switch (brush.getTile()) {
            case 0: {
                return new UntiledImagePaint(brush);
            }
            case 2: {
                return new XTiledImagePaint(brush);
            }
            case 3: {
                return new YTiledImagePaint(brush);
            }
            case 1: {
                return new TexturedImagePaint(brush);
            }
        }
        throw new IllegalStateException();
    }

    protected AwtImagePaint(BBrush.Image brush) {
        this.brush = brush;
        this.loaded = false;
    }

    boolean isLoaded() {
        if (this.loaded) {
            return true;
        }
        BImage bmg = this.brush.getImage();
        AwtImagePeer peer = AwtEnv.peer(bmg);
        if (peer.isLoaded()) {
            ImageData data = peer.data;
            Image image = data.getImage();
            if (image == null) {
                return false;
            }
            this.bufW = image.getWidth(null);
            this.bufH = image.getHeight(null);
            if (image instanceof BufferedImage) {
                this.buffer = (BufferedImage)image;
            } else {
                this.buffer = new BufferedImage(this.bufW, this.bufH, 2);
                this.buffer.getGraphics().drawImage(image, 0, 0, null);
            }
            this.finishLoading();
            this.loaded = true;
            return true;
        }
        return false;
    }

    abstract void finishLoading();

    public int getTransparency() {
        if (this.isLoaded()) {
            return this.buffer.getColorModel().getTransparency();
        }
        return AwtEnv.TRANSPARENT.getTransparency();
    }

    public void dispose() {
    }

    public ColorModel getColorModel() {
        if (this.isLoaded()) {
            return this.buffer.getColorModel();
        }
        return ColorModel.getRGBdefault();
    }
}

