/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt.se;

import com.tridium.gx.DefaultGeomPeer;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.baja.gx.IEllipseGeom;
import javax.baja.gx.IGeom;
import javax.baja.gx.ILineGeom;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.IPolygonGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Point;
import org.apache.batik.ext.awt.geom.ExtendedGeneralPath;

public abstract class AwtGeomPeer
extends DefaultGeomPeer {
    public static DefaultGeomPeer make(IGeom geom) {
        switch (geom.getGeomCase()) {
            case 1: {
                return new Line((ILineGeom)geom);
            }
            case 2: {
                return new Rect((IRectGeom)geom);
            }
            case 3: {
                return new Ellipse((IEllipseGeom)geom);
            }
            case 4: {
                return new Polygon((IPolygonGeom)geom);
            }
            case 5: {
                return new Path((IPathGeom)geom);
            }
        }
        throw new IllegalStateException();
    }

    public abstract Shape shape();

    public boolean contains(double x, double y) {
        return this.shape().contains(x, y);
    }

    public boolean contains(IGeom geom) {
        IRectGeom r = AwtGeomPeer.toRect(geom);
        return this.shape().contains(r.x(), r.y(), r.width(), r.height());
    }

    public boolean contains(double x, double y, double w, double h) {
        return this.shape().contains(x, y, w, h);
    }

    public boolean intersects(IGeom geom) {
        IRectGeom r = AwtGeomPeer.toRect(geom);
        return this.shape().intersects(r.x(), r.y(), r.width(), r.height());
    }

    public boolean intersects(double x, double y, double w, double h) {
        return this.shape().intersects(x, y, w, h);
    }

    public static class Path
    extends PathPeer {
        IPathGeom geom;
        Point controlPoint = new Point();

        Path(IPathGeom geom) {
            this.geom = geom;
            this.draw();
        }

        public final IGeom geom() {
            return this.geom;
        }

        void draw() {
            IPathGeom g = this.geom;
            IPathGeom.Segment[] segs = g.segments();
            int size = segs.length;
            ExtendedGeneralPath p = this.shape = new ExtendedGeneralPath(1, size + 4);
            IPathGeom.Segment last = null;
            Point lastPoint = new Point();
            Point lastControlPoint = null;
            for (int i = 0; i < size; ++i) {
                IPathGeom.Segment seg = segs[i];
                switch (seg.getCommand()) {
                    case 'M': 
                    case 'm': {
                        this.moveTo((IPathGeom.MoveTo)seg, lastPoint);
                        lastControlPoint = null;
                        break;
                    }
                    case 'L': 
                    case 'l': {
                        this.lineTo((IPathGeom.LineTo)seg, lastPoint);
                        lastControlPoint = null;
                        break;
                    }
                    case 'H': 
                    case 'h': {
                        this.hlineTo((IPathGeom.HLineTo)seg, lastPoint);
                        lastControlPoint = null;
                        break;
                    }
                    case 'V': 
                    case 'v': {
                        this.vlineTo((IPathGeom.VLineTo)seg, lastPoint);
                        lastControlPoint = null;
                        break;
                    }
                    case 'Q': 
                    case 'q': {
                        lastControlPoint = this.quadTo((IPathGeom.QuadTo)seg, lastPoint);
                        break;
                    }
                    case 'T': 
                    case 't': {
                        lastControlPoint = this.smoothQuadTo((IPathGeom.SmoothQuadTo)seg, lastPoint, lastControlPoint);
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        lastControlPoint = this.curveTo((IPathGeom.CurveTo)seg, lastPoint);
                        break;
                    }
                    case 'S': 
                    case 's': {
                        lastControlPoint = this.smoothCurveTo((IPathGeom.SmoothCurveTo)seg, lastPoint, lastControlPoint);
                        break;
                    }
                    case 'A': 
                    case 'a': {
                        this.arcTo((IPathGeom.ArcTo)seg, lastPoint);
                        lastControlPoint = null;
                        break;
                    }
                    case 'Z': 
                    case 'z': {
                        this.shape.closePath();
                        lastControlPoint = null;
                        break;
                    }
                    default: {
                        throw new IllegalStateException(seg.toString());
                    }
                }
                last = seg;
            }
        }

        void moveTo(IPathGeom.MoveTo s, Point lastPoint) {
            double x = s.getX();
            double y = s.getY();
            if (s.isRelative()) {
                x += lastPoint.x;
                y += lastPoint.y;
            }
            this.shape.moveTo((float)x, (float)y);
            lastPoint.set(x, y);
        }

        void lineTo(IPathGeom.LineTo s, Point lastPoint) {
            double x = s.getX();
            double y = s.getY();
            if (s.isRelative()) {
                x += lastPoint.x;
                y += lastPoint.y;
            }
            this.shape.lineTo((float)x, (float)y);
            lastPoint.set(x, y);
        }

        void hlineTo(IPathGeom.HLineTo s, Point lastPoint) {
            double x = s.getX();
            double y = lastPoint.y;
            if (s.isRelative()) {
                x += lastPoint.x;
            }
            this.shape.lineTo((float)x, (float)y);
            lastPoint.set(x, y);
        }

        void vlineTo(IPathGeom.VLineTo s, Point lastPoint) {
            double x = lastPoint.x;
            double y = s.getY();
            if (s.isRelative()) {
                y += lastPoint.y;
            }
            this.shape.lineTo((float)x, (float)y);
            lastPoint.set(x, y);
        }

        Point quadTo(IPathGeom.QuadTo s, Point lastPoint) {
            double x = s.getX();
            double y = s.getY();
            double x1 = s.getX1();
            double y1 = s.getY1();
            if (s.isRelative()) {
                x += lastPoint.x;
                y += lastPoint.y;
                x1 += lastPoint.x;
                y1 += lastPoint.y;
            }
            this.shape.quadTo((float)x1, (float)y1, (float)x, (float)y);
            lastPoint.set(x, y);
            this.controlPoint.set(x1, y1);
            return this.controlPoint;
        }

        Point smoothQuadTo(IPathGeom.SmoothQuadTo s, Point lastPoint, Point lastControlPoint) {
            double x = s.getX();
            double y = s.getY();
            double x1 = lastPoint.x;
            double y1 = lastPoint.y;
            if (lastControlPoint != null) {
                x1 += lastPoint.x - lastControlPoint.x;
                y1 += lastPoint.y - lastControlPoint.y;
            }
            if (s.isRelative()) {
                x += lastPoint.x;
                y += lastPoint.y;
            }
            this.shape.quadTo((float)x1, (float)y1, (float)x, (float)y);
            lastPoint.set(x, y);
            this.controlPoint.set(x1, y1);
            return this.controlPoint;
        }

        Point curveTo(IPathGeom.CurveTo s, Point lastPoint) {
            double x = s.getX();
            double y = s.getY();
            double x1 = s.getX1();
            double y1 = s.getY1();
            double x2 = s.getX2();
            double y2 = s.getY2();
            if (s.isRelative()) {
                x += lastPoint.x;
                y += lastPoint.y;
                x1 += lastPoint.x;
                y1 += lastPoint.y;
                x2 += lastPoint.x;
                y2 += lastPoint.y;
            }
            this.shape.curveTo((float)x1, (float)y1, (float)x2, (float)y2, (float)x, (float)y);
            lastPoint.set(x, y);
            this.controlPoint.set(x2, y2);
            return this.controlPoint;
        }

        Point smoothCurveTo(IPathGeom.SmoothCurveTo s, Point lastPoint, Point lastControlPoint) {
            double x = s.getX();
            double y = s.getY();
            double x1 = lastPoint.x;
            double y1 = lastPoint.y;
            double x2 = s.getX2();
            double y2 = s.getY2();
            if (lastControlPoint != null) {
                x1 += lastPoint.x - lastControlPoint.x;
                y1 += lastPoint.y - lastControlPoint.y;
            }
            if (s.isRelative()) {
                x += lastPoint.x;
                y += lastPoint.y;
                x2 += lastPoint.x;
                y2 += lastPoint.y;
            }
            this.shape.curveTo((float)x1, (float)y1, (float)x2, (float)y2, (float)x, (float)y);
            lastPoint.set(x, y);
            this.controlPoint.set(x2, y2);
            return this.controlPoint;
        }

        void arcTo(IPathGeom.ArcTo s, Point lastPoint) {
            double rx = s.getRadiusX();
            double ry = s.getRadiusY();
            double angle = s.getXAxisRotation();
            boolean largeArcFlag = s.getLargeArcFlag();
            boolean sweepFlag = s.getSweepFlag();
            double x = s.getX();
            double y = s.getY();
            if (s.isRelative()) {
                x += lastPoint.x;
                y += lastPoint.y;
            }
            this.shape.arcTo(rx, ry, angle, largeArcFlag, sweepFlag, x, y);
            lastPoint.set(x, y);
        }
    }

    public static class Polygon
    extends PathPeer {
        IPolygonGeom geom;

        Polygon(IPolygonGeom geom) {
            this.geom = geom;
            this.draw();
        }

        public final IGeom geom() {
            return this.geom;
        }

        void draw() {
            IPolygonGeom g = this.geom;
            int size = this.geom.size();
            ExtendedGeneralPath p = this.shape = new ExtendedGeneralPath(1, size + 4);
            if (size == 0) {
                return;
            }
            p.moveTo((float)g.x(0), (float)g.y(0));
            for (int i = 1; i < size; ++i) {
                p.lineTo((float)g.x(i), (float)g.y(i));
            }
            p.closePath();
        }
    }

    public static abstract class PathPeer
    extends AwtGeomPeer {
        ExtendedGeneralPath shape;
        Rectangle2D bounds;

        public final Shape shape() {
            return this.shape;
        }

        public final double x() {
            return this.b().getX();
        }

        public final double y() {
            return this.b().getY();
        }

        public final double width() {
            return this.b().getWidth();
        }

        public final double height() {
            return this.b().getHeight();
        }

        final Rectangle2D b() {
            if (this.bounds == null) {
                this.bounds = this.shape.getBounds2D();
            }
            return this.bounds;
        }
    }

    public static class Ellipse
    extends AwtGeomPeer {
        IEllipseGeom geom;
        Ellipse2D.Double shape = new Ellipse2D.Double();

        Ellipse(IEllipseGeom geom) {
            this.geom = geom;
        }

        public final IGeom geom() {
            return this.geom;
        }

        public final Shape shape() {
            this.shape.setFrame(this.geom.x(), this.geom.y(), this.geom.width(), this.geom.height());
            return this.shape;
        }

        public final double x() {
            return this.geom.x();
        }

        public final double y() {
            return this.geom.y();
        }

        public final double width() {
            return this.geom.width();
        }

        public final double height() {
            return this.geom.height();
        }
    }

    public static class Rect
    extends AwtGeomPeer {
        IRectGeom geom;
        Rectangle2D.Double shape = new Rectangle2D.Double();

        Rect(IRectGeom geom) {
            this.geom = geom;
        }

        public final IGeom geom() {
            return this.geom;
        }

        public final Shape shape() {
            this.shape.setRect(this.geom.x(), this.geom.y(), this.geom.width(), this.geom.height());
            return this.shape;
        }

        public final double x() {
            return this.geom.x();
        }

        public final double y() {
            return this.geom.y();
        }

        public final double width() {
            return this.geom.width();
        }

        public final double height() {
            return this.geom.height();
        }
    }

    public static class Line
    extends AwtGeomPeer {
        ILineGeom geom;
        Line2D.Double shape = new Line2D.Double();

        Line(ILineGeom geom) {
            this.geom = geom;
        }

        public final IGeom geom() {
            return this.geom;
        }

        public final Shape shape() {
            this.shape.setLine(this.geom.x1(), this.geom.y1(), this.geom.x2(), this.geom.y2());
            return this.shape;
        }

        public final double x() {
            return Math.min(this.geom.x1(), this.geom.x2());
        }

        public final double y() {
            return Math.min(this.geom.y1(), this.geom.y2());
        }

        public final double width() {
            return Math.max(this.geom.x1(), this.geom.x2()) - this.x();
        }

        public final double height() {
            return Math.max(this.geom.y1(), this.geom.y2()) - this.y();
        }
    }
}

