/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt.me;

import com.tridium.gx.awt.AwtEnv;
import com.tridium.gx.awt.AwtGraphics;
import com.tridium.gx.awt.me.AwtMeEnv;
import com.tridium.gx.awt.me.AwtMeGeomPeer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.Stack;
import javax.baja.gx.BBrush;
import javax.baja.gx.BPen;
import javax.baja.gx.BTransform;
import javax.baja.gx.IEllipseGeom;
import javax.baja.gx.IGeom;
import javax.baja.gx.ILineGeom;
import javax.baja.gx.IPolygonGeom;
import javax.baja.gx.IRectGeom;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AwtMeGraphics
extends AwtGraphics {
    private Stack stack;
    private double sx;
    private double sy;

    public void useAntiAliasing(boolean b) {
    }

    public void setBrush(BBrush b) {
        this.brush = b;
        BBrush.Paint paint = b.getPaint();
        if (paint instanceof BBrush.Solid) {
            BBrush.Solid solid = (BBrush.Solid)paint;
            this.g.setColor(AwtEnv.peer(solid.getColor()));
            if (b.getPaint() instanceof BBrush.Inverse) {
                this.g.setXORMode(Color.white);
            } else {
                this.g.setPaintMode();
            }
        } else if (paint instanceof BBrush.Gradient) {
            BBrush.Stop stop = ((BBrush.Gradient)paint).getStops()[0];
            this.g.setColor(AwtEnv.peer(stop.getColor()));
        } else {
            this.g.setColor(Color.white);
        }
    }

    public void setPen(BPen p) {
        this.pen = p;
    }

    public void transform(BTransform transform) {
        int size = transform.size();
        int i = 0;
        while (i < size) {
            BTransform.Transform step = transform.getTransform(i);
            switch (step.getTransformCase()) {
                case 1: {
                    BTransform.Translate t = (BTransform.Translate)step;
                    this.g.translate((int)t.getX(), (int)t.getY());
                    break;
                }
                case 2: {
                    BTransform.Scale s = (BTransform.Scale)step;
                    this.sx = s.getX();
                    this.sy = s.getY();
                    break;
                }
            }
            ++i;
        }
    }

    public void translate(double x, double y) {
        this.g.translate((int)x, (int)y);
    }

    public void clip(double x, double y, double w, double h) {
        this.g.clipRect((int)x, (int)y, (int)w, (int)h);
    }

    public void stroke(IGeom geom) {
        switch (geom.getGeomCase()) {
            case 1: {
                ILineGeom line = (ILineGeom)geom;
                this.strokeLine(line.x1(), line.y1(), line.x2(), line.y2());
                break;
            }
            case 2: {
                IRectGeom rect = (IRectGeom)geom;
                this.strokeRect(rect.x(), rect.y(), rect.width(), rect.height());
                break;
            }
            case 3: {
                IEllipseGeom ellipse = (IEllipseGeom)geom;
                this.g.drawOval(this.x(ellipse.x()), this.y(ellipse.y()), this.x(ellipse.width()), this.y(ellipse.height()));
                break;
            }
            case 4: {
                IPolygonGeom poly = (IPolygonGeom)geom;
                int size = poly.size();
                int[] polyx = new int[size];
                int[] polyy = new int[size];
                int i = 0;
                while (i < size) {
                    polyx[i] = this.x(poly.x(i));
                    polyy[i] = this.y(poly.y(i));
                    ++i;
                }
                this.g.drawPolygon(polyx, polyy, size);
                break;
            }
            case 5: {
                AwtMeGeomPeer.Path peer = (AwtMeGeomPeer.Path)AwtMeEnv.peer(geom);
                if (peer.polygon != null) {
                    this.g.drawPolygon(this.poly(peer.polygon));
                    break;
                }
                int[] x = new int[peer.size];
                int[] y = new int[peer.size];
                int i = 0;
                while (i < peer.size) {
                    x[i] = this.x(peer.x[i]);
                    y[i] = this.y(peer.y[i]);
                    ++i;
                }
                this.g.drawPolyline(x, y, peer.size);
                break;
            }
        }
    }

    public void fill(IGeom geom) {
        switch (geom.getGeomCase()) {
            case 1: {
                ILineGeom line = (ILineGeom)geom;
                this.strokeLine(line.x1(), line.y1(), line.x2(), line.y2());
                break;
            }
            case 2: {
                IRectGeom rect = (IRectGeom)geom;
                this.fillRect(rect.x(), rect.y(), rect.width(), rect.height());
                break;
            }
            case 3: {
                IEllipseGeom ellipse = (IEllipseGeom)geom;
                this.g.fillOval(this.x(ellipse.x()), this.y(ellipse.y()), this.x(ellipse.width()), this.y(ellipse.height()));
                break;
            }
            case 4: {
                IPolygonGeom poly = (IPolygonGeom)geom;
                int size = poly.size();
                int[] polyx = new int[size];
                int[] polyy = new int[size];
                int i = 0;
                while (i < size) {
                    polyx[i] = this.x(poly.x(i));
                    polyy[i] = this.y(poly.y(i));
                    ++i;
                }
                this.g.fillPolygon(polyx, polyy, size);
                break;
            }
            case 5: {
                AwtMeGeomPeer.Path peer = (AwtMeGeomPeer.Path)AwtMeEnv.peer(geom);
                if (peer.polygon == null) break;
                this.g.fillPolygon(this.poly(peer.polygon));
                break;
            }
        }
    }

    public void strokeLine(double x1, double y1, double x2, double y2) {
        if (x1 == x2 && y1 == y2) {
            this.fillRect(this.x(x1), this.y(y1), 1.0, 1.0);
        } else {
            this.g.drawLine(this.x(x1), this.y(y1), this.x(x2), this.y(y2));
        }
    }

    public void fillRect(double x, double y, double width, double height) {
        this.g.fillRect(this.x(x), this.y(y), this.x(width), this.y(height));
    }

    public void strokeRect(double x, double y, double width, double height) {
        this.g.drawRect(this.x(x), this.y(y), this.x(width), this.y(height));
    }

    public void push() {
        super.push();
        GxState s = new GxState();
        s.sx = this.sx;
        s.sy = this.sy;
        this.stack.push(s);
    }

    public void pop() {
        super.pop();
        GxState s = (GxState)this.stack.pop();
        this.sx = s.sx;
        this.sy = s.sy;
    }

    private final int x(double x) {
        return (int)(x * this.sx);
    }

    private final int y(double y) {
        return (int)(y * this.sy);
    }

    private final Polygon poly(Polygon p) {
        int[] x = new int[p.npoints];
        int[] y = new int[p.npoints];
        int i = 0;
        while (i < p.npoints) {
            x[i] = this.x(p.xpoints[i]);
            y[i] = this.y(p.ypoints[i]);
            ++i;
        }
        return new Polygon(x, y, p.npoints);
    }

    private final /* synthetic */ void this() {
        this.stack = new Stack();
        this.sx = 1.0;
        this.sy = 1.0;
    }

    public AwtMeGraphics(Graphics2D g) {
        super(g);
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class GxState {
        public double sx;
        public double sy;

        GxState() {
        }
    }
}

