/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt.me;

import com.tridium.gx.DefaultGeomPeer;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.baja.gx.IGeom;
import javax.baja.gx.IPathGeom;

public abstract class AwtMeGeomPeer
extends DefaultGeomPeer {
    public static DefaultGeomPeer make(IGeom geom) {
        if (geom.getGeomCase() == 5) {
            return new Path((IPathGeom)geom);
        }
        return DefaultGeomPeer.make(geom);
    }

    public static class Path
    extends AwtMeGeomPeer {
        IPathGeom geom;
        Rectangle bounds;
        Polygon polygon;
        int[] x;
        int[] y;
        int size;

        public final IGeom geom() {
            return this.geom;
        }

        public final double x() {
            return this.bounds.x;
        }

        public final double y() {
            return this.bounds.y;
        }

        public final double width() {
            return this.bounds.width;
        }

        public final double height() {
            return this.bounds.height;
        }

        void draw() {
            IPathGeom g = this.geom;
            IPathGeom.Segment[] segs = g.segments();
            this.size = segs.length;
            if (segs[segs.length - 1] instanceof IPathGeom.ClosePath) {
                --this.size;
            }
            this.x = new int[this.size];
            this.y = new int[this.size];
            int i = 0;
            while (i < segs.length) {
                IPathGeom.Segment seg = segs[i];
                switch (seg.getCommand()) {
                    case 'M': {
                        IPathGeom.MoveTo m = (IPathGeom.MoveTo)seg;
                        this.x[0] = (int)m.getX();
                        this.y[0] = (int)m.getY();
                        break;
                    }
                    case 'L': {
                        IPathGeom.LineTo l = (IPathGeom.LineTo)seg;
                        this.x[i] = (int)l.getX();
                        this.y[i] = (int)l.getY();
                        break;
                    }
                    case 'l': {
                        IPathGeom.LineTo l = (IPathGeom.LineTo)seg;
                        this.x[i] = (int)l.getX() + this.x[i - 1];
                        this.y[i] = (int)l.getY() + this.y[i - 1];
                        break;
                    }
                    case 'Z': 
                    case 'z': {
                        this.polygon = new Polygon(this.x, this.y, this.size);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(seg.toString());
                    }
                }
                ++i;
            }
            this.bounds = new Polygon(this.x, this.y, this.size).getBounds();
        }

        Path(IPathGeom geom) {
            this.geom = geom;
            this.draw();
        }
    }
}

