/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt;

import com.tridium.gx.awt.AwtEnv;
import com.tridium.gx.awt.AwtGraphics;
import com.tridium.gx.awt.BImageDecoder;
import com.tridium.gx.awt.GifDecoder;
import com.tridium.gx.awt.ImageData;
import com.tridium.sys.Nre;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.util.Comparator;
import java.util.HashMap;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.log.Log;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.SortUtil;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;

public class ImageManager {
    static final int TRIM_SIZE = 10240;
    static final long TRIM_AGE = 900000L;
    private static Log log = Log.getLog((String)"gx.image");
    private static HashMap cache = new HashMap();
    private static Queue queue = new Queue();
    private static final Thread thread;
    private static String activeTheme;
    private static MediaTracker tracker;

    public static synchronized ImageData fetchImageData(BImage image) {
        return ImageManager.fetchImageData(image, null);
    }

    public static synchronized ImageData fetchImageData(BImage image, BTransform.Scale scale) {
        ImageData data;
        BOrdList ordList = image.getAbsoluteOrdList();
        String key = ordList.encodeToString();
        if (scale != null) {
            key = key + '{' + scale.getX() + ',' + scale.getY() + '}';
        }
        if ((data = (ImageData)cache.get(key)) != null) {
            if (data.hasFileBeenModified()) {
                if (log.isTraceOn()) {
                    log.trace("out of date: " + key);
                }
                cache.remove(key);
            } else {
                data.lastUsedTicks = Clock.ticks();
                return data;
            }
        }
        data = new ImageData(null);
        data.ordList = ordList;
        data.cacheKey = key;
        data.lastUsedTicks = Clock.ticks();
        data.scale = scale;
        if (log.isTraceOn()) {
            log.trace("caching: " + key);
        }
        cache.put(key, data);
        if (key.startsWith("module://") || key.startsWith("local:|module://")) {
            if (log.isTraceOn()) {
                log.trace("load sync: " + key);
            }
            ImageManager.load(data);
        } else {
            if (log.isTraceOn()) {
                log.trace("load async: " + key);
            }
            queue.enqueue((Object)data);
        }
        return data;
    }

    public static void trimAll() {
        log.warning("Entire cache cleared");
        cache = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image sync(Image image) {
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            try {
                tracker.addImage(image, 0);
                tracker.waitForID(0, 0L);
                tracker.removeImage(image, 0);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e.toString());
            }
            return image;
        }
    }

    public static void setActiveTheme(String activeTheme) {
        ImageManager.activeTheme = activeTheme;
        IconManager.updateModuleBase();
    }

    public static Image rescaleImage(Image image, BTransform.Scale scale) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        if (width == 0 || height == 0) {
            return image;
        }
        AwtEnv env = (AwtEnv)AwtEnv.get();
        Image rescaled = env.makeBufferedImage((double)width * scale.getX(), (double)height * scale.getY());
        Graphics g = env.makeGraphics((Graphics2D)rescaled.getGraphics());
        g.transform(BTransform.make(scale));
        Graphics2D g2d = ((AwtGraphics)g).getAwtGraphics();
        g2d.drawImage(image, 0, 0, null);
        return rescaled;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void load(ImageData data) {
        block9: {
            block8: {
                try {
                    BOrdList list = data.ordList;
                    if (list.size() == 0) {
                        Object var2_2 = null;
                        data.loaded();
                        return;
                    }
                    ImageManager.loadFile(data, list.get(0));
                    if (list.size() == 1) {
                        break block8;
                    }
                    double w = data.getWidth();
                    double h = data.getHeight();
                    if (data.scale != null) {
                        w *= data.scale.getX();
                        h *= data.scale.getY();
                    }
                    Image composite = ((AwtEnv)AwtEnv.get()).makeBufferedImage(w, h);
                    composite.getGraphics().drawImage(data.image, 0, 0, null);
                    int i = 1;
                    while (true) {
                        if (i >= list.size()) {
                            data.image = composite;
                            break block9;
                        }
                        ImageManager.loadFile(data, list.get(i));
                        composite.getGraphics().drawImage(data.image, 0, 0, null);
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    Object var2_4 = null;
                    data.loaded();
                    throw throwable;
                }
            }
            Object var2_3 = null;
            data.loaded();
            return;
        }
        Object var2_5 = null;
        data.loaded();
    }

    private static final void loadFile(ImageData data, BOrd ord) {
        if (ord.isNull()) {
            return;
        }
        try {
            ord = IconManager.getExistingOrd(ord.toString());
            BIFile file = (BIFile)ord.resolve((BObject)BLocalHost.INSTANCE).get();
            byte[] buf = file.read();
            data.setFile(file, buf.length);
            AgentList agents = ((BObject)file).getAgents().filter(AgentFilter.is((Type)BImageDecoder.TYPE));
            if (agents.size() > 0) {
                BImageDecoder decoder = (BImageDecoder)agents.getDefault().getInstance();
                decoder.decode(ord, buf, data.scale);
                data.image = decoder.getImage();
                data.animator = decoder.getAnimator();
            } else {
                ImageManager.decode(data, buf);
            }
        }
        catch (UnresolvedException e) {
            log.error("Cannot resolve image \"" + ord + '\"');
        }
        catch (Throwable e) {
            log.error("Cannot load image \"" + ord + '\"', e);
        }
    }

    private static final void decode(ImageData data, byte[] buf) throws Exception {
        if (buf[0] == 71 && buf[1] == 73 && buf[2] == 70) {
            GifDecoder decoder = new GifDecoder();
            decoder.decode(buf, data.scale);
            data.image = decoder.getImage();
            data.animator = decoder.getAnimator();
        } else {
            Image image = Toolkit.getDefaultToolkit().createImage(buf);
            ImageManager.sync(image);
            data.image = data.scale == null ? image : ImageManager.rescaleImage(image, data.scale);
        }
    }

    static synchronized void trim() {
        log.trace("trim");
        long now = Clock.ticks();
        ImageData[] datas = cache.values().toArray(new ImageData[cache.size()]);
        int i = 0;
        while (i < datas.length) {
            ImageData data = datas[i];
            if (data.trim(now)) {
                log.trace("  trim: " + data.cacheKey);
                cache.remove(data.cacheKey);
            }
            ++i;
        }
    }

    static /* synthetic */ Queue access$0() {
        return queue;
    }

    static /* synthetic */ Log access$1() {
        return log;
    }

    static final /* synthetic */ void access$2(ImageData imageData) {
        ImageManager.load(imageData);
    }

    static {
        activeTheme = "";
        tracker = new MediaTracker(new Component(){});
        thread = new ImageManagerThread();
        thread.start();
        Spy.ROOT.add("imageManager", (Spy)new ImageManagerSpy());
    }

    private static class IconManager {
        private static String moduleBase;
        private static final String DEFAULT_MODULE_BASE = "module://";
        private static Log logger;

        private static final void updateModuleBase() {
            String theme = activeTheme;
            moduleBase = DEFAULT_MODULE_BASE;
            if (theme != null && theme.trim().length() > 0) {
                try {
                    Sys.loadModule((String)theme);
                    moduleBase = DEFAULT_MODULE_BASE + theme + "/imageOverrides/";
                }
                catch (ModuleNotFoundException e) {
                    logger.error("bajaui.activeTheme '" + theme + "' could not be loaded");
                }
            }
        }

        public static BOrd getExistingOrd(String imagePath) {
            if (imagePath.startsWith(DEFAULT_MODULE_BASE)) {
                String newImagePath = moduleBase + imagePath.substring(9);
                BOrd ord = IconManager.makeOrd(newImagePath);
                if (ord != null) {
                    return ord;
                }
                ord = IconManager.makeOrd(imagePath);
                if (ord == null) {
                    logger.error("icon '" + imagePath + "' could not be found either in active theme module or in icons module.");
                    return BOrd.make((String)"module://icons/x16/error.png");
                }
                return ord;
            }
            return BOrd.make((String)imagePath);
        }

        /*
         * WARNING - void declaration
         */
        private static final BOrd makeOrd(String path) {
            try {
                void e;
                BOrd ord = BOrd.make((String)path);
                ord.get();
                return e;
            }
            catch (Exception e) {
                return null;
            }
        }

        private IconManager() {
        }

        static {
            logger = Log.getLog((String)"com.tridium.gx.awt");
            IconManager.updateModuleBase();
        }
    }

    static class ImageManagerThread
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            lastTrim = Clock.ticks();
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        block9: {
                            block10: {
                                block8: {
                                    if ((data = (ImageData)ImageManager.access$0().dequeue()) != null) break block8;
                                    if (Clock.ticks() - lastTrim <= 60000L) break block9;
                                    break block10;
                                }
                                if (ImageManager.access$1().isTraceOn()) {
                                    ImageManager.access$1().trace("  loading: " + data.cacheKey);
                                }
                                ImageManager.access$2(data);
                                if (!ImageManager.access$1().isTraceOn()) continue;
                                ImageManager.access$1().trace("       ok: " + data.cacheKey + " -> " + data.getWidth() + ',' + data.getHeight());
                                continue;
                            }
                            lastTrim = Clock.ticks();
                            ImageManager.trim();
                        }
                        data = ImageManager.access$0();
                        synchronized (data) {
                            ImageManager.access$0().wait(10000L);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                {
                    ** while (true)
                }
                break;
            }
        }

        ImageManagerThread() {
            super(Nre.mainThreadGroup, "Ui:ImageManager");
            this.setDaemon(true);
        }
    }

    static class ImageManagerSpy
    extends SpyByKey {
        ImageManagerSpy() {
            this.add("bySize", (Spy)new SpyBySize());
            this.add("byLastUsed", (Spy)new SpyByLastUsed());
        }
    }

    static class SpyByLastUsed
    extends AbstractSpy {
        public int compare(Object a, Object b) {
            long aticks = ((ImageData)a).lastUsedTicks;
            long bticks = ((ImageData)b).lastUsedTicks;
            if (aticks < bticks) {
                return -1;
            }
            return 1;
        }

        SpyByLastUsed() {
        }
    }

    static class SpyBySize
    extends AbstractSpy {
        public int compare(Object a, Object b) {
            int asize = ((ImageData)a).fileSize;
            int bsize = ((ImageData)b).fileSize;
            if (asize < bsize) {
                return 1;
            }
            if (asize == bsize) {
                return 0;
            }
            return -1;
        }

        SpyBySize() {
        }
    }

    static class SpyByKey
    extends AbstractSpy {
        public int compare(Object a, Object b) {
            return SortUtil.compare((Object)((ImageData)a).cacheKey, (Object)((ImageData)b).cacheKey);
        }

        SpyByKey() {
        }
    }

    static abstract class AbstractSpy
    extends SpyDir
    implements Comparator {
        public void write(SpyWriter out) throws Exception {
            Object[] datas = cache.values().toArray(new ImageData[cache.size()]);
            SortUtil.sort((Object[])datas, (Object[])datas, (Comparator)this);
            out.startTable(true);
            out.trTitle((Object)("Image Cache [" + datas.length + ']'), 3);
            out.w((Object)"<tr>").th((Object)"<b><a href='/imageManager'>Image</a></b>").th((Object)"<b><a href='/imageManager/bySize'>Size</a></b>").th((Object)"<b><a href='/imageManager/byLastUsed'>Last Used</a></b>").w((Object)"</tr>\n");
            int i = 0;
            while (i < datas.length) {
                Object data = datas[i];
                String size = ((ImageData)data).fileSize / 1024 + "kb";
                String lastUsed = BRelTime.toString((long)(Clock.ticks() - ((ImageData)data).lastUsedTicks));
                out.tr((Object)((ImageData)data).cacheKey, (Object)size, (Object)lastUsed);
                ++i;
            }
            out.endTable();
        }

        AbstractSpy() {
        }
    }
}

