/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt;

import com.tridium.gx.awt.GifAnimator;
import com.tridium.gx.awt.ImageAnimator;
import com.tridium.gx.awt.ImageManager;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import javax.baja.gx.BTransform;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GifDecoder {
    private static final boolean DEBUG = true;
    private static final int STACK_SIZE = 4096;
    private Image image;
    private GifAnimator animator;
    private byte[] data;
    private int dataSize;
    private int pos;
    private int width;
    private int height;
    private int bgIndex;
    private ColorTable gct;
    private int ix;
    private int iy;
    private int iw;
    private int ih;
    private boolean interlace;
    private int delay;
    private int transIndex;
    private int dispose;
    private int lastDispose;
    private int blockSize;
    private byte[] block;
    private short[] prefix;
    private byte[] suffix;
    private byte[] pixelStack;
    private byte[] pixels;
    private byte[] lastDest;
    private byte[] lastLastDest;

    public void decode(byte[] data, BTransform.Scale scale) throws Exception {
        int i;
        this.data = data;
        this.dataSize = data.length;
        this.pos = 0;
        this.readHeader();
        ArrayList<GifAnimator.Frame> v = new ArrayList<GifAnimator.Frame>();
        boolean done = false;
        while (!done) {
            int sep = this.u1();
            switch (sep) {
                case 44: {
                    v.add(this.readImage());
                    break;
                }
                case 33: {
                    this.readExt();
                    break;
                }
                case 59: {
                    done = true;
                    break;
                }
                default: {
                    throw this.err();
                }
            }
        }
        GifAnimator.Frame[] frames = v.toArray(new GifAnimator.Frame[v.size()]);
        if (scale != null) {
            i = 0;
            while (i < frames.length) {
                frames[i].image = ImageManager.rescaleImage(frames[i].image, scale);
                ++i;
            }
        }
        this.animator.frames = frames;
        this.image = this.animator.frames[0].image;
        this.animator.duration = 0.0;
        i = 0;
        while (i < this.animator.frames.length) {
            this.animator.duration += (double)this.animator.frames[i].delay;
            ++i;
        }
    }

    private final void readHeader() throws Exception {
        if (this.data[0] != 71 || this.data[1] != 73 || this.data[2] != 70) {
            throw this.err();
        }
        this.pos = 6;
        this.width = this.u2();
        this.height = this.u2();
        int bits = this.u1();
        this.bgIndex = this.u1();
        int aspect = this.u1();
        boolean bl = false;
        if ((bits >> 7 & 1) != 0) {
            bl = true;
        }
        boolean gctFlag = bl;
        int gctSize = bits & 7;
        if (gctFlag) {
            this.gct = this.readColorTable(gctSize);
        }
    }

    private final ColorTable readColorTable(int size) throws Exception {
        ColorTable ct = new ColorTable();
        int length = ct.length = 1 << size + 1;
        ct.r = new byte[length];
        byte[] r = ct.r;
        ct.g = new byte[length];
        byte[] g = ct.g;
        ct.b = new byte[length];
        byte[] b = ct.b;
        if (this.pos + length * 3 >= this.dataSize) {
            throw new EOFException();
        }
        int i = 0;
        while (i < length) {
            r[i] = this.data[this.pos++];
            g[i] = this.data[this.pos++];
            b[i] = this.data[this.pos++];
            ++i;
        }
        return ct;
    }

    private final GifAnimator.Frame readImage() throws Exception {
        GifAnimator.Frame frame = new GifAnimator.Frame();
        frame.delay = this.delay;
        this.ix = this.u2();
        this.iy = this.u2();
        this.iw = this.u2();
        this.ih = this.u2();
        int bits = this.u1();
        boolean bl = false;
        if ((bits >> 7 & 1) != 0) {
            bl = true;
        }
        boolean lctFlag = bl;
        boolean bl2 = false;
        if ((bits >> 6 & 1) != 0) {
            bl2 = true;
        }
        this.interlace = bl2;
        int lctSize = bits & 7;
        ColorTable ct = this.gct;
        if (lctFlag) {
            ct = this.readColorTable(lctSize);
        }
        this.readImageData();
        frame.image = ImageManager.sync(this.render(ct));
        this.skip();
        this.transIndex = -1;
        this.delay = -1;
        this.lastDispose = this.dispose;
        this.dispose = 1;
        return frame;
    }

    private final void readImageData() throws Exception {
        int NullCode = -1;
        int npix = this.iw * this.ih;
        this.pixels = new byte[npix];
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        int data_size = this.u1();
        int clear = 1 << data_size;
        int end_of_information = clear + 1;
        int available = clear + 2;
        int old_code = NullCode;
        int code_size = data_size + 1;
        int code_mask = (1 << code_size) - 1;
        int code = 0;
        while (code < clear) {
            this.prefix[code] = 0;
            this.suffix[code] = (byte)code;
            ++code;
        }
        int bi = 0;
        int pi = 0;
        int top = 0;
        int first = 0;
        int count = 0;
        int bits = 0;
        int datum = 0;
        int i = 0;
        while (i < npix) {
            if (top == 0) {
                if (bits < code_size) {
                    if (count == 0) {
                        count = this.readBlock();
                        if (count <= 0) break;
                        bi = 0;
                    }
                    datum += (this.block[bi] & 0xFF) << bits;
                    bits += 8;
                    ++bi;
                    --count;
                    continue;
                }
                code = datum & code_mask;
                datum >>= code_size;
                bits -= code_size;
                if (code > available || code == end_of_information) break;
                if (code == clear) {
                    code_size = data_size + 1;
                    code_mask = (1 << code_size) - 1;
                    available = clear + 2;
                    old_code = NullCode;
                    continue;
                }
                if (old_code == NullCode) {
                    this.pixelStack[top++] = this.suffix[code];
                    old_code = code;
                    first = code;
                    continue;
                }
                int in_code = code;
                if (code == available) {
                    this.pixelStack[top++] = (byte)first;
                    code = old_code;
                }
                while (code > clear) {
                    this.pixelStack[top++] = this.suffix[code];
                    code = this.prefix[code];
                }
                first = this.suffix[code] & 0xFF;
                if (available >= 4096) break;
                this.pixelStack[top++] = (byte)first;
                this.prefix[available] = (short)old_code;
                this.suffix[available] = (byte)first;
                if ((++available & code_mask) == 0 && available < 4096) {
                    ++code_size;
                    code_mask += available;
                }
                old_code = in_code;
            }
            this.pixels[pi++] = this.pixelStack[--top];
            ++i;
        }
        i = pi;
        while (i < npix) {
            this.pixels[i] = (byte)this.bgIndex;
            ++i;
        }
    }

    private final Image render(ColorTable ct) {
        byte[] dest = new byte[this.width * this.height];
        if (this.lastDispose == 0 || this.lastDispose == 2) {
            int i = 0;
            while (i < dest.length) {
                dest[i] = (byte)this.transIndex;
                ++i;
            }
        } else {
            if (this.lastDispose == 3) {
                this.lastDest = this.lastLastDest;
            }
            if (this.lastDest != null) {
                System.arraycopy(this.lastDest, 0, dest, 0, dest.length);
            }
        }
        int pass = 1;
        int inc = 8;
        int iline = 0;
        int i = 0;
        while (i < this.ih) {
            int line = i;
            if (this.interlace) {
                if (iline >= this.ih) {
                    switch (++pass) {
                        case 2: {
                            iline = 4;
                            break;
                        }
                        case 3: {
                            iline = 2;
                            inc = 4;
                            break;
                        }
                        case 4: {
                            iline = 1;
                            inc = 2;
                        }
                    }
                }
                line = iline;
                iline += inc;
            }
            if ((line += this.iy) < this.height) {
                int k = line * this.width;
                int dx = k + this.ix;
                int dlim = dx + this.iw;
                if (k + this.width < dlim) {
                    dlim = k + this.width;
                }
                int sx = i * this.iw;
                while (dx < dlim) {
                    int index = this.pixels[sx] & 0xFF;
                    if (index != this.transIndex) {
                        dest[dx] = this.pixels[sx];
                    }
                    ++sx;
                    ++dx;
                }
            }
            ++i;
        }
        this.lastLastDest = this.lastDest;
        this.lastDest = dest;
        IndexColorModel cm = new IndexColorModel(8, ct.length, ct.r, ct.g, ct.b, this.transIndex);
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, (ColorModel)cm, dest, 0, this.width));
    }

    private final void readExt() throws Exception {
        int code = this.u1();
        switch (code) {
            case 249: {
                this.readGraphicControlExt();
                break;
            }
            case 255: {
                this.readBlock();
                String app = "";
                int i = 0;
                while (i < 11) {
                    app = app + (char)this.block[i];
                    ++i;
                }
                if (app.equals("NETSCAPE2.0")) {
                    this.readNetscapeExt();
                    break;
                }
                this.skip();
                break;
            }
            default: {
                this.skip();
                break;
            }
        }
    }

    private final void readGraphicControlExt() throws Exception {
        boolean transFlag;
        int blockSize = this.u1();
        int bits = this.u1();
        this.delay = this.u2() * 10;
        int transIndex = this.u1();
        int terminator = this.u1();
        this.dispose = bits >> 2 & 3;
        if (this.dispose == 0) {
            this.dispose = 1;
        }
        this.delay = Math.max(100, this.delay);
        boolean bl = false;
        if ((bits & 1) != 0) {
            bl = true;
        }
        if (transFlag = bl) {
            this.transIndex = transIndex;
        }
    }

    private final void readNetscapeExt() throws Exception {
        this.readBlock();
        if (this.blockSize > 0 && this.block[0] == 1) {
            int b1 = this.block[1] & 0xFF;
            int b2 = this.block[2] & 0xFF;
            this.animator.loopCount = b2 << 8 | b1;
        }
        int terminator = this.u1();
    }

    private final void skip() throws Exception {
        int size;
        while ((size = this.u1()) != 0) {
            this.pos += size;
        }
    }

    private final int u1() throws Exception {
        if (this.pos >= this.dataSize) {
            throw new EOFException();
        }
        return this.data[this.pos++] & 0xFF;
    }

    private final int u2() throws Exception {
        return this.u1() | this.u1() << 8;
    }

    private final int rgb() throws Exception {
        return (this.u1() << 16) + (this.u1() << 8) + this.u1();
    }

    private final int readBlock() throws Exception {
        this.blockSize = this.u1();
        int n = this.blockSize;
        if (n + this.pos >= this.dataSize) {
            throw new EOFException();
        }
        System.arraycopy(this.data, this.pos, this.block, 0, n);
        this.pos += n;
        return n;
    }

    private final IOException err() {
        return new IOException("Invalid GIF format");
    }

    public Image getImage() {
        return this.image;
    }

    public ImageAnimator getAnimator() {
        return this.animator;
    }

    private final /* synthetic */ void this() {
        this.animator = new GifAnimator();
        this.delay = -1;
        this.transIndex = -1;
        this.dispose = 0;
        this.lastDispose = 0;
        this.block = new byte[256];
    }

    public GifDecoder() {
        this.this();
    }

    static class ColorTable {
        byte[] r;
        byte[] g;
        byte[] b;
        int length;

        ColorTable() {
        }
    }
}

