/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;

public class DisabledImageFactory
extends RGBImageFilter {
    static final DisabledImageFactory filter = new DisabledImageFactory();
    static final Component component = new Component(){};
    static final MediaTracker tracker = new MediaTracker(component);
    protected static final int OUTLINE_COLOR = -10066330;
    protected float[] hsb;
    protected int[][] pixels;
    protected int width;
    protected int height;

    public static synchronized Image convert(Image colorImage) {
        FilteredImageSource src = new FilteredImageSource(colorImage.getSource(), filter);
        Image disabledImage = component.createImage(src);
        tracker.addImage(disabledImage, 0);
        try {
            tracker.waitForID(0, 0L);
        }
        catch (InterruptedException e) {
            System.out.println("DisabledImageFactory.convert -> interrupted");
        }
        tracker.removeImage(disabledImage, 0);
        return disabledImage;
    }

    public void setDimensions(int width, int height) {
        super.setDimensions(width, height);
        this.pixels = new int[width][height];
        this.width = width;
        this.height = height;
    }

    public int filterRGB(int x, int y, int rgb) {
        int alpha = rgb >> 24 & 0xFF;
        alpha = alpha >> 2 & 0xFF;
        int n = alpha << 24 | rgb & 0xFFFFFF;
        this.pixels[x][y] = n;
        return n;
    }

    private DisabledImageFactory() {
        this.canFilterIndexColorModel = false;
    }
}

