/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt;

import com.tridium.gx.ImagePeer;
import com.tridium.gx.awt.ImageData;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import javax.baja.gx.Graphics;

public final class AwtImagePeer
implements ImagePeer {
    public final ImageData data;

    public final Image image() {
        return this.data.getAnimatedImage();
    }

    public final Graphics getGraphics() {
        return this.data.getGraphics();
    }

    public final double getWidth() {
        return this.data.getWidth();
    }

    public final double getHeight() {
        return this.data.getHeight();
    }

    public final int[] getPixels() {
        int w = (int)this.data.getWidth();
        int h = (int)this.data.getHeight();
        int[] pixels = new int[w * h];
        try {
            PixelGrabber pg = new PixelGrabber(this.data.image, 0, 0, w, h, pixels, 0, w);
            pg.grabPixels();
        }
        catch (Exception e) {
            // empty catch block
        }
        return pixels;
    }

    public final void setPixels(int[] pixels) {
        if (this.data.image instanceof BufferedImage) {
            int h;
            int w = (int)this.data.getWidth();
            if (pixels.length != w * (h = (int)this.data.getHeight())) {
                throw new IllegalStateException("AwtImagePeer.setPixels: pixels.length != width x height");
            }
            BufferedImage bi = (BufferedImage)this.data.image;
            bi.setRGB(0, 0, w, h, pixels, 0, w);
        } else {
            System.out.println("AwtImagePeer.setPixels: Can not set pixels for non-memory images.");
        }
    }

    public final void dispose() {
        this.data.dispose();
    }

    public final boolean isLoaded() {
        return this.data.loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void sync() {
        if (this.data.loaded) {
            return;
        }
        ImageData imageData = this.data;
        synchronized (imageData) {
            while (!this.data.loaded) {
                try {
                    this.data.wait();
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    continue;
                }
                break;
            }
            return;
        }
    }

    public final boolean animate() {
        return this.data.animate();
    }

    public AwtImagePeer(ImageData data) {
        this.data = data;
    }

    AwtImagePeer(Image image) {
        this(new ImageData(image));
    }
}

