/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt;

import com.tridium.gx.DefaultGeomPeer;
import com.tridium.gx.awt.AwtEnv;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Stack;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AwtGraphics
implements Graphics {
    protected BFont font;
    protected BBrush brush;
    protected BPen pen;
    protected Graphics2D g;
    Stack stack;

    public final Graphics2D getAwtGraphics() {
        return this.g;
    }

    public final BBrush getBrush() {
        return this.brush;
    }

    public final void setBrush(BColor c) {
        this.setBrush(c.toBrush());
    }

    public final BPen getPen() {
        return this.pen;
    }

    public final BFont getFont() {
        return this.font;
    }

    public final void setFont(BFont font) {
        this.font = font;
        this.g.setFont(AwtEnv.peer((BFont)font).awtFont);
    }

    public final IGeom getClip() {
        return this.getClipBounds();
    }

    public final IRectGeom getClipBounds() {
        Rectangle r = this.g.getClipRect();
        return new RectGeom(r.x, r.y, r.width, r.height);
    }

    public final void clip(IGeom geom) {
        IRectGeom r = DefaultGeomPeer.toRect(geom);
        this.clip(r.x(), r.y(), r.width(), r.height());
    }

    public void drawString(String str, double x, double y) {
        if (str == null) {
            return;
        }
        this.g.drawString(str, (int)x, (int)y);
        if (this.font.isUnderline()) {
            this.drawUnderline(str, x, y);
        }
    }

    public void drawString(char[] data, int offset, int length, double x, double y) {
        this.g.drawChars(data, offset, length, (int)x, (int)y);
        if (this.font.isUnderline()) {
            this.drawUnderline(new String(data, offset, length), x, y);
        }
    }

    public final void drawImage(BImage img, double x, double y) {
        Image image = AwtEnv.peer(img).image();
        if (image != null) {
            this.g.drawImage(image, (int)x, (int)y, null);
        }
    }

    private final void drawUnderline(String str, double x, double y) {
        int tw = (int)this.font.width(str);
        this.g.drawLine((int)x, (int)y + 2, (int)x + tw, (int)y + 2);
    }

    public void push() {
        this.stack.push(this.g.create());
    }

    public void pop() {
        if (!this.stack.empty()) {
            this.g.dispose();
            this.g = (Graphics2D)this.stack.pop();
        }
    }

    public final void dispose() {
        this.g.dispose();
        this.g = null;
        while (!this.stack.empty()) {
            this.g = (Graphics2D)this.stack.pop();
            this.g.dispose();
            this.g = null;
        }
    }

    private final /* synthetic */ void this() {
        this.stack = new Stack();
    }

    public AwtGraphics(Graphics2D g) {
        this.this();
        this.g = g;
        this.brush = BBrush.DEFAULT;
        this.font = BFont.DEFAULT;
        this.pen = BPen.DEFAULT;
    }
}

