/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt;

import com.tridium.gx.FontPeer;
import com.tridium.gx.GxEnv;
import com.tridium.gx.ImagePeer;
import com.tridium.gx.awt.AwtFontPeer;
import com.tridium.gx.awt.AwtImagePeer;
import com.tridium.gx.awt.DisabledImageFactory;
import com.tridium.gx.awt.HighlightedImageFactory;
import com.tridium.gx.awt.ImageData;
import com.tridium.gx.awt.ImageManager;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;

public abstract class AwtEnv
extends GxEnv {
    public static Color TRANSPARENT = new Color(255, 255, 255, 0);

    public static GxEnv get() {
        return (AwtEnv)GxEnv.get();
    }

    public abstract Graphics makeGraphics(Graphics2D var1);

    public abstract Image makeBufferedImage(double var1, double var3);

    public FontPeer makeFontPeer(BFont font) {
        return AwtEnv.peer(font);
    }

    public ImagePeer makeImagePeer(BImage image) {
        return AwtEnv.peer(image);
    }

    public BImage makeImage(byte[] buf) {
        return this.makeImage(Toolkit.getDefaultToolkit().createImage(buf), true);
    }

    public BImage makeImage(Image awt, boolean sync) {
        if (sync) {
            ImageManager.sync(awt);
        }
        BImage image = BImage.make("new");
        image.fw(202, new AwtImagePeer(awt), null, null, null);
        return image;
    }

    public BImage makeImage(double width, double height) {
        Image awt = ((AwtEnv)AwtEnv.get()).makeBufferedImage(width, height);
        BImage image = BImage.make("new");
        image.fw(202, new AwtImagePeer(awt), null, null, null);
        return image;
    }

    public BImage makeDisabled(BImage orig) {
        Image awt = AwtEnv.peer(orig).image();
        if (awt == null) {
            return orig;
        }
        BImage disabled = BImage.make("new");
        disabled.fw(202, new AwtImagePeer(DisabledImageFactory.convert(awt)), null, null, null);
        return disabled;
    }

    public BImage makeHighlighted(BImage orig) {
        Image awt = AwtEnv.peer(orig).image();
        if (awt == null) {
            return orig;
        }
        BImage high = BImage.make("new");
        high.fw(202, new AwtImagePeer(HighlightedImageFactory.convert(awt)), null, null, null);
        return high;
    }

    public static Color peer(BColor color) {
        Color peer = (Color)color.fw(201, null, null, null, null);
        if (peer == null) {
            peer = AwtEnv.makePeer(color);
            color.fw(202, peer, null, null, null);
        }
        return peer;
    }

    public static AwtFontPeer peer(BFont font) {
        AwtFontPeer peer = (AwtFontPeer)font.fw(201, null, null, null, null);
        if (peer == null) {
            String fontName = AwtEnv.get().getValidFontName(font.getName());
            if (fontName == null) {
                fontName = font.getName();
            }
            peer = new AwtFontPeer(font, fontName);
            font.fw(202, peer, null, null, null);
        }
        return peer;
    }

    public static AwtImagePeer peer(BImage image) {
        AwtImagePeer peer = (AwtImagePeer)image.fw(201, null, null, null, null);
        if (peer == null) {
            ImageData data = ImageManager.fetchImageData(image);
            peer = new AwtImagePeer(data);
            image.fw(202, peer, null, null, null);
        }
        return peer;
    }

    private static final Color makePeer(BColor color) {
        if (color.isNull()) {
            return TRANSPARENT;
        }
        return new Color(color.getRGB(), true);
    }
}

