/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx;

import com.tridium.gx.FontPeer;
import com.tridium.gx.GeomPeer;
import com.tridium.gx.GraphPaper;
import com.tridium.gx.GxEnvListener;
import com.tridium.gx.Hatching;
import com.tridium.gx.ImagePeer;
import java.io.InputStream;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.IGeom;
import javax.baja.sys.Sys;

public abstract class GxEnv {
    private static GxEnv env;
    GxEnvListener listener;

    public static GxEnv get() {
        if (env == null) {
            try {
                if (System.getProperty("niagara.ui.env", "").equals("CanvasUiEnv")) {
                    env = (GxEnv)Sys.newInstance((String)"hx", (String)"com.tridium.hx.canvas.CanvasEnv");
                    return env;
                }
                if (System.getProperty("os.name", "").equals("QNX")) {
                    if (System.getProperty("niagara.ui.env", "").equals("AwtMeUiEnv")) {
                        env = (GxEnv)Sys.newInstance((String)"gx", (String)"com.tridium.gx.awt.me.AwtMeEnv");
                        return env;
                    }
                    if (System.getProperty("niagara.ui.env", "").equals("PwtUiEnv")) {
                        env = (GxEnv)Sys.newInstance((String)"pwt", (String)"com.tridium.pwt.gx.PwtEnv");
                        return env;
                    }
                    env = (GxEnv)Sys.newInstance((String)"gx", (String)"com.tridium.gx.micro.MicroEnv");
                    return env;
                }
                env = (GxEnv)Sys.newInstance((String)"gx", (String)"com.tridium.gx.awt.se.AwtSeEnv");
                return env;
            }
            catch (Throwable e) {
                try {
                    env = (GxEnv)Sys.newInstance((String)"gx", (String)"com.tridium.gx.micro.MicroEnv");
                    return env;
                }
                catch (Throwable e2) {
                    System.out.println("ERROR: Cannot load MicroEnv");
                    throw new IllegalStateException("No GxEnv available for VM");
                }
            }
        }
        return env;
    }

    public abstract boolean isRotationSupported();

    public abstract FontPeer makeFontPeer(BFont var1);

    public abstract GeomPeer makeGeomPeer(IGeom var1);

    public abstract ImagePeer makeImagePeer(BImage var1);

    public abstract BImage makeImage(double var1, double var3);

    public abstract BImage makeImage(byte[] var1);

    public BImage makeDisabled(BImage orig) {
        return orig;
    }

    public BImage makeHighlighted(BImage orig) {
        return orig;
    }

    public GxEnvListener getGxEnvListener() {
        return this.listener;
    }

    public void setGxEnvListener(GxEnvListener listener) {
        if (this.listener != null) {
            System.out.println("WARNING: GxEnv setGxEnvListener " + this.listener);
        }
        this.listener = listener;
    }

    public void repaintAll() {
        try {
            if (this.listener != null) {
                this.listener.repaintAll();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public GraphPaper makeGraphPaper() {
        throw new UnsupportedOperationException("GraphPaper not supported.");
    }

    public Hatching makeHatching() {
        throw new UnsupportedOperationException("Hatching not supported.");
    }

    public void loadFont(InputStream in) {
    }

    public String getValidFontName(String fontList) {
        return null;
    }

    public boolean hasFont(String fontName) {
        return false;
    }

    public void overrideFontFamily(String fontFamily, String valueName) {
    }
}

