/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx;

import com.tridium.gx.GeomPeer;
import javax.baja.gx.IEllipseGeom;
import javax.baja.gx.IGeom;
import javax.baja.gx.ILineGeom;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.IPolygonGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BDouble;

public abstract class DefaultGeomPeer
implements GeomPeer,
IRectGeom {
    public static DefaultGeomPeer make(IGeom geom) {
        switch (geom.getGeomCase()) {
            case 1: {
                return new Line((ILineGeom)geom);
            }
            case 2: {
                return new Rect((IRectGeom)geom);
            }
            case 3: {
                return new Ellipse((IEllipseGeom)geom);
            }
            case 4: {
                return new Polygon((IPolygonGeom)geom);
            }
            case 5: {
                return new Path((IPathGeom)geom);
            }
        }
        throw new UnsupportedOperationException("No GeomPeer support for " + geom.getClass().getName());
    }

    public int getGeomCase() {
        return 2;
    }

    public abstract double x();

    public abstract double y();

    public abstract double width();

    public abstract double height();

    public abstract IGeom geom();

    public IRectGeom bounds() {
        return this;
    }

    public boolean contains(double x, double y) {
        double x1 = this.x();
        double y1 = this.y();
        double x2 = x1 + this.width();
        double y2 = y1 + this.height();
        boolean bl = false;
        if (x1 <= x && y1 <= y && x <= x2 && y <= y2) {
            bl = true;
        }
        return bl;
    }

    public boolean contains(IGeom geom) {
        IRectGeom r = DefaultGeomPeer.toRect(geom);
        return this.contains(r.x(), r.y(), r.width(), r.height());
    }

    public boolean contains(double x, double y, double w, double h) {
        double x1 = this.x();
        double y1 = this.y();
        double x2 = x1 + this.width();
        double y2 = y1 + this.height();
        boolean bl = false;
        if (x1 <= x && y1 <= y && x <= x2 && y <= y2) {
            bl = true;
        }
        boolean a = bl;
        x += w;
        y += h;
        boolean bl2 = false;
        if (x1 <= x && y1 <= y && x <= x2 && y <= y2) {
            bl2 = true;
        }
        boolean b = bl2;
        boolean bl3 = false;
        if (a && b) {
            bl3 = true;
        }
        return bl3;
    }

    public boolean intersects(IGeom geom) {
        IRectGeom r = DefaultGeomPeer.toRect(geom);
        return this.intersects(r.x(), r.y(), r.width(), r.height());
    }

    public boolean intersects(double bx, double by, double bw, double bh) {
        double ax = this.x();
        double ay = this.y();
        double ax2 = ax + this.width();
        double ay2 = ay + this.height();
        double bx2 = bx + bw;
        double by2 = by + bh;
        if (ax < bx) {
            ax = bx;
        }
        if (ay < by) {
            ay = by;
        }
        if (ax2 > bx2) {
            ax2 = bx2;
        }
        if (ay2 > by2) {
            ay2 = by2;
        }
        ax2 -= ax;
        ay2 -= ay;
        boolean bl = false;
        if (ax2 > 0.0 && ay2 > 0.0) {
            bl = true;
        }
        return bl;
    }

    public IGeom intersection(IGeom geom) {
        return this.intersection(DefaultGeomPeer.toRect(geom));
    }

    public IGeom intersection(IRectGeom r) {
        return RectGeom.intersection(this, r, null);
    }

    public IGeom intersection(double rx, double ry, double rw, double rh) {
        return RectGeom.intersection(this.x(), this.y(), this.width(), this.height(), rx, ry, rw, rh, null);
    }

    public Object fw(int id, Object a, Object b, Object c, Object d) {
        return this;
    }

    public String toString() {
        return "GeomPeer[" + BDouble.encode((double)this.x()) + ',' + BDouble.encode((double)this.y()) + ',' + BDouble.encode((double)this.width()) + ',' + BDouble.encode((double)this.height()) + ']';
    }

    public static IRectGeom toRect(IGeom geom) {
        if (geom instanceof IRectGeom) {
            return (IRectGeom)geom;
        }
        return geom.bounds();
    }

    public static class Line
    extends DefaultGeomPeer {
        public final ILineGeom geom;

        public final IGeom geom() {
            return this.geom;
        }

        public final double x() {
            return Math.min(this.geom.x1(), this.geom.x2());
        }

        public final double y() {
            return Math.min(this.geom.y1(), this.geom.y2());
        }

        public final double width() {
            return Math.max(this.geom.x1(), this.geom.x2()) - this.x();
        }

        public final double height() {
            return Math.max(this.geom.y1(), this.geom.y2()) - this.y();
        }

        Line(ILineGeom geom) {
            this.geom = geom;
        }
    }

    public static class Rect
    extends DefaultGeomPeer {
        public final IRectGeom geom;

        public final IGeom geom() {
            return this.geom;
        }

        public final double x() {
            return this.geom.x();
        }

        public final double y() {
            return this.geom.y();
        }

        public final double width() {
            return this.geom.width();
        }

        public final double height() {
            return this.geom.height();
        }

        Rect(IRectGeom geom) {
            this.geom = geom;
        }
    }

    public static class Ellipse
    extends DefaultGeomPeer {
        public final IEllipseGeom geom;

        public final IGeom geom() {
            return this.geom;
        }

        public final double x() {
            return this.geom.x();
        }

        public final double y() {
            return this.geom.y();
        }

        public final double width() {
            return this.geom.width();
        }

        public final double height() {
            return this.geom.height();
        }

        Ellipse(IEllipseGeom geom) {
            this.geom = geom;
        }
    }

    public static class Polygon
    extends DefaultGeomPeer {
        public final IPolygonGeom geom;
        double x;
        double y;
        double w;
        double h;

        public final IGeom geom() {
            return this.geom;
        }

        public double x() {
            return this.x;
        }

        public double y() {
            return this.y;
        }

        public double width() {
            return this.w;
        }

        public double height() {
            return this.h;
        }

        protected void computeBounds() {
            int size = this.geom.size();
            if (size == 0) {
                return;
            }
            this.x = Double.POSITIVE_INFINITY;
            this.y = Double.POSITIVE_INFINITY;
            this.w = Double.NEGATIVE_INFINITY;
            this.h = Double.NEGATIVE_INFINITY;
            int i = 0;
            while (i < size) {
                double px = this.geom.x(i);
                double py = this.geom.y(i);
                this.x = Math.min(this.x, px);
                this.y = Math.min(this.y, py);
                this.w = Math.max(this.w, px);
                this.h = Math.max(this.h, py);
                ++i;
            }
            this.w -= this.x;
            this.h -= this.y;
        }

        Polygon(IPolygonGeom geom) {
            this.geom = geom;
            this.computeBounds();
        }
    }

    public static class Path
    extends DefaultGeomPeer {
        IPathGeom geom;
        double x;
        double y;
        double w;
        double h;

        public final IGeom geom() {
            return this.geom;
        }

        public double x() {
            return this.x;
        }

        public double y() {
            return this.y;
        }

        public double width() {
            return this.w;
        }

        public double height() {
            return this.h;
        }

        protected void computeBounds() {
            double cursorX = 0.0;
            double cursorY = 0.0;
            double minX = Double.NaN;
            double maxX = Double.NaN;
            double minY = Double.NaN;
            double maxY = Double.NaN;
            int i = 0;
            while (i < this.geom.segments().length) {
                IPathGeom.Segment segment = this.geom.segment(i);
                if (!(segment instanceof IPathGeom.ClosePath)) {
                    IPathGeom.Segment line;
                    if (segment instanceof IPathGeom.MoveTo) {
                        IPathGeom.MoveTo move = (IPathGeom.MoveTo)segment;
                        if (move.isAbsolute()) {
                            cursorX = move.getX();
                            cursorY = move.getY();
                        } else {
                            cursorX += move.getX();
                            cursorY += move.getY();
                        }
                        minX = Double.isNaN(minX) ? cursorX : Math.min(minX, cursorX);
                        maxX = Double.isNaN(maxX) ? cursorX : Math.max(maxX, cursorX);
                        minY = Double.isNaN(minY) ? cursorY : Math.min(minY, cursorY);
                        maxY = Double.isNaN(maxY) ? cursorY : Math.max(maxY, cursorY);
                    } else if (segment instanceof IPathGeom.LineTo) {
                        line = (IPathGeom.LineTo)segment;
                        if (line.isAbsolute()) {
                            cursorX = ((IPathGeom.LineTo)line).getX();
                            cursorY = ((IPathGeom.LineTo)line).getY();
                        } else {
                            cursorX += ((IPathGeom.LineTo)line).getX();
                            cursorY += ((IPathGeom.LineTo)line).getY();
                        }
                        minX = Double.isNaN(minX) ? cursorX : Math.min(minX, cursorX);
                        maxX = Double.isNaN(maxX) ? cursorX : Math.max(maxX, cursorX);
                        minY = Double.isNaN(minY) ? cursorY : Math.min(minY, cursorY);
                        maxY = Double.isNaN(maxY) ? cursorY : Math.max(maxY, cursorY);
                    } else if (segment instanceof IPathGeom.HLineTo) {
                        line = (IPathGeom.HLineTo)segment;
                        cursorX = line.isAbsolute() ? ((IPathGeom.HLineTo)line).getX() : (cursorX += ((IPathGeom.HLineTo)line).getX());
                        minX = Double.isNaN(minX) ? cursorX : Math.min(minX, cursorX);
                        maxX = Double.isNaN(maxX) ? cursorX : Math.max(maxX, cursorX);
                    } else if (segment instanceof IPathGeom.VLineTo) {
                        line = (IPathGeom.VLineTo)segment;
                        cursorY = line.isAbsolute() ? ((IPathGeom.VLineTo)line).getY() : (cursorY += ((IPathGeom.VLineTo)line).getY());
                        minY = Double.isNaN(minY) ? cursorY : Math.min(minY, cursorY);
                        maxY = Double.isNaN(maxY) ? cursorY : Math.max(maxY, cursorY);
                    } else if (segment instanceof IPathGeom.CurveTo) {
                        IPathGeom.CurveTo curve = (IPathGeom.CurveTo)segment;
                        if (curve.isAbsolute()) {
                            minX = Double.isNaN(minX) ? curve.getX1() : Math.min(minX, curve.getX1());
                            maxX = Double.isNaN(maxX) ? curve.getX1() : Math.max(maxX, curve.getX1());
                            minY = Double.isNaN(minY) ? curve.getY1() : Math.min(minY, curve.getY1());
                            maxY = Double.isNaN(maxY) ? curve.getY1() : Math.max(maxY, curve.getY1());
                            minX = Double.isNaN(minX) ? curve.getX2() : Math.min(minX, curve.getX2());
                            maxX = Double.isNaN(maxX) ? curve.getX2() : Math.max(maxX, curve.getX2());
                            minY = Double.isNaN(minY) ? curve.getY2() : Math.min(minY, curve.getY2());
                            maxY = Double.isNaN(maxY) ? curve.getY2() : Math.max(maxY, curve.getY2());
                        } else {
                            minX = Double.isNaN(minX) ? cursorX + curve.getX1() : Math.min(minX, cursorX + curve.getX1());
                            maxX = Double.isNaN(maxX) ? cursorX + curve.getX1() : Math.max(maxX, cursorX + curve.getX1());
                            minY = Double.isNaN(minY) ? cursorY + curve.getY1() : Math.min(minY, cursorY + curve.getY1());
                            maxY = Double.isNaN(maxY) ? cursorY + curve.getY1() : Math.max(maxY, cursorY + curve.getY1());
                            minX = Double.isNaN(minX) ? cursorX + curve.getX2() : Math.min(minX, cursorX + curve.getX2());
                            maxX = Double.isNaN(maxX) ? cursorX + curve.getX2() : Math.max(maxX, cursorX + curve.getX2());
                            minY = Double.isNaN(minY) ? cursorY + curve.getY2() : Math.min(minY, cursorY + curve.getY2());
                            double d = maxY = Double.isNaN(maxY) ? cursorY + curve.getY2() : Math.max(maxY, cursorY + curve.getY2());
                        }
                        if (curve.isAbsolute()) {
                            cursorX = curve.getX();
                            cursorY = curve.getY();
                        } else {
                            cursorX += curve.getX();
                            cursorY += curve.getY();
                        }
                        minX = Double.isNaN(minX) ? cursorX : Math.min(minX, cursorX);
                        maxX = Double.isNaN(maxX) ? cursorX : Math.max(maxX, cursorX);
                        minY = Double.isNaN(minY) ? cursorY : Math.min(minY, cursorY);
                        maxY = Double.isNaN(maxY) ? cursorY : Math.max(maxY, cursorY);
                    }
                }
                ++i;
            }
            this.x = minX;
            this.y = minY;
            this.w = maxX - minX;
            this.h = maxY - minY;
        }

        Path(IPathGeom geom) {
            this.geom = geom;
            this.computeBounds();
        }
    }
}

