/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfVideo.event;

import com.tridium.ddf.BDdfDevice;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddf.point.BDdfProxyExt;
import com.tridium.ddfVideo.DdfVideoLexicon;
import com.tridium.ddfVideo.comm.req.BDdfEventDetectionCtrlReq;
import com.tridium.ddfVideo.event.BDdfVideoEventStatus;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.dvr.BIVideoDvr;
import com.tridium.videoDriver.enums.BVideoEventTypesEnum;
import com.tridium.videoDriver.event.BIVideoEventDetection;
import com.tridium.videoDriver.event.BIVideoEventSource;
import com.tridium.videoDriver.event.BVideoEvent;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BStringPoint;
import javax.baja.driver.point.BProxyExt;
import javax.baja.license.LicenseException;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BDdfVideoEventProxyExt
extends BDdfProxyExt
implements BIVideoEventSource,
BIVideoEventDetection {
    public static final BRelTime DEFAULT_EVENT_EXPIRATION = BRelTime.makeSeconds((int)45);
    public static final Property mostRecentEvent = BDdfVideoEventProxyExt.newProperty((int)1, (BValue)BVideoEvent.makeNoEvent(), null);
    public static final Property autoExpiration = BDdfVideoEventProxyExt.newProperty((int)0, (boolean)true, null);
    public static final Property autoExpirationInterval = BDdfVideoEventProxyExt.newProperty((int)0, (BValue)DEFAULT_EVENT_EXPIRATION, null);
    public static final Action enableDetection = BDdfVideoEventProxyExt.newAction((int)0, null);
    public static final Action disableDetection = BDdfVideoEventProxyExt.newAction((int)0, null);
    public static final Action eventExpired = BDdfVideoEventProxyExt.newAction((int)4, null);
    public static final Topic videoEventOccurred = BDdfVideoEventProxyExt.newTopic((int)0, null);
    public static final Type TYPE;
    public static final BasicContext CONTEXT_PROXY_UPDATE;
    protected Clock.Ticket eventExpirationTicket;
    protected BVideoEvent currentOffNormalEvent;
    static /* synthetic */ Class class$com$tridium$ddfVideo$event$BDdfVideoEventProxyExt;

    public BVideoEvent getMostRecentEvent() {
        return (BVideoEvent)this.get(mostRecentEvent);
    }

    public void setMostRecentEvent(BVideoEvent bVideoEvent) {
        this.set(mostRecentEvent, (BValue)bVideoEvent, null);
    }

    public boolean getAutoExpiration() {
        return this.getBoolean(autoExpiration);
    }

    public void setAutoExpiration(boolean bl) {
        this.setBoolean(autoExpiration, bl, null);
    }

    public BRelTime getAutoExpirationInterval() {
        return (BRelTime)this.get(autoExpirationInterval);
    }

    public void setAutoExpirationInterval(BRelTime bRelTime) {
        this.set(autoExpirationInterval, (BValue)bRelTime, null);
    }

    public void enableDetection() {
        this.invoke(enableDetection, null, null);
    }

    public void disableDetection() {
        this.invoke(disableDetection, null, null);
    }

    public void eventExpired() {
        this.invoke(eventExpired, null, null);
    }

    public void fireVideoEventOccurred(BVideoEvent bVideoEvent) {
        this.fire(videoEventOccurred, (BValue)bVideoEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void proxyExtStarted() {
        try {
            Sys.getLicenseManager().checkFeature("tridium", "videoDriver");
            this.videoProxyExtStarted();
        }
        catch (LicenseException licenseException) {
            throw new BajaRuntimeException((Throwable)licenseException);
        }
        super.proxyExtStarted();
    }

    public void videoProxyExtStarted() {
        this.setStale(false, null);
    }

    public BIVideoDvr getVideoDvr() {
        BComplex bComplex = this.getParent();
        while (bComplex != null && !(bComplex instanceof BIVideoDvr)) {
            bComplex = bComplex.getParent();
        }
        return (BIVideoDvr)bComplex;
    }

    public BIVideoCamera getVideoCamera() {
        BComplex bComplex = this.getParent();
        while (bComplex != null && !(bComplex instanceof BIVideoCamera)) {
            bComplex = bComplex.getParent();
        }
        return (BIVideoCamera)bComplex;
    }

    public BVideoEventTypesEnum getEventTypeEnum() {
        return BVideoEventTypesEnum.nullEvent;
    }

    public Topic getVideoEventTopic() {
        return videoEventOccurred;
    }

    public void doEventExpired() {
        BVideoEvent bVideoEvent = (BVideoEvent)this.getMostRecentEvent().newCopy();
        bVideoEvent.setTimestamp(BAbsTime.now());
        bVideoEvent.setEventType(BVideoEventTypesEnum.eventExpired);
        bVideoEvent.setIsNormal(bVideoEvent.getIsNormal() ^ true);
        this.readOk(new BDdfVideoEventStatus(bVideoEvent));
    }

    public boolean isEventNormal(BVideoEvent bVideoEvent) {
        return bVideoEvent.getIsNormal();
    }

    public boolean isEventOffnormal(BVideoEvent bVideoEvent) {
        return this.isEventNormal(bVideoEvent) ^ true;
    }

    public boolean isAutomaticExpiration(BVideoEvent bVideoEvent) {
        return true;
    }

    public BRelTime getAutomaticExpirationInterval(BVideoEvent bVideoEvent) {
        return this.getAutoExpirationInterval();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readOk(BStatusValue bStatusValue) {
        boolean bl;
        if (!(bStatusValue instanceof BDdfVideoEventStatus)) throw new IllegalArgumentException("Given 'newValue' needs to be an instance of BDdfVideoEventStatus");
        BDdfVideoEventStatus bDdfVideoEventStatus = (BDdfVideoEventStatus)bStatusValue;
        BVideoEvent bVideoEvent = bDdfVideoEventStatus.getVideoEvent();
        this.setMostRecentEvent((BVideoEvent)bVideoEvent.newCopy());
        this.fireVideoEventOccurred(bDdfVideoEventStatus.getVideoEvent());
        BControlPoint bControlPoint = this.getParentPoint();
        if (this.eventExpirationTicket != null) {
            this.eventExpirationTicket.cancel();
        }
        if (bl = this.isEventOffnormal(bVideoEvent)) {
            if (this.currentOffNormalEvent == null) {
                bVideoEvent.updateProxyAlarmExt((BProxyExt)this, BOrd.NULL);
                this.currentOffNormalEvent = bVideoEvent;
            }
            if (this.getAutoExpiration()) {
                this.eventExpirationTicket = Clock.schedule((BComponent)this, (BRelTime)this.getAutomaticExpirationInterval(bVideoEvent), (Action)eventExpired, null);
            }
        } else {
            this.currentOffNormalEvent = null;
        }
        if (bControlPoint instanceof BINumeric) {
            if (bVideoEvent.getEventType() == BVideoEventTypesEnum.eventExpired) return;
            super.readOk((BStatusValue)new BStatusNumeric((double)bVideoEvent.getTimestamp().getMillis()));
            return;
        } else if (bControlPoint instanceof BIBoolean) {
            super.readOk((BStatusValue)new BStatusBoolean(bl));
            return;
        } else if (bControlPoint instanceof BIEnum) {
            BStatusEnum bStatusEnum = ((BEnumPoint)bControlPoint).getOut();
            super.readOk((BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)(this.isEventOffnormal(bVideoEvent) ? 1 : 0), (BEnumRange)bStatusEnum.getValue().getRange())));
            return;
        } else {
            if (!(bControlPoint instanceof BStringPoint)) throw new IllegalArgumentException("Unsupported control point type: " + bControlPoint.getType().getTypeSpec());
            super.readOk((BStatusValue)new BStatusString(bVideoEvent.toString((Context)CONTEXT_PROXY_UPDATE)));
        }
    }

    public void doEnableDetection() {
        try {
            BDdfEventDetectionCtrlReq bDdfEventDetectionCtrlReq = this.makeEventDetectionCtrlReq();
            bDdfEventDetectionCtrlReq.setDetectionEnabled(true);
            this.getDdfCommunicator().communicate((BIDdfRequest)bDdfEventDetectionCtrlReq);
        }
        catch (Exception exception) {
            this.writeFail(exception.toString());
        }
    }

    public void doDisableDetection() {
        try {
            BDdfEventDetectionCtrlReq bDdfEventDetectionCtrlReq = this.makeEventDetectionCtrlReq();
            bDdfEventDetectionCtrlReq.setDetectionEnabled(false);
            this.getDdfCommunicator().communicate((BIDdfRequest)bDdfEventDetectionCtrlReq);
        }
        catch (Exception exception) {
            this.writeFail(exception.toString());
        }
    }

    protected BDdfEventDetectionCtrlReq makeEventDetectionCtrlReq() {
        Type type = this.getEventDetectionCtrlReqType();
        if (type == null) {
            throw new BajaRuntimeException(DdfVideoLexicon.EventDetectionControl.notImplementedTypeNotSpecified(this.getType()));
        }
        if (type.is(BDdfEventDetectionCtrlReq.TYPE)) {
            BDdfEventDetectionCtrlReq bDdfEventDetectionCtrlReq = (BDdfEventDetectionCtrlReq)type.getInstance();
            BIVideoCamera bIVideoCamera = this.getVideoCamera();
            bDdfEventDetectionCtrlReq.setCamera(bIVideoCamera);
            if (bIVideoCamera instanceof BDdfDevice) {
                bDdfEventDetectionCtrlReq.setDeviceId((BDdfIdParams)((BDdfDevice)bIVideoCamera).getDeviceId().newCopy());
            }
            bDdfEventDetectionCtrlReq.setDetectionSource(this);
            return bDdfEventDetectionCtrlReq;
        }
        throw new BajaRuntimeException(DdfVideoLexicon.EventDetectionControl.wrongDetectionType(type));
    }

    protected abstract Type getEventDetectionCtrlReqType();

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.currentOffNormalEvent = null;
    }

    public BDdfVideoEventProxyExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$ddfVideo$event$BDdfVideoEventProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$ddfVideo$event$BDdfVideoEventProxyExt = BDdfVideoEventProxyExt.class("[Lcom.tridium.ddfVideo.event.BDdfVideoEventProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        CONTEXT_PROXY_UPDATE = new BasicContext();
    }
}

