/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfVideo.dvr;

import com.tridium.ddf.DdfFacets;
import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.comm.BIDdfCommunicating;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddfVideo.BDdfVideoDevice;
import com.tridium.ddfVideo.BDdfVideoNetwork;
import com.tridium.ddfVideo.DdfVideoStreamUtil;
import com.tridium.ddfVideo.camera.BDdfCameraDeviceExt;
import com.tridium.ddfVideo.camera.BDdfVideoCamera;
import com.tridium.ddfVideo.camera.BDdfVideoSourcePreferences;
import com.tridium.ddfVideo.comm.req.BDdfVideoStreamRequest;
import com.tridium.ddfVideo.comm.req.BIDdfVideoStreamRequest;
import com.tridium.ddfVideo.display.BDdfDisplayDeviceExt;
import com.tridium.ddfVideo.display.BDdfNullVideoDisplay;
import com.tridium.ddfVideo.dvr.BDdfVideoDvrPingMonitor;
import com.tridium.ddfVideo.identify.BDdfDvrId;
import com.tridium.videoDriver.BIVideoNetwork;
import com.tridium.videoDriver.camera.BIVideoCameraDeviceExt;
import com.tridium.videoDriver.display.BIVideoDisplayDeviceExt;
import com.tridium.videoDriver.dvr.BIVideoDvr;
import com.tridium.videoDriver.enums.BFoxVideoStreamEnum;
import com.tridium.videoDriver.enums.BVideoAspectRatioEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoResolutionEnum;
import com.tridium.videoDriver.ui.playback.VideoPlaybackSession;
import com.tridium.videoDriver.videoStream.BIVideoMultistreamServer;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoPlayback;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.gx.BColor;
import javax.baja.license.LicenseException;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BDdfVideoDvr
extends BDdfVideoDevice
implements BIVideoDvr,
BIDdfCommunicating,
BIVideoMultistreamServer {
    public static final Property monitor = BDdfVideoDvr.newProperty((int)0, (BValue)new BDdfVideoDvrPingMonitor(), null);
    public static final Property deviceId = BDdfVideoDvr.newProperty((int)0, (BValue)new BDdfDvrId(), null);
    public static final Property foxVideoStreamPreferred = BDdfVideoDvr.newProperty((int)0, (BValue)BFoxVideoStreamEnum.inherit, (BFacets)DdfFacets.combine((BFacets)IDdfFacetConst.MGR_INCLUDE, (BFacets)IDdfFacetConst.MGR_OPTIONAL_IN_TABLE));
    public static final Property multistreamPreferences = BDdfVideoDvr.newProperty((int)0, (BValue)new BDdfVideoSourcePreferences(), null);
    public static final Property displays = BDdfVideoDvr.newProperty((int)4, (BValue)new BDdfDisplayDeviceExt(), null);
    public static final Property cameras = BDdfVideoDvr.newProperty((int)0, (BValue)new BDdfCameraDeviceExt(), null);
    public static final Type TYPE;
    protected DdfVideoStreamUtil multistreamVideoStreamUtil;
    static /* synthetic */ Class class$com$tridium$ddfVideo$dvr$BDdfVideoDvr;

    public BPingMonitor getMonitor() {
        return (BPingMonitor)this.get(monitor);
    }

    public void setMonitor(BPingMonitor bPingMonitor) {
        this.set(monitor, (BValue)bPingMonitor, null);
    }

    public BDdfIdParams getDeviceId() {
        return (BDdfIdParams)this.get(deviceId);
    }

    public void setDeviceId(BDdfIdParams bDdfIdParams) {
        this.set(deviceId, (BValue)bDdfIdParams, null);
    }

    public BFoxVideoStreamEnum getFoxVideoStreamPreferred() {
        return (BFoxVideoStreamEnum)this.get(foxVideoStreamPreferred);
    }

    public void setFoxVideoStreamPreferred(BFoxVideoStreamEnum bFoxVideoStreamEnum) {
        this.set(foxVideoStreamPreferred, (BValue)bFoxVideoStreamEnum, null);
    }

    public BDdfVideoSourcePreferences getMultistreamPreferences() {
        return (BDdfVideoSourcePreferences)this.get(multistreamPreferences);
    }

    public void setMultistreamPreferences(BDdfVideoSourcePreferences bDdfVideoSourcePreferences) {
        this.set(multistreamPreferences, (BValue)bDdfVideoSourcePreferences, null);
    }

    public BDdfDisplayDeviceExt getDisplays() {
        return (BDdfDisplayDeviceExt)this.get(displays);
    }

    public void setDisplays(BDdfDisplayDeviceExt bDdfDisplayDeviceExt) {
        this.set(displays, (BValue)bDdfDisplayDeviceExt, null);
    }

    public BDdfCameraDeviceExt getCameras() {
        return (BDdfCameraDeviceExt)this.get(cameras);
    }

    public void setCameras(BDdfCameraDeviceExt bDdfCameraDeviceExt) {
        this.set(cameras, (BValue)bDdfCameraDeviceExt, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        if (property.equals((Object)faultCause)) {
            this.getDisplays().updateStatus();
            this.getCameras().updateStatus();
        }
        super.changed(property, context);
    }

    public final void started() throws Exception {
        try {
            Sys.getLicenseManager().checkFeature("tridium", "videoDriver");
            this.videoDvrStarted();
        }
        catch (LicenseException licenseException) {
            this.configFatal(licenseException.toString());
        }
        super.started();
    }

    public void videoDvrStarted() throws Exception {
    }

    public Type getVideoDisplayType() {
        return BDdfNullVideoDisplay.TYPE;
    }

    public BIVideoCameraDeviceExt getCameraExt() {
        return this.getCameras();
    }

    public BIVideoDisplayDeviceExt getDisplayExt() {
        return this.getDisplays();
    }

    public String getDvrDescription() {
        BDdfIdParams bDdfIdParams = this.getDeviceId();
        if (bDdfIdParams instanceof BDdfDvrId) {
            return ((BDdfDvrId)bDdfIdParams).getDescription();
        }
        return this.getDisplayName(null);
    }

    protected abstract Type getMultistreamVideoStreamRequestType();

    public BIDdfVideoStreamRequest makeMultistreamVideoStreamRequest(BPlaybackParams bPlaybackParams, IVideoDestination iVideoDestination) {
        Type type = this.getMultistreamVideoStreamRequestType();
        return BDdfVideoStreamRequest.makeVideoStreamRequest(type, (BIVideoSource)this, bPlaybackParams, iVideoDestination);
    }

    public boolean supportsPlaybackControl() {
        return false;
    }

    public boolean isTimestampPreferred() {
        return this.getMultistreamPreferences().getTimestampPreferred();
    }

    public BRelTime getInterframeTimeout() {
        if (this.isDown()) {
            return BDdfVideoCamera.ONE_SECOND;
        }
        return this.getMultistreamPreferences().getInterframeTimeout();
    }

    public BIVideoNetwork getVideoNetwork() {
        BComplex bComplex = this.getParent();
        while (bComplex != null && !(bComplex instanceof BIVideoNetwork)) {
            bComplex = bComplex.getParent();
        }
        return (BIVideoNetwork)bComplex;
    }

    protected boolean recurseFoxVideoStreamPreferredToNet() {
        BIVideoNetwork bIVideoNetwork = this.getVideoNetwork();
        if (bIVideoNetwork != null && bIVideoNetwork instanceof BDdfVideoNetwork) {
            if (bIVideoNetwork instanceof BComponent) {
                ((BComponent)bIVideoNetwork).lease();
                try {
                    ((BComponent)bIVideoNetwork).getComponentSpace().sync();
                }
                catch (Exception exception) {
                    this.getDdfCommunicator().getLog().error("Unable to retrieve updated property values on the network. This was needed to resolve the fox video stream preference of 'inherit'. Defaulting to false.", (Throwable)exception);
                    return false;
                }
            }
            return ((BDdfVideoNetwork)bIVideoNetwork).getFoxVideoStreamPreferred();
        }
        this.getDdfCommunicator().getLog().message("Network does not inherit from BDdfVideoNetwork. Unable to recurse beyond the 'inherit' setting on the DVR. Defaulting to 'No' for 'foxStreamPreferred'.");
        return false;
    }

    public boolean isFoxVideoStreamPreferred() {
        BFoxVideoStreamEnum bFoxVideoStreamEnum = this.getMultistreamPreferences().getPreferredVideoStreamFox();
        if (bFoxVideoStreamEnum == BFoxVideoStreamEnum.inherit) {
            return this.recurseFoxVideoStreamPreferredToNet();
        }
        if (bFoxVideoStreamEnum == BFoxVideoStreamEnum.no) {
            return false;
        }
        if (bFoxVideoStreamEnum == BFoxVideoStreamEnum.yes) {
            return true;
        }
        throw new IllegalStateException("Unrecognized foxStreamEnum: " + bFoxVideoStreamEnum + ". Please have my program fixed.");
    }

    public BFoxVideoStreamEnum getFoxVideoStreamSetting() {
        return this.getMultistreamPreferences().getPreferredVideoStreamFox();
    }

    public BColor getPreferredBackgroundColor() {
        return this.getMultistreamPreferences().getPreferredBackgroundColor();
    }

    public BVideoAspectRatioEnum getPreferredAspectRatio() {
        return this.getMultistreamPreferences().getPreferredAspectRatio();
    }

    public BVideoResolutionEnum getPreferredResolution() {
        return this.getMultistreamPreferences().getPreferredResolution();
    }

    public BVideoFrameRateEnum getPreferredFrameRate() {
        return this.getMultistreamPreferences().getPreferredFrameRate();
    }

    public BVideoCompressionEnum getPreferredCompression() {
        return this.getMultistreamPreferences().getPreferredCompression();
    }

    public VideoPlaybackSession newPlaybackSession(IVideoPlayback iVideoPlayback) {
        return new VideoPlaybackSession(iVideoPlayback);
    }

    public void streamToDestination(BPlaybackParams bPlaybackParams, IVideoDestination iVideoDestination) {
        if (this.multistreamVideoStreamUtil == null) {
            this.multistreamVideoStreamUtil = new DdfVideoStreamUtil((BComponent)this);
        }
        this.multistreamVideoStreamUtil.streamToDestination(bPlaybackParams, iVideoDestination);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$ddfVideo$dvr$BDdfVideoDvr;
        if (clazz == null) {
            clazz = class$com$tridium$ddfVideo$dvr$BDdfVideoDvr = BDdfVideoDvr.class("[Lcom.tridium.ddfVideo.dvr.BDdfVideoDvr;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

