/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfVideo.camera;

import com.tridium.ddf.DdfFacets;
import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.req.util.DdfRequestUtil;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddfVideo.BDdfVideoNetwork;
import com.tridium.ddfVideo.DdfVideoLexicon;
import com.tridium.ddfVideo.DdfVideoStreamUtil;
import com.tridium.ddfVideo.camera.BDdfSimpleVideoCamera;
import com.tridium.ddfVideo.camera.BDdfVideoSourcePreferences;
import com.tridium.ddfVideo.camera.controlHelper.BDdfCameraControlTimings;
import com.tridium.ddfVideo.camera.controlHelper.BDdfFocusControlHelper;
import com.tridium.ddfVideo.camera.controlHelper.BDdfIrisControlHelper;
import com.tridium.ddfVideo.camera.controlHelper.BDdfMovementControlHelper;
import com.tridium.ddfVideo.camera.controlHelper.BDdfZoomControlHelper;
import com.tridium.ddfVideo.comm.req.BDdfVideoStreamRequest;
import com.tridium.ddfVideo.comm.req.BIDdfFocusCtrlReq;
import com.tridium.ddfVideo.comm.req.BIDdfIrisCtrlReq;
import com.tridium.ddfVideo.comm.req.BIDdfMoveToPresetReq;
import com.tridium.ddfVideo.comm.req.BIDdfPanTiltReq;
import com.tridium.ddfVideo.comm.req.BIDdfStorePresetReq;
import com.tridium.ddfVideo.comm.req.BIDdfVideoStreamRequest;
import com.tridium.ddfVideo.comm.req.BIDdfZoomReq;
import com.tridium.ddfVideo.display.BDdfVideoDisplay;
import com.tridium.ddfVideo.display.BDdfVideoDisplayChooser;
import com.tridium.ddfVideo.dvr.BDdfVideoDvr;
import com.tridium.ddfVideo.identify.BDdfVideoCameraInfo;
import com.tridium.ddfVideo.identify.BDdfVideoDeviceId;
import com.tridium.videoDriver.BIVideoDeviceSystem;
import com.tridium.videoDriver.BIVideoNetwork;
import com.tridium.videoDriver.camera.BIVideoPtzCamera;
import com.tridium.videoDriver.camera.control.BIVideoFocusControl;
import com.tridium.videoDriver.camera.control.BIVideoIrisControl;
import com.tridium.videoDriver.camera.control.BIVideoPanTiltControl;
import com.tridium.videoDriver.camera.control.BIVideoStorePresetControl;
import com.tridium.videoDriver.dvr.BIVideoDvr;
import com.tridium.videoDriver.enums.BFoxVideoStreamEnum;
import com.tridium.videoDriver.enums.BVideoAspectRatioEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFocusEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoIrisEnum;
import com.tridium.videoDriver.enums.BVideoPanTiltEnum;
import com.tridium.videoDriver.enums.BVideoResolutionEnum;
import com.tridium.videoDriver.enums.BVideoZoomEnum;
import com.tridium.videoDriver.ui.playback.VideoPlaybackSession;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoPlayback;
import java.util.HashMap;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.gx.BColor;
import javax.baja.naming.BOrd;
import javax.baja.naming.NullOrdException;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BDdfVideoCamera
extends BDdfSimpleVideoCamera
implements BIVideoPtzCamera,
BIVideoFocusControl,
BIVideoIrisControl,
BIVideoStorePresetControl,
BIVideoSource {
    protected static final BNameMap RENAME_PING_PARAMS;
    public static final Property pingParameters;
    public static final Property controlTiming;
    public static final Property videoPreferences;
    public static final Action move;
    public static final Action zoom;
    public static final Action moveToPreset;
    public static final Action storePreset;
    public static final Action makeActive;
    public static final Action irisControl;
    public static final Action focusControl;
    public static final Type TYPE;
    protected static final BIcon icon;
    public static final BRelTime ONE_SECOND;
    protected int videoStreamThreadNumber;
    protected BDdfFocusControlHelper focusControlHelper;
    protected BDdfIrisControlHelper irisControlHelper;
    protected BDdfZoomControlHelper zoomControlHelper;
    protected BDdfMovementControlHelper movementControlHelper;
    protected DdfVideoStreamUtil videoStreamUtil;
    static /* synthetic */ Class class$com$tridium$ddfVideo$camera$BDdfVideoCamera;

    public BDdfIdParams getPingParameters() {
        return (BDdfIdParams)this.get(pingParameters);
    }

    public void setPingParameters(BDdfIdParams bDdfIdParams) {
        this.set(pingParameters, (BValue)bDdfIdParams, null);
    }

    public BDdfCameraControlTimings getControlTiming() {
        return (BDdfCameraControlTimings)this.get(controlTiming);
    }

    public void setControlTiming(BDdfCameraControlTimings bDdfCameraControlTimings) {
        this.set(controlTiming, (BValue)bDdfCameraControlTimings, null);
    }

    public BDdfVideoSourcePreferences getVideoPreferences() {
        return (BDdfVideoSourcePreferences)this.get(videoPreferences);
    }

    public void setVideoPreferences(BDdfVideoSourcePreferences bDdfVideoSourcePreferences) {
        this.set(videoPreferences, (BValue)bDdfVideoSourcePreferences, null);
    }

    public void move(BVideoPanTiltEnum bVideoPanTiltEnum) {
        this.invoke(move, (BValue)bVideoPanTiltEnum, null);
    }

    public void zoom(BVideoZoomEnum bVideoZoomEnum) {
        this.invoke(zoom, (BValue)bVideoZoomEnum, null);
    }

    public void moveToPreset(BValue bValue) {
        this.invoke(moveToPreset, bValue, null);
    }

    public void storePreset(BValue bValue) {
        this.invoke(storePreset, bValue, null);
    }

    public void makeActive(BDdfVideoDisplayChooser bDdfVideoDisplayChooser) {
        this.invoke(makeActive, (BValue)bDdfVideoDisplayChooser, null);
    }

    public void irisControl(BVideoIrisEnum bVideoIrisEnum) {
        this.invoke(irisControl, (BValue)bVideoIrisEnum, null);
    }

    public void focusControl(BVideoFocusEnum bVideoFocusEnum) {
        this.invoke(focusControl, (BValue)bVideoFocusEnum, null);
    }

    public Type getType() {
        return TYPE;
    }

    public AgentList getAgents(Context context) {
        AgentInfo agentInfo;
        String string;
        AgentList agentList = super.getAgents(context);
        if (this.addLiveVideoView()) {
            string = this.getCameraViewTypeSpec();
            try {
                agentInfo = Sys.getRegistry().getType(string).getAgentInfo();
                agentList.add(agentInfo);
                if (this.areCameraViewsTopMost()) {
                    agentList.toTop(agentInfo);
                }
            }
            catch (TypeNotFoundException typeNotFoundException) {
                System.out.println(Lexicon.make((String)"devVideoDriver").getText("CameraViewNotFound", new Object[]{string, this.getSlotPath()}));
            }
        }
        if (this.addPlaybackView()) {
            string = this.getPlaybackViewTypeSpec();
            try {
                agentInfo = Sys.getRegistry().getType(string).getAgentInfo();
                agentList.add(agentInfo);
                if (this.areCameraViewsTopMost()) {
                    agentList.toTop(agentInfo);
                }
            }
            catch (TypeNotFoundException typeNotFoundException) {
                System.out.println(Lexicon.make((String)"devVideoDriver").getText("PlaybackViewNotFound", new Object[]{string, this.getSlotPath()}));
            }
        }
        try {
            string = Sys.getRegistry().getType("accessControl:HxWbAccessView").getAgentInfo();
            agentList.add((AgentInfo)string);
        }
        catch (Exception exception) {}
        return agentList;
    }

    protected boolean addLiveVideoView() {
        return true;
    }

    protected boolean addPlaybackView() {
        return true;
    }

    protected String getCameraViewTypeSpec() {
        return "videoDriver:LiveVideo";
    }

    protected String getPlaybackViewTypeSpec() {
        return "videoDriver:VideoPlayback";
    }

    protected boolean areCameraViewsTopMost() {
        return true;
    }

    protected abstract Type getPanTiltReqType();

    protected abstract Type getZoomReqType();

    protected abstract Type getMoveToPresetReqType();

    protected abstract Type getStorePresetReqType();

    protected abstract Type getIrisCtrlReqType();

    protected abstract Type getFocusCtrlReqType();

    protected BValue getMoveToPresetActionDefault() {
        return BString.make((String)"-");
    }

    protected BValue getStorePresetActionDefault() {
        return BString.make((String)"-");
    }

    public BDdfVideoCameraInfo getCameraInfo() {
        BDdfIdParams bDdfIdParams = this.getPingParameters();
        if (bDdfIdParams instanceof BDdfVideoCameraInfo) {
            return (BDdfVideoCameraInfo)this.getPingParameters();
        }
        return null;
    }

    public BIVideoDeviceSystem getVideoSystem() {
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BIVideoDeviceSystem) {
                return (BIVideoDeviceSystem)bComplex;
            }
            bComplex = bComplex.getParent();
        }
        return null;
    }

    public void doMove(BVideoPanTiltEnum bVideoPanTiltEnum) {
        if (this.getCameraInfo().getSupportsPanTilt()) {
            this.movementControlHelper.controlCamera(bVideoPanTiltEnum);
        } else if (this.getDdfCommunicator().getLog().isTraceOn()) {
            this.getDdfCommunicator().getLog().trace(DdfVideoLexicon.PanTilt.videoCameraDoesNotSupportPanTilt(this.getSlotPath()));
        }
    }

    public void doZoom(BVideoZoomEnum bVideoZoomEnum) {
        if (this.getCameraInfo().getSupportsZoom()) {
            this.zoomControlHelper.controlCamera(bVideoZoomEnum);
        } else if (this.getDdfCommunicator().getLog().isTraceOn()) {
            this.getDdfCommunicator().getLog().trace(DdfVideoLexicon.Zoom.videoCameraDoesNotSupportZoom(this.getSlotPath()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doMoveToPreset(BValue bValue) {
        if (this.getCameraInfo().getSupportsMoveToPreset()) {
            Type type = this.getMoveToPresetReqType();
            if (type == null) {
                throw new BajaRuntimeException(DdfVideoLexicon.CameraPreset.moveToPresetReqTypeCantBeNull);
            }
            if (!type.is(BIDdfMoveToPresetReq.TYPE)) throw new BajaRuntimeException(DdfVideoLexicon.CameraPreset.moveToPresetReqTypeMustImplementBIDdfMoveToPresetReq);
            if (bValue instanceof BStatusEnum) {
                BStatusEnum bStatusEnum = (BStatusEnum)bValue;
                if (bStatusEnum.getStatus().isValid()) {
                    bValue = bStatusEnum.getEnum();
                } else if (this.getDdfCommunicator().getLog().isTraceOn()) {
                    this.getDdfCommunicator().getLog().trace(DdfVideoLexicon.CameraPreset.moveToPresetInvalidStatusEnum(bStatusEnum));
                    return;
                }
            }
            BIDdfMoveToPresetReq bIDdfMoveToPresetReq = this.makeMoveToPresetReq(bValue, type);
            this.getDdfCommunicator().communicate((BIDdfRequest)bIDdfMoveToPresetReq);
            return;
        } else {
            if (!this.getDdfCommunicator().getLog().isTraceOn()) return;
            this.getDdfCommunicator().getLog().trace(DdfVideoLexicon.CameraPreset.videoCameraDoesNotSupportMoveToPreset(this.getSlotPath()));
        }
    }

    protected BIDdfMoveToPresetReq makeMoveToPresetReq(BValue bValue, Type type) {
        BIDdfMoveToPresetReq bIDdfMoveToPresetReq = (BIDdfMoveToPresetReq)type.getInstance();
        bIDdfMoveToPresetReq.setDeviceId((BDdfIdParams)this.getDeviceId().newCopy());
        bIDdfMoveToPresetReq.setVideoComponent((BIVideoPanTiltControl)this);
        bIDdfMoveToPresetReq.setPosition(bValue.newCopy());
        return bIDdfMoveToPresetReq;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doStorePreset(BValue bValue) {
        if (this.getCameraInfo().getSupportsStorePreset()) {
            Type type = this.getStorePresetReqType();
            if (type == null) {
                throw new BajaRuntimeException(DdfVideoLexicon.CameraPreset.storePresetReqTypeCantBeNull);
            }
            if (!type.is(BIDdfStorePresetReq.TYPE)) throw new BajaRuntimeException(DdfVideoLexicon.CameraPreset.storePresetReqTypeMustImplementBIDdfStorePresetReq);
            BIDdfStorePresetReq bIDdfStorePresetReq = this.makeStorePresetReq(bValue, type);
            this.getDdfCommunicator().communicate((BIDdfRequest)bIDdfStorePresetReq);
            return;
        } else {
            if (!this.getDdfCommunicator().getLog().isTraceOn()) return;
            this.getDdfCommunicator().getLog().trace(DdfVideoLexicon.CameraPreset.videoCameraDoesNotSupportStorePreset(this.getSlotPath()));
        }
    }

    protected BIDdfStorePresetReq makeStorePresetReq(BValue bValue, Type type) {
        BIDdfStorePresetReq bIDdfStorePresetReq = (BIDdfStorePresetReq)type.getInstance();
        bIDdfStorePresetReq.setDeviceId((BDdfIdParams)this.getDeviceId().newCopy());
        bIDdfStorePresetReq.setVideoComponent((BIVideoPanTiltControl)this);
        bIDdfStorePresetReq.setPosition(bValue);
        return bIDdfStorePresetReq;
    }

    public void doMakeActive(BDdfVideoDisplayChooser bDdfVideoDisplayChooser) {
        BOrd bOrd = bDdfVideoDisplayChooser.getVideoDisplayOrd();
        try {
            BOrd bOrd2 = BOrd.make((BOrd)this.getOrdInHost(), (BOrd)bOrd);
            BDdfVideoDisplay bDdfVideoDisplay = (BDdfVideoDisplay)bOrd2.get();
            bDdfVideoDisplay.makeActiveCamera(this.getAbsoluteOrd());
        }
        catch (NullOrdException nullOrdException) {
            this.getDdfCommunicator().getLog().message(DdfVideoLexicon.MakeActiveCamera.cannotMakeCameraActiveBecauseNoDisplays);
        }
    }

    public void doIrisControl(BVideoIrisEnum bVideoIrisEnum) {
        if (this.getCameraInfo().getSupportsIris()) {
            this.irisControlHelper.controlCamera(bVideoIrisEnum);
        } else if (this.getDdfCommunicator().getLog().isTraceOn()) {
            this.getDdfCommunicator().getLog().trace(DdfVideoLexicon.Iris.videoCameraDoesNotSupportIrisControl(this.getSlotPath()));
        }
    }

    public void doFocusControl(BVideoFocusEnum bVideoFocusEnum) {
        if (this.getCameraInfo().getSupportsFocus()) {
            this.focusControlHelper.controlCamera(bVideoFocusEnum);
        } else if (this.getDdfCommunicator().getLog().isTraceOn()) {
            this.getDdfCommunicator().getLog().trace(DdfVideoLexicon.Focus.videoCameraDoesNotSupportFocusControl(this.getSlotPath()));
        }
    }

    public String getCameraDescription() {
        BDdfIdParams bDdfIdParams = this.getDeviceId();
        if (bDdfIdParams instanceof BDdfVideoDeviceId) {
            return ((BDdfVideoDeviceId)bDdfIdParams).getDescription();
        }
        return bDdfIdParams.toString();
    }

    public abstract Action getMoveToPresetAction();

    public abstract Action getStorePresetAction();

    public BValue getActionParameterDefault(Action action) {
        if (action.equals((Object)makeActive)) {
            BComponent bComponent = (BComponent)this.getVideoSystem();
            BOrd bOrd = bComponent.getAbsoluteOrd();
            BDdfVideoDisplayChooser bDdfVideoDisplayChooser = new BDdfVideoDisplayChooser();
            bDdfVideoDisplayChooser.setVideoSystemOrd(bOrd);
            return bDdfVideoDisplayChooser;
        }
        if (action.equals((Object)moveToPreset)) {
            return this.getMoveToPresetActionDefault();
        }
        if (action.equals((Object)storePreset)) {
            return this.getStorePresetActionDefault();
        }
        return super.getActionParameterDefault(action);
    }

    public void onFocusControl(BVideoFocusEnum bVideoFocusEnum) {
        Type type = this.getFocusCtrlReqType();
        if (type == null) {
            throw new BajaRuntimeException(DdfVideoLexicon.Focus.focusCtrlReqTypeCantBeNull);
        }
        if (!type.is(BIDdfFocusCtrlReq.TYPE)) {
            throw new BajaRuntimeException(DdfVideoLexicon.Focus.focusCtrlReqTypeMustImplementBIDdfFocusCtrlReq);
        }
        BIDdfFocusCtrlReq bIDdfFocusCtrlReq = this.makeFocusCtrlReq(bVideoFocusEnum, type);
        DdfRequestUtil.communicateSync((BIDdfCommunicator)this.getDdfCommunicator(), (BIDdfRequest)bIDdfFocusCtrlReq);
    }

    protected BIDdfFocusCtrlReq makeFocusCtrlReq(BVideoFocusEnum bVideoFocusEnum, Type type) {
        BIDdfFocusCtrlReq bIDdfFocusCtrlReq = (BIDdfFocusCtrlReq)type.getInstance();
        bIDdfFocusCtrlReq.setDeviceId((BDdfIdParams)this.getDeviceId().newCopy());
        bIDdfFocusCtrlReq.setVideoComponent(this);
        bIDdfFocusCtrlReq.setFocusEnum(bVideoFocusEnum);
        return bIDdfFocusCtrlReq;
    }

    public void onIrisControl(BVideoIrisEnum bVideoIrisEnum) {
        Type type = this.getIrisCtrlReqType();
        if (type == null) {
            throw new BajaRuntimeException(DdfVideoLexicon.Iris.irisCtrlReqTypeCantBeNull);
        }
        if (!type.is(BIDdfIrisCtrlReq.TYPE)) {
            throw new BajaRuntimeException(DdfVideoLexicon.Iris.irisCtrlReqTypeMustImplementBIDdfIrisCtrlReq);
        }
        BIDdfIrisCtrlReq bIDdfIrisCtrlReq = this.makeIrisCtrlReq(bVideoIrisEnum, type);
        DdfRequestUtil.communicateSync((BIDdfCommunicator)this.getDdfCommunicator(), (BIDdfRequest)bIDdfIrisCtrlReq);
    }

    protected BIDdfIrisCtrlReq makeIrisCtrlReq(BVideoIrisEnum bVideoIrisEnum, Type type) {
        BIDdfIrisCtrlReq bIDdfIrisCtrlReq = (BIDdfIrisCtrlReq)type.getInstance();
        bIDdfIrisCtrlReq.setDeviceId((BDdfIdParams)this.getDeviceId().newCopy());
        bIDdfIrisCtrlReq.setVideoComponent(this);
        bIDdfIrisCtrlReq.setIrisEnum(bVideoIrisEnum);
        return bIDdfIrisCtrlReq;
    }

    public void onZoom(BVideoZoomEnum bVideoZoomEnum) {
        Type type = this.getZoomReqType();
        if (type == null) {
            throw new BajaRuntimeException(DdfVideoLexicon.Zoom.zoomReqTypeCantBeNull);
        }
        if (!type.is(BIDdfZoomReq.TYPE)) {
            throw new BajaRuntimeException(DdfVideoLexicon.Zoom.zoomReqTypeMustImplementBIDdfZoomReq);
        }
        BIDdfZoomReq bIDdfZoomReq = this.makeZoomReq(bVideoZoomEnum, type);
        this.getDdfCommunicator().communicate((BIDdfRequest)bIDdfZoomReq);
    }

    protected BIDdfZoomReq makeZoomReq(BVideoZoomEnum bVideoZoomEnum, Type type) {
        BIDdfZoomReq bIDdfZoomReq = (BIDdfZoomReq)type.getInstance();
        bIDdfZoomReq.setDeviceId((BDdfIdParams)this.getDeviceId().newCopy());
        bIDdfZoomReq.setVideoComponent((BIVideoPanTiltControl)this);
        bIDdfZoomReq.setZoomAction(bVideoZoomEnum);
        return bIDdfZoomReq;
    }

    public void onMove(BVideoPanTiltEnum bVideoPanTiltEnum) {
        Type type = this.getPanTiltReqType();
        if (type == null) {
            throw new BajaRuntimeException(DdfVideoLexicon.PanTilt.panTiltReqTypeCantBeNull);
        }
        if (!type.is(BIDdfPanTiltReq.TYPE)) {
            throw new BajaRuntimeException(DdfVideoLexicon.PanTilt.panTiltReqTypeMustImplementBIDdfPanTiltReq);
        }
        BIDdfPanTiltReq bIDdfPanTiltReq = this.makePanTiltReq(bVideoPanTiltEnum, type);
        this.getDdfCommunicator().communicate((BIDdfRequest)bIDdfPanTiltReq);
    }

    protected BIDdfPanTiltReq makePanTiltReq(BVideoPanTiltEnum bVideoPanTiltEnum, Type type) {
        BIDdfPanTiltReq bIDdfPanTiltReq = (BIDdfPanTiltReq)type.getInstance();
        bIDdfPanTiltReq.setDeviceId((BDdfIdParams)this.getDeviceId().newCopy());
        bIDdfPanTiltReq.setVideoComponent((BIVideoPanTiltControl)this);
        bIDdfPanTiltReq.setPanTiltAction(bVideoPanTiltEnum);
        return bIDdfPanTiltReq;
    }

    protected static void loadSlots(BComponent bComponent) {
        SlotCursor slotCursor = bComponent.loadSlots().getProperties();
        while (slotCursor.nextComponent()) {
            BComponent bComponent2 = (BComponent)slotCursor.get();
            BDdfVideoCamera.loadSlots(bComponent2);
        }
    }

    public VideoPlaybackSession newPlaybackSession(IVideoPlayback iVideoPlayback) {
        return new VideoPlaybackSession(iVideoPlayback);
    }

    public void streamToDestination(BPlaybackParams bPlaybackParams, IVideoDestination iVideoDestination) {
        if (this.videoStreamUtil == null) {
            this.videoStreamUtil = new DdfVideoStreamUtil((BComponent)this);
        }
        this.videoStreamUtil.streamToDestination(bPlaybackParams, iVideoDestination);
    }

    public BIDdfVideoStreamRequest makeVideoStreamRequest(BPlaybackParams bPlaybackParams, IVideoDestination iVideoDestination) {
        Type type = this.getVideoStreamRequestType();
        return BDdfVideoStreamRequest.makeVideoStreamRequest(type, this, bPlaybackParams, iVideoDestination);
    }

    protected abstract Type getVideoStreamRequestType();

    public boolean isMoveToPresetEnabled() {
        BDdfVideoCameraInfo bDdfVideoCameraInfo = this.getCameraInfo();
        boolean bl = false;
        if (bDdfVideoCameraInfo != null && bDdfVideoCameraInfo.getSupportsMoveToPreset()) {
            bl = true;
        }
        return bl;
    }

    public boolean isPanTiltEnabled() {
        BDdfVideoCameraInfo bDdfVideoCameraInfo = this.getCameraInfo();
        boolean bl = false;
        if (bDdfVideoCameraInfo != null && bDdfVideoCameraInfo.getSupportsPanTilt()) {
            bl = true;
        }
        return bl;
    }

    public boolean isStorePresetEnabled() {
        BDdfVideoCameraInfo bDdfVideoCameraInfo = this.getCameraInfo();
        boolean bl = false;
        if (bDdfVideoCameraInfo != null && bDdfVideoCameraInfo.getSupportsStorePreset()) {
            bl = true;
        }
        return bl;
    }

    public boolean isZoomEnabled() {
        BDdfVideoCameraInfo bDdfVideoCameraInfo = this.getCameraInfo();
        boolean bl = false;
        if (bDdfVideoCameraInfo != null && bDdfVideoCameraInfo.getSupportsZoom()) {
            bl = true;
        }
        return bl;
    }

    public boolean isFocusEnabled() {
        BDdfVideoCameraInfo bDdfVideoCameraInfo = this.getCameraInfo();
        boolean bl = false;
        if (bDdfVideoCameraInfo != null && bDdfVideoCameraInfo.getSupportsFocus()) {
            bl = true;
        }
        return bl;
    }

    public boolean isIrisEnabled() {
        BDdfVideoCameraInfo bDdfVideoCameraInfo = this.getCameraInfo();
        boolean bl = false;
        if (bDdfVideoCameraInfo != null && bDdfVideoCameraInfo.getSupportsIris()) {
            bl = true;
        }
        return bl;
    }

    public boolean supportsPlaybackControl() {
        return true;
    }

    public boolean isTimestampPreferred() {
        return this.getVideoPreferences().getTimestampPreferred();
    }

    public BRelTime getInterframeTimeout() {
        if (this.isDown()) {
            return ONE_SECOND;
        }
        return this.getVideoPreferences().getInterframeTimeout();
    }

    protected boolean recurseFoxVideoStreamPreferredToNet() {
        BIVideoNetwork bIVideoNetwork = this.getVideoNetwork();
        if (bIVideoNetwork != null && bIVideoNetwork instanceof BDdfVideoNetwork) {
            if (bIVideoNetwork instanceof BComponent) {
                ((BComponent)bIVideoNetwork).lease();
                try {
                    ((BComponent)bIVideoNetwork).getComponentSpace().sync();
                }
                catch (Exception exception) {
                    this.getDdfCommunicator().getLog().error("Unable to retrieve updated property values on the network. This was needed to resolve the fox video stream preference of 'inherit'. Defaulting to false.", (Throwable)exception);
                    return false;
                }
            }
            return ((BDdfVideoNetwork)bIVideoNetwork).getFoxVideoStreamPreferred();
        }
        this.getDdfCommunicator().getLog().message("Network does not inherit from BDdfVideoNetwork. Unable to recurse beyond the 'inherit' setting on the DVR. Defaulting to 'No' for 'foxStreamPreferred'.");
        return false;
    }

    protected boolean recurseFoxVideoStreamPreferredToDvr() {
        BIVideoDvr bIVideoDvr = this.getDvr();
        if (bIVideoDvr != null && bIVideoDvr instanceof BDdfVideoDvr) {
            BDdfVideoDvr bDdfVideoDvr = (BDdfVideoDvr)bIVideoDvr;
            BFoxVideoStreamEnum bFoxVideoStreamEnum = bDdfVideoDvr.getFoxVideoStreamPreferred();
            if (bIVideoDvr instanceof BComponent) {
                ((BComponent)bIVideoDvr).lease();
                try {
                    ((BComponent)bIVideoDvr).getComponentSpace().sync();
                }
                catch (Exception exception) {
                    this.getDdfCommunicator().getLog().error("Unable to retrieve updated property values on the network. This was needed to resolve the fox video stream preference of 'inherit'. Defaulting to false.", (Throwable)exception);
                    return false;
                }
            }
            if (bFoxVideoStreamEnum == BFoxVideoStreamEnum.inherit) {
                return this.recurseFoxVideoStreamPreferredToNet();
            }
            if (bFoxVideoStreamEnum == BFoxVideoStreamEnum.no) {
                return false;
            }
            if (bFoxVideoStreamEnum == BFoxVideoStreamEnum.yes) {
                return true;
            }
            throw new IllegalStateException("Unrecognized foxStreamEnum: " + bFoxVideoStreamEnum + ". Please have my program fixed.");
        }
        return this.recurseFoxVideoStreamPreferredToNet();
    }

    public boolean isFoxVideoStreamPreferred() {
        BFoxVideoStreamEnum bFoxVideoStreamEnum = this.getFoxVideoStreamSetting();
        if (bFoxVideoStreamEnum == BFoxVideoStreamEnum.inherit) {
            return this.recurseFoxVideoStreamPreferredToDvr();
        }
        if (bFoxVideoStreamEnum == BFoxVideoStreamEnum.no) {
            return false;
        }
        if (bFoxVideoStreamEnum == BFoxVideoStreamEnum.yes) {
            return true;
        }
        throw new IllegalStateException("Unrecognized foxStreamEnum: " + bFoxVideoStreamEnum + ". Please have my program fixed.");
    }

    public BFoxVideoStreamEnum getFoxVideoStreamSetting() {
        return this.getVideoPreferences().getPreferredVideoStreamFox();
    }

    public BVideoAspectRatioEnum getPreferredAspectRatio() {
        return this.getVideoPreferences().getPreferredAspectRatio();
    }

    public BColor getPreferredBackgroundColor() {
        return this.getVideoPreferences().getPreferredBackgroundColor();
    }

    public BVideoFrameRateEnum getPreferredFrameRate() {
        return this.getVideoPreferences().getPreferredFrameRate();
    }

    public BVideoResolutionEnum getPreferredResolution() {
        return this.getVideoPreferences().getPreferredResolution();
    }

    public BVideoCompressionEnum getPreferredCompression() {
        return this.getVideoPreferences().getPreferredCompression();
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.videoStreamThreadNumber = 1;
        this.focusControlHelper = new BDdfFocusControlHelper(this);
        this.irisControlHelper = new BDdfIrisControlHelper(this);
        this.zoomControlHelper = new BDdfZoomControlHelper(this);
        this.movementControlHelper = new BDdfMovementControlHelper(this);
    }

    public BDdfVideoCamera() {
        this.this();
    }

    static {
        HashMap<String, BFormat> hashMap = new HashMap<String, BFormat>();
        hashMap.put("pingParameters", BFormat.make((String)"%lexicon(devVideoDriver:ptzParameters)%"));
        RENAME_PING_PARAMS = BNameMap.make(hashMap);
        pingParameters = BDdfVideoCamera.newProperty((int)0, (BValue)new BDdfVideoCameraInfo(), (BFacets)DdfFacets.combine((BFacets)IDdfFacetConst.MGR_INCLUDE, (BFacets)IDdfFacetConst.MGR_OPTIONAL_IN_TABLE));
        controlTiming = BDdfVideoCamera.newProperty((int)0, (BValue)new BDdfCameraControlTimings(), null);
        videoPreferences = BDdfVideoCamera.newProperty((int)0, (BValue)BDdfVideoSourcePreferences.makeInheritFoxStreamPerferred(), (BFacets)IDdfFacetConst.MGR_INCLUDE);
        move = BDdfVideoCamera.newAction((int)20, (BValue)BVideoPanTiltEnum.none, null);
        zoom = BDdfVideoCamera.newAction((int)20, (BValue)BVideoZoomEnum.none, null);
        moveToPreset = BDdfVideoCamera.newAction((int)20, (BValue)BString.make((String)"-"), null);
        storePreset = BDdfVideoCamera.newAction((int)20, (BValue)BString.make((String)"-"), null);
        makeActive = BDdfVideoCamera.newAction((int)20, (BValue)new BDdfVideoDisplayChooser(), null);
        irisControl = BDdfVideoCamera.newAction((int)20, (BValue)BVideoIrisEnum.none, null);
        focusControl = BDdfVideoCamera.newAction((int)20, (BValue)BVideoFocusEnum.none, null);
        Class clazz = class$com$tridium$ddfVideo$camera$BDdfVideoCamera;
        if (clazz == null) {
            clazz = class$com$tridium$ddfVideo$camera$BDdfVideoCamera = BDdfVideoCamera.class("[Lcom.tridium.ddfVideo.camera.BDdfVideoCamera;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://videoDriver/icons/camera.png");
        ONE_SECOND = BRelTime.makeSeconds((int)1);
    }
}

