/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.query.util;

import javax.baja.query.BExpression;
import javax.baja.query.util.Exprs;

public class ExpressionBuilder {
    protected BExpression expr;

    public final BExpression getExpression() {
        return this.expr;
    }

    protected ExpressionBuilder doCombine(String string, BExpression bExpression) {
        if (this.expr == null && bExpression != null) {
            this.expr = bExpression.newExprCopy();
        } else if (bExpression != null) {
            this.expr = Exprs.binary(this.expr.newExprCopy(), string, bExpression);
        }
        return this;
    }

    public ExpressionBuilder and(BExpression bExpression) {
        return this.doCombine("AND", bExpression);
    }

    public ExpressionBuilder or(BExpression bExpression) {
        return this.doCombine("OR", bExpression);
    }

    public ExpressionBuilder not() {
        this.expr = Exprs.unary("NOT", this.expr);
        return this;
    }

    public ExpressionBuilder plus(BExpression bExpression) {
        return this.doCombine("+", bExpression);
    }

    public ExpressionBuilder minus(BExpression bExpression) {
        return this.doCombine("-", bExpression);
    }

    public ExpressionBuilder times(BExpression bExpression) {
        return this.doCombine("*", bExpression);
    }

    public ExpressionBuilder div(BExpression bExpression) {
        return this.doCombine("/", bExpression);
    }

    public ExpressionBuilder negative() {
        this.expr = Exprs.unary("-", this.expr);
        return this;
    }

    public ExpressionBuilder() {
        this(null);
    }

    public ExpressionBuilder(BExpression bExpression) {
        this.expr = bExpression;
    }
}

