/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.query;

import com.tridium.query.QueryIdioms;
import javax.baja.query.BExpression;
import javax.baja.query.BGroupByColumn;
import javax.baja.query.BGrouping;
import javax.baja.query.BHaving;
import javax.baja.query.BOrderByColumn;
import javax.baja.query.BOrdering;
import javax.baja.query.BPredicate;
import javax.baja.query.BProjection;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.QueryRuntimeException;
import javax.baja.query.expression.BBinaryExpression;
import javax.baja.query.expression.BFieldExpression;
import javax.baja.query.expression.BFunctionExpression;
import javax.baja.query.expression.BListExpression;
import javax.baja.query.expression.BSimpleExpression;
import javax.baja.query.expression.BUnaryExpression;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class QueryStringVisitor {
    private QueryIdioms idioms_;
    protected StringBuffer queryText;
    protected boolean hasFuncProjection;
    protected boolean inPredicate;

    protected void initialize() {
        this.queryText = new StringBuffer();
        this.hasFuncProjection = false;
        this.inPredicate = false;
    }

    public QueryIdioms idioms() {
        return this.idioms_;
    }

    public String getQueryString() {
        return this.queryText.toString();
    }

    public void visit(BExpression bExpression) {
        if (bExpression instanceof BFieldExpression) {
            this.visit((BFieldExpression)bExpression);
        } else if (bExpression instanceof BSimpleExpression) {
            this.visit((BSimpleExpression)bExpression);
        } else if (bExpression instanceof BFunctionExpression) {
            this.visit((BFunctionExpression)bExpression);
        } else if (bExpression instanceof BBinaryExpression) {
            this.visit((BBinaryExpression)bExpression);
        } else if (bExpression instanceof BUnaryExpression) {
            this.visit((BUnaryExpression)bExpression);
        } else if (bExpression instanceof BListExpression) {
            this.visit((BListExpression)bExpression);
        } else {
            throw new QueryRuntimeException("Unknown expression type: " + bExpression.getType());
        }
    }

    public void visit(BFieldExpression bFieldExpression) {
        this.queryText.append(bFieldExpression.getField());
    }

    public void visit(BSimpleExpression bSimpleExpression) {
        this.queryText.append(bSimpleExpression.getSimpleValue().toString());
    }

    public void visit(BListExpression bListExpression) {
        this.queryText.append('[');
        BExpression[] bExpressionArray = bListExpression.getExpressions();
        int n = 0;
        while (n < bExpressionArray.length) {
            if (n > 0) {
                this.queryText.append(", ");
            }
            this.visit(bExpressionArray[n]);
            ++n;
        }
        this.queryText.append(']');
    }

    public void visit(BProjection bProjection) {
        if (bProjection.isDistinct()) {
            this.queryText.append("DISTINCT ");
        }
        BProjectionColumn[] bProjectionColumnArray = bProjection.getProjectionColumns();
        int n = 0;
        while (n < bProjectionColumnArray.length) {
            if (n > 0) {
                this.queryText.append(", ");
            }
            this.visit(bProjectionColumnArray[n]);
            ++n;
        }
        this.queryText.append(' ');
    }

    public void visit(BProjectionColumn bProjectionColumn) {
        this.visit(bProjectionColumn.getColumnExpression());
        if (bProjectionColumn.hasAlias()) {
            this.queryText.append(' ').append(this.idioms().toAliasString(bProjectionColumn.getAlias()));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void visit(BPredicate bPredicate) {
        this.inPredicate = true;
        try {
            this.visit(bPredicate.getPredicateExpr());
            this.queryText.append(' ');
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.inPredicate = false;
            throw throwable;
        }
        {
            Object var3_4 = null;
            this.inPredicate = false;
            return;
        }
    }

    public void visit(BOrdering bOrdering) {
        BOrderByColumn[] bOrderByColumnArray = bOrdering.getOrderByColumns();
        int n = 0;
        while (n < bOrderByColumnArray.length) {
            if (n > 0) {
                this.queryText.append(", ");
            }
            this.visit(bOrderByColumnArray[n]);
            ++n;
        }
        this.queryText.append(' ');
    }

    public void visit(BOrderByColumn bOrderByColumn) {
        this.visit(bOrderByColumn.getColumnExpression());
        this.queryText.append(' ');
        if (bOrderByColumn.isAscending()) {
            this.queryText.append("ASC");
        } else {
            this.queryText.append("DESC");
        }
    }

    public void visit(BGrouping bGrouping) {
        BGroupByColumn[] bGroupByColumnArray = bGrouping.getGroupByColumns();
        int n = 0;
        while (n < bGroupByColumnArray.length) {
            if (n > 0) {
                this.queryText.append(", ");
            }
            this.visit(bGroupByColumnArray[n]);
            ++n;
        }
        this.queryText.append(' ');
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void visit(BHaving bHaving) {
        this.inPredicate = true;
        try {
            this.visit(bHaving.getHavingExpr());
            this.queryText.append(' ');
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.inPredicate = false;
            throw throwable;
        }
        {
            Object var3_4 = null;
            this.inPredicate = false;
            return;
        }
    }

    public void visit(BGroupByColumn bGroupByColumn) {
        this.visit(bGroupByColumn.getColumnExpression());
    }

    public void visit(BFunctionExpression bFunctionExpression) {
        this.queryText.append(bFunctionExpression.getFunctionName()).append('(');
        if (bFunctionExpression.isDistinct()) {
            this.queryText.append("DISTINCT ");
        }
        BExpression[] bExpressionArray = bFunctionExpression.getParameters();
        int n = 0;
        while (n < bExpressionArray.length) {
            if (n > 0) {
                this.queryText.append(", ");
            }
            this.visit(bExpressionArray[n]);
            ++n;
        }
        this.queryText.append(")");
        this.hasFuncProjection = true;
    }

    public void visit(BBinaryExpression bBinaryExpression) {
        this.queryText.append('(');
        this.visit(bBinaryExpression.lhs());
        this.queryText.append(' ').append(bBinaryExpression.op()).append(' ');
        this.visit(bBinaryExpression.rhs());
        this.queryText.append(')');
    }

    public void visit(BUnaryExpression bUnaryExpression) {
        this.queryText.append('(');
        if (!bUnaryExpression.isPostfix()) {
            this.queryText.append(bUnaryExpression.op()).append(' ');
            this.visit(bUnaryExpression.operand());
        } else {
            this.visit(bUnaryExpression.operand());
            this.queryText.append(' ').append(bUnaryExpression.op());
        }
        this.queryText.append(')');
    }

    private final /* synthetic */ void this() {
        this.idioms_ = new DefaultIdioms();
        this.hasFuncProjection = false;
        this.inPredicate = false;
    }

    public QueryStringVisitor() {
        this.this();
        this.initialize();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class DefaultIdioms
    implements QueryIdioms {
        public String quote(String string) {
            return "'" + string + '\'';
        }

        public String toAliasString(String string) {
            return "AS " + this.quote(string);
        }
    }
}

