/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.js.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import org.json.JSONObject;
import org.json.JSONTokener;

public final class JavaScriptMinifier {
    private static IMinificationEngine defaultEngine;
    private static final DecimalFormat DOUBLE_FORMAT;
    static /* synthetic */ Class class$com$tridium$js$util$JavaScriptMinifier$GoogleClosure;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$InputStream;

    public static void minify(File file) throws Exception {
        JavaScriptMinifier.minify(file, JavaScriptMinifier.getDefaultEngine());
    }

    public static void minify(File file, IMinificationEngine iMinificationEngine) throws Exception {
        if (!file.exists()) {
            throw new IOException("Input file does not exist: " + file);
        }
        if (!file.isDirectory()) {
            if (file.getName().endsWith(".js") && !file.getName().endsWith(".min.js")) {
                File file2 = new File(file.getParentFile(), "min");
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                File file3 = new File(file2, file.getName().replaceAll(".js", ".min.js"));
                JavaScriptMinifier.minify(file, file3, iMinificationEngine);
            }
        } else {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    JavaScriptMinifier.minify(fileArray[i], iMinificationEngine);
                }
            }
        }
    }

    public static void minify(File file, File file2) throws Exception {
        JavaScriptMinifier.minify(new File[]{file}, file2, JavaScriptMinifier.getDefaultEngine());
    }

    public static void minify(File file, File file2, IMinificationEngine iMinificationEngine) throws Exception {
        JavaScriptMinifier.minify(new File[]{file}, file2, iMinificationEngine);
    }

    public static void minify(File[] fileArray, File file) throws Exception {
        JavaScriptMinifier.minify(fileArray, file, JavaScriptMinifier.getDefaultEngine());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void minify(File[] fileArray, File file, IMinificationEngine iMinificationEngine) throws Exception {
        if (fileArray.length == 0) {
            throw new IllegalArgumentException("Must specify JavaScript input files!");
        }
        System.out.println();
        for (int i = 0; i < fileArray.length; ++i) {
            System.out.println("Minifying: " + fileArray[i]);
            if (fileArray[i].exists()) continue;
            throw new IOException("Input file does not exist: " + fileArray[i]);
        }
        System.out.println("Output File: " + file);
        TraceInputStream traceInputStream = null;
        TraceOutputStream traceOutputStream = null;
        try {
            File file2;
            traceInputStream = new TraceInputStream(JavaScriptMinifier.createInputStream(fileArray));
            if (file.exists()) {
                file.delete();
            }
            if ((file2 = file.getParentFile()) != null) {
                file2.mkdirs();
            }
            file.createNewFile();
            traceOutputStream = new TraceOutputStream(new FileOutputStream(file));
            iMinificationEngine.minify(traceInputStream, traceOutputStream);
            traceOutputStream.flush();
            double d = traceInputStream.getByteCount() / 1024.0;
            double d2 = traceOutputStream.getByteCount() / 1024.0;
            double d3 = 100.0 - traceOutputStream.getByteCount() / traceInputStream.getByteCount() * 100.0;
            System.out.println("\nSize of input:  " + JavaScriptMinifier.formatDouble(d) + " kb");
            System.out.println("Size of output: " + JavaScriptMinifier.formatDouble(d2) + " kb");
            System.out.println("Compression: " + JavaScriptMinifier.formatDouble(d3) + " %\n");
            System.out.println("*** Minification Successfully Completed ***");
        }
        finally {
            try {
                if (traceInputStream != null) {
                    traceInputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (traceOutputStream != null) {
                    traceOutputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static String formatDouble(double d) {
        return DOUBLE_FORMAT.format(d);
    }

    private static InputStream createInputStream(File[] fileArray) throws Exception {
        InputStream inputStream = new FileInputStream(fileArray[0]);
        if (fileArray.length > 1) {
            for (int i = 1; i < fileArray.length; ++i) {
                inputStream = new SequenceInputStream(inputStream, new FileInputStream(fileArray[i]));
            }
        }
        return inputStream;
    }

    private static String post(URL uRL, String string) throws Exception {
        int n = string.getBytes().length;
        System.out.println("Sending number of bytes: " + n);
        System.out.println("Please wait while Web Service is invoked...");
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setInstanceFollowRedirects(false);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setAllowUserInteraction(true);
        httpURLConnection.addRequestProperty("content-type", "application/x-www-form-urlencoded");
        httpURLConnection.addRequestProperty("content-length", String.valueOf(n));
        httpURLConnection.setRequestMethod("POST");
        OutputStream outputStream = httpURLConnection.getOutputStream();
        outputStream.write(string.getBytes(), 0, n);
        outputStream.flush();
        try {
            outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringWriter stringWriter = new StringWriter();
        InputStream inputStream = httpURLConnection.getInputStream();
        try {
            int n2 = inputStream.read();
            while (n2 > -1) {
                stringWriter.write(n2);
                n2 = inputStream.read();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("responseCode=" + httpURLConnection.getResponseCode());
            if (httpURLConnection.getResponseCode() / 100 != 2) {
                throw new IOException(httpURLConnection.getResponseMessage());
            }
            throw exception;
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringWriter.toString().trim();
    }

    public static synchronized IMinificationEngine getDefaultEngine() {
        if (defaultEngine == null) {
            defaultEngine = new GoogleClosure();
        }
        return defaultEngine;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            throw new IOException("Please specify a JS file or directory to start minification");
        }
        JavaScriptMinifier.minify(new File(stringArray[0]));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        DOUBLE_FORMAT = new DecimalFormat("0.00");
    }

    private static final class TraceOutputStream
    extends OutputStream {
        private double count = 0.0;
        private OutputStream out;

        private TraceOutputStream(OutputStream outputStream) {
            this.out = outputStream;
        }

        public void write(int n) throws IOException {
            this.out.write(n);
            this.count += 1.0;
        }

        public double getByteCount() {
            return this.count;
        }

        public void close() throws IOException {
            super.close();
            this.out.close();
        }
    }

    private static final class TraceInputStream
    extends InputStream {
        private double count = 0.0;
        private InputStream in;

        private TraceInputStream(InputStream inputStream) {
            this.in = inputStream;
        }

        public int read() throws IOException {
            int n = this.in.read();
            if (n > -1) {
                this.count += 1.0;
            }
            return n;
        }

        public double getByteCount() {
            return this.count;
        }

        public void close() throws IOException {
            super.close();
            this.in.close();
        }
    }

    public static final class GoogleClosureWebService
    implements IMinificationEngine {
        public void minify(InputStream inputStream, OutputStream outputStream) throws Exception {
            System.out.println("*** Making Google Closure Web Service Call ***");
            StringBuffer stringBuffer = new StringBuffer();
            int n = inputStream.read();
            while (n > -1) {
                stringBuffer.append((char)n);
                n = inputStream.read();
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("js_code=");
            stringBuffer2.append(URLEncoder.encode(stringBuffer.toString(), "UTF-8"));
            String string = "SIMPLE_OPTIMIZATIONS";
            stringBuffer2.append("&compilation_level=").append(string);
            stringBuffer2.append("&output_format=json");
            stringBuffer2.append("&output_info=compiled_code");
            stringBuffer2.append("&output_info=warnings");
            stringBuffer2.append("&output_info=errors");
            stringBuffer2.append("&output_info=statistics");
            String string2 = JavaScriptMinifier.post(new URL("http://closure-compiler.appspot.com/compile"), stringBuffer2.toString());
            System.out.println("Received number of bytes: " + string2.length());
            JSONObject jSONObject = new JSONObject(new JSONTokener(string2));
            if (jSONObject.has("errors")) {
                System.out.println("Detected Errors...");
                System.out.println(jSONObject.getJSONArray("errors").toString(2));
            }
            if (jSONObject.has("warnings")) {
                System.out.println("Detected Warnings...");
                System.out.println(jSONObject.getJSONArray("warnings").toString(2));
            }
            if (jSONObject.has("serverErrors")) {
                System.out.println("Detected Server Errors...");
                System.out.println(jSONObject.getJSONArray("serverErrors").toString(2));
            }
            if (jSONObject.has("statistics")) {
                System.out.println("Compilation Statistics");
                System.out.println(jSONObject.getJSONObject("statistics").toString(2));
            }
            outputStream.write(jSONObject.getString("compiledCode").getBytes("UTF-8"));
        }
    }

    public static final class GoogleClosure
    implements IMinificationEngine {
        private File bajaHome;
        private static URLClassLoader cachedGoogleClosureClassLoader;

        public GoogleClosure() {
            String string = System.getProperty("baja.home");
            if (string == null) {
                throw new RuntimeException("Missing system property \"baja.home\".  Has initEnv() been called?");
            }
            this.bajaHome = new File(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void minify(InputStream inputStream, OutputStream outputStream) throws Exception {
            Method method;
            URL uRL;
            System.out.println("*** Starting Google Closure Minification ***");
            String string = "SIMPLE_OPTIMIZATIONS";
            Class clazz = class$com$tridium$js$util$JavaScriptMinifier$GoogleClosure == null ? (class$com$tridium$js$util$JavaScriptMinifier$GoogleClosure = JavaScriptMinifier.class$("com.tridium.js.util.JavaScriptMinifier$GoogleClosure")) : class$com$tridium$js$util$JavaScriptMinifier$GoogleClosure;
            synchronized (clazz) {
                if (cachedGoogleClosureClassLoader == null) {
                    uRL = new File(this.bajaHome, "lib/gcCompiler.jar").toURI().toURL();
                    cachedGoogleClosureClassLoader = new URLClassLoader(new URL[]{uRL});
                }
            }
            clazz = cachedGoogleClosureClassLoader.loadClass("com.google.javascript.jscomp.Compiler");
            uRL = clazz.newInstance();
            Class<?> clazz2 = cachedGoogleClosureClassLoader.loadClass("com.google.javascript.jscomp.CompilerOptions");
            Object obj = clazz2.newInstance();
            Class<?> clazz3 = cachedGoogleClosureClassLoader.loadClass("com.google.javascript.jscomp.CompilationLevel");
            Object object = clazz3.getDeclaredField(string).get(clazz3);
            Method method2 = clazz3.getMethod("setOptionsForCompilationLevel", clazz2);
            method2.invoke(object, obj);
            Class<?> clazz4 = cachedGoogleClosureClassLoader.loadClass("com.google.javascript.jscomp.JSSourceFile");
            Method method3 = clazz4.getMethod("fromInputStream", class$java$lang$String == null ? (class$java$lang$String = JavaScriptMinifier.class$("java.lang.String")) : class$java$lang$String, class$java$io$InputStream == null ? (class$java$io$InputStream = JavaScriptMinifier.class$("java.io.InputStream")) : class$java$io$InputStream);
            Object object2 = method3.invoke(null, "newMinifiedCode.js", inputStream);
            Method method4 = clazz4.getMethod("fromCode", class$java$lang$String == null ? (class$java$lang$String = JavaScriptMinifier.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = JavaScriptMinifier.class$("java.lang.String")) : class$java$lang$String);
            Object object3 = method4.invoke(null, "externs.js", "function alert(x) {}");
            try {
                method = clazz.getMethod("compile", clazz4, clazz4, clazz2);
                method.invoke((Object)uRL, object3, object2, obj);
                Method method5 = clazz.getMethod("toSource", new Class[0]);
                String string2 = (String)method5.invoke((Object)uRL, new Object[0]);
                byte[] byArray = string2.getBytes("UTF-8");
                for (int i = 0; i < byArray.length; ++i) {
                    outputStream.write(byArray[i]);
                }
            }
            finally {
                method = clazz4.getMethod("clearCachedSource", new Class[0]);
                method.invoke(object2, new Object[0]);
                method.invoke(object3, new Object[0]);
            }
        }
    }

    public static interface IMinificationEngine {
        public void minify(InputStream var1, OutputStream var2) throws Exception;
    }
}

