/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.point;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.BPupDevice;
import com.tridium.aapup.BPupNetwork;
import com.tridium.aapup.PupException;
import com.tridium.aapup.enums.BPupPrewriteAttributeEnum;
import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupNumericDataResponse;
import com.tridium.aapup.messages.PupReadAttributeMessage;
import com.tridium.aapup.messages.PupResponse;
import com.tridium.aapup.messages.PupTextDataResponse;
import com.tridium.aapup.messages.PupWriteAttributeMessage;
import com.tridium.aapup.point.BCvOverrideAction;
import com.tridium.aapup.point.BCvResetOverrideAction;
import com.tridium.aapup.point.BPupPointDeviceExt;
import com.tridium.aapup.point.BSetDateAction;
import com.tridium.aapup.point.BSetTimeAction;
import com.tridium.aapup.point.CvOverrideRequest;
import com.tridium.aapup.point.SetDateRequest;
import com.tridium.aapup.point.SetTimeRequest;
import com.tridium.basicdriver.point.BBasicProxyExt;
import com.tridium.basicdriver.util.BIBasicPollable;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BPupProxyExt
extends BBasicProxyExt
implements BIBasicPollable,
AaPupConst {
    public static final Property channel = BPupProxyExt.newProperty((int)0, (int)-1, (BFacets)BFacets.makeInt(null, (int)0, (int)((char)-1), (int)16));
    public static final Property channelDescription = BPupProxyExt.newProperty((int)0, (String)"", null);
    public static final Property attribute = BPupProxyExt.newProperty((int)0, (String)"??", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)2)));
    public static final Property attributeType = BPupProxyExt.newProperty((int)1, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Property attributeValue = BPupProxyExt.newProperty((int)3, (String)"", null);
    public static final Property pollFrequency = BPupProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property prewriteAttribute = BPupProxyExt.newProperty((int)4, (BValue)BPupPrewriteAttributeEnum.none, null);
    public static final Action forceRead = BPupProxyExt.newAction((int)0, null);
    public static final Action forceWrite = BPupProxyExt.newAction((int)0, null);
    public static final Type TYPE;
    private boolean overriddenState;
    static /* synthetic */ Class class$com$tridium$aapup$point$BPupProxyExt;
    static /* synthetic */ Class class$com$tridium$aapup$point$BSetTimeAction;
    static /* synthetic */ Class class$com$tridium$aapup$point$BSetDateAction;
    static /* synthetic */ Class class$com$tridium$aapup$point$BCvOverrideAction;
    static /* synthetic */ Class class$com$tridium$aapup$point$BCvResetOverrideAction;

    public int getChannel() {
        return this.getInt(channel);
    }

    public void setChannel(int n) {
        this.setInt(channel, n, null);
    }

    public String getChannelDescription() {
        return this.getString(channelDescription);
    }

    public void setChannelDescription(String string) {
        this.setString(channelDescription, string, null);
    }

    public String getAttribute() {
        return this.getString(attribute);
    }

    public void setAttribute(String string) {
        this.setString(attribute, string, null);
    }

    public int getAttributeType() {
        return this.getInt(attributeType);
    }

    public void setAttributeType(int n) {
        this.setInt(attributeType, n, null);
    }

    public String getAttributeValue() {
        return this.getString(attributeValue);
    }

    public void setAttributeValue(String string) {
        this.setString(attributeValue, string, null);
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public BPupPrewriteAttributeEnum getPrewriteAttribute() {
        return (BPupPrewriteAttributeEnum)this.get(prewriteAttribute);
    }

    public void setPrewriteAttribute(BPupPrewriteAttributeEnum bPupPrewriteAttributeEnum) {
        this.set(prewriteAttribute, (BValue)bPupPrewriteAttributeEnum, null);
    }

    public void forceRead() {
        this.invoke(forceRead, null, null);
    }

    public void forceWrite() {
        this.invoke(forceWrite, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.checkCvOverrideAction();
        this.checkTimeAction();
        this.checkDateAction();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)prewriteAttribute)) {
            this.checkCvOverrideAction();
        }
        if (property.equals((Object)channel) || property.equals((Object)attribute)) {
            this.setStale(true, null);
            if (this.getParentPoint().isWritablePoint()) {
                this.getTuning().writeDesired();
            }
            this.checkTimeAction();
            this.checkDateAction();
            this.checkCvOverrideAction();
            this.forceRead();
        }
    }

    public void doForceRead() {
        this.pupNetwork().postAsync(new Runnable(){

            public final void run() {
                BPupProxyExt.this.poll();
            }
        });
    }

    public void doForceWrite() {
        try {
            this.write(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Type getDeviceExtType() {
        return BPupPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    public void doWrite(BStatusValue bStatusValue) {
        if (bStatusValue == null) {
            this.updateOutput(this.getWriteValue());
        } else {
            this.updateOutput(bStatusValue);
        }
        if (this.getParentPoint().isSubscribed()) {
            this.poll();
        }
    }

    abstract boolean updateOutput(BStatusValue var1);

    boolean prewriteAttribute() {
        if (!this.getPrewriteAttribute().prewriteRequired()) {
            return true;
        }
        String string = this.getPrewriteAttribute().getAttribute();
        double d = this.getPrewriteAttribute().getMakeWritableValue();
        PupWriteAttributeMessage pupWriteAttributeMessage = new PupWriteAttributeMessage(this.pupDevice().getUnitNumber(), this.getChannel(), string, 254, d);
        PupResponse pupResponse = (PupResponse)this.pupNetwork().sendSync(pupWriteAttributeMessage);
        if (pupResponse == null) {
            return false;
        }
        if (!pupResponse.getIn().verifyChecksum()) {
            return false;
        }
        if (pupResponse.getIn().getUnitNumber() != this.pupDevice().getUnitNumber()) {
            return false;
        }
        if (pupResponse instanceof PupAckResponse) {
            this.getPupLog().trace("preWrite Succeeded on " + this);
            return true;
        }
        return false;
    }

    public void poll() {
        this.getPupLog().trace("poll " + this.getParent().getName() + ':' + this);
        if (!this.isValid()) {
            return;
        }
        if (this.getAttribute().equalsIgnoreCase("CV") & this.getPrewriteAttribute().prewriteRequired()) {
            try {
                this.overriddenState = this.discoverOverriddenState();
            }
            catch (PupException pupException) {
                this.getPupLog().trace("error discovering override state on " + this + ':' + pupException.getMessage());
                this.readFail("could not determine override state");
            }
        } else {
            this.overriddenState = false;
        }
        PupReadAttributeMessage pupReadAttributeMessage = new PupReadAttributeMessage(this.pupDevice().getUnitNumber(), this.getChannel(), this.getAttribute());
        PupResponse pupResponse = (PupResponse)this.pupDevice().pupNetwork().sendSync(pupReadAttributeMessage);
        if (!this.isValidReadResponse(pupResponse)) {
            return;
        }
        if (pupResponse instanceof PupNumericDataResponse) {
            PupNumericDataResponse pupNumericDataResponse = (PupNumericDataResponse)pupResponse;
            if (pupNumericDataResponse.getAttributeName().equalsIgnoreCase(this.getAttribute().trim())) {
                this.getPupLog().trace("Read Succeeded!");
                this.setValue(pupResponse);
                this.setAttributeType(pupNumericDataResponse.getDataType());
            } else {
                this.readFail("Polled for " + this.getAttribute() + " but received " + pupNumericDataResponse.getAttributeName());
            }
            return;
        }
        if (pupResponse instanceof PupTextDataResponse) {
            PupTextDataResponse pupTextDataResponse = (PupTextDataResponse)pupResponse;
            if (pupTextDataResponse.getAttributeName().equalsIgnoreCase(this.getAttribute().trim())) {
                this.getPupLog().trace("Read Succeeded!");
                this.setValue(pupResponse);
                this.setAttributeType(256);
            } else {
                this.readFail("Polled for " + this.getAttribute() + " but received " + pupTextDataResponse.getAttributeName());
            }
            return;
        }
        if (pupResponse instanceof PupErrorResponse) {
            PupErrorResponse pupErrorResponse = (PupErrorResponse)pupResponse;
            this.getPupLog().trace("Received error response polling " + this);
            this.readFail(pupErrorResponse.getError());
            return;
        }
        this.getPupLog().trace("Received invalid message type polling " + this);
        this.readFail("invalid message type");
    }

    boolean isValidReadResponse(PupResponse pupResponse) {
        if (pupResponse == null) {
            this.getPupLog().trace("Read Failed - no response polling " + this);
            this.readFail("No Response");
            this.pupDevice().ping();
            return false;
        }
        if (!pupResponse.getIn().verifyChecksum()) {
            this.getPupLog().trace("Checksum Error polling " + this);
            this.readFail("Bad Checksum");
            return false;
        }
        if (pupResponse.getIn().getUnitNumber() != this.pupDevice().getUnitNumber()) {
            this.getPupLog().trace("response address not same as requested address " + this);
            this.readFail("response address not same as requested address");
            return false;
        }
        return true;
    }

    boolean isValidWriteResponse(PupResponse pupResponse) {
        if (pupResponse == null) {
            this.writeFail("device time out");
            this.pupDevice().ping();
            return false;
        }
        if (!pupResponse.getIn().verifyChecksum()) {
            this.getPupLog().trace("Checksum Error writing " + this);
            this.writeFail("Bad Checksum");
            return false;
        }
        if (pupResponse.getIn().getUnitNumber() != this.pupDevice().getUnitNumber()) {
            this.getPupLog().trace("response address not same as requested address " + this);
            this.writeFail("response address not same as requested address");
            return false;
        }
        return true;
    }

    private final boolean discoverOverriddenState() throws PupException {
        PupReadAttributeMessage pupReadAttributeMessage = new PupReadAttributeMessage(this.pupDevice().getUnitNumber(), this.getChannel(), this.getPrewriteAttribute().getAttribute());
        PupResponse pupResponse = (PupResponse)this.pupDevice().pupNetwork().sendSync(pupReadAttributeMessage);
        if (pupResponse == null) {
            throw new PupException("device time out");
        }
        if (!pupResponse.getIn().verifyChecksum()) {
            throw new PupException("Bad Checksum reading override state");
        }
        if (pupResponse.getIn().getUnitNumber() != this.pupDevice().getUnitNumber()) {
            throw new PupException("response address not same as requested address");
        }
        if (pupResponse instanceof PupNumericDataResponse) {
            this.getPupLog().trace("Read Succeeded!");
            PupNumericDataResponse pupNumericDataResponse = (PupNumericDataResponse)pupResponse;
            return this.getPrewriteAttribute().isOverridden(pupNumericDataResponse.getBoolean().getBoolean());
        }
        if (pupResponse instanceof PupErrorResponse) {
            PupErrorResponse pupErrorResponse = (PupErrorResponse)pupResponse;
            throw new PupException("Error response reading override:" + pupErrorResponse.getError());
        }
        throw new PupException("invalid message type reading override");
    }

    public abstract void setValue(PupResponse var1);

    public BPupNetwork pupNetwork() {
        return (BPupNetwork)this.getNetwork();
    }

    public BPupDevice pupDevice() {
        return (BPupDevice)this.getDevice();
    }

    public final void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"PupProxyExt", 2);
        spyWriter.prop((Object)"isValid", this.isValid());
        this.pupspy(spyWriter);
        spyWriter.endProps();
    }

    public void pupspy(SpyWriter spyWriter) throws Exception {
    }

    boolean isValid() {
        boolean bl = false;
        if (this.getChannel() != -1 && this.getAttribute() != "??") {
            bl = true;
        }
        return bl;
    }

    Log getPupLog() {
        try {
            return this.pupNetwork().getPupLog();
        }
        catch (Exception exception) {
            return Log.getLog((String)"pup.x");
        }
    }

    private final void checkTimeAction() {
        BControlPoint bControlPoint = this.getParentPoint();
        Class clazz = class$com$tridium$aapup$point$BSetTimeAction;
        if (clazz == null) {
            clazz = class$com$tridium$aapup$point$BSetTimeAction = BPupProxyExt.class("[Lcom.tridium.aapup.point.BSetTimeAction;", false);
        }
        BSetTimeAction[] bSetTimeActionArray = (BSetTimeAction[])bControlPoint.getChildren(clazz);
        switch (this.getAttributeType()) {
            case 230: 
            case 231: {
                if (bSetTimeActionArray.length == 0) {
                    BSetTimeAction bSetTimeAction = new BSetTimeAction();
                    this.getParentPoint().add("AdjustTime", (BValue)bSetTimeAction, 2);
                }
                return;
            }
        }
        int n = 0;
        while (n < bSetTimeActionArray.length) {
            this.getParentPoint().remove((BComplex)bSetTimeActionArray[n]);
            ++n;
        }
    }

    public void setTimeAttribute(BValue bValue, Context context) {
        if (bValue instanceof BTime) {
            this.getPupLog().trace("Set Time Attribute on " + this + ":value=" + bValue);
            switch (this.getAttributeType()) {
                case 230: 
                case 231: {
                    this.pupNetwork().postWrite(new SetTimeRequest(this, (BTime)bValue));
                    return;
                }
            }
            return;
        }
    }

    public boolean setTimeAttribute(BTime bTime) {
        System.out.println("setTimeAttribute:" + bTime + ' ' + bTime.getHour() + ':' + bTime.getMinute() + ':' + bTime.getSecond());
        this.getPupLog().trace("setTimeAttribute:" + bTime + ' ' + bTime.getHour() + ':' + bTime.getMinute() + ':' + bTime.getSecond());
        int n = bTime.getHour() * 3600 + bTime.getMinute() * 60 + bTime.getSecond();
        PupWriteAttributeMessage pupWriteAttributeMessage = new PupWriteAttributeMessage(this.pupDevice().getUnitNumber(), this.getChannel(), this.getAttribute(), this.getAttributeType(), n);
        PupResponse pupResponse = (PupResponse)this.pupNetwork().sendSync(pupWriteAttributeMessage);
        if (!this.isValidWriteResponse(pupResponse)) {
            return false;
        }
        if (pupResponse instanceof PupAckResponse) {
            this.getPupLog().trace("Write Succeeded on " + this);
            this.writeOk((BStatusValue)new BStatusString(bTime.toString(null)));
            return true;
        }
        if (pupResponse instanceof PupErrorResponse) {
            PupErrorResponse pupErrorResponse = (PupErrorResponse)pupResponse;
            this.getPupLog().trace("Received error response writing " + this);
            this.writeFail(pupErrorResponse.getError());
            return false;
        }
        this.getPupLog().trace("Received invalid message type writing " + this);
        this.writeFail("invalid message type");
        return false;
    }

    private final void checkDateAction() {
        BControlPoint bControlPoint = this.getParentPoint();
        Class clazz = class$com$tridium$aapup$point$BSetDateAction;
        if (clazz == null) {
            clazz = class$com$tridium$aapup$point$BSetDateAction = BPupProxyExt.class("[Lcom.tridium.aapup.point.BSetDateAction;", false);
        }
        BSetDateAction[] bSetDateActionArray = (BSetDateAction[])bControlPoint.getChildren(clazz);
        switch (this.getAttributeType()) {
            case 227: 
            case 228: {
                if (bSetDateActionArray.length == 0) {
                    BSetDateAction bSetDateAction = new BSetDateAction();
                    this.getParentPoint().add("AdjustDate", (BValue)bSetDateAction, 2);
                }
                return;
            }
        }
        int n = 0;
        while (n < bSetDateActionArray.length) {
            this.getParentPoint().remove((BComplex)bSetDateActionArray[n]);
            ++n;
        }
    }

    public void setDateAttribute(BValue bValue, Context context) {
        if (bValue instanceof BAbsTime) {
            this.getPupLog().trace("Set Date Attribute on " + this + ":value=" + (BAbsTime)bValue);
            switch (this.getAttributeType()) {
                case 227: 
                case 228: {
                    this.pupNetwork().postWrite(new SetDateRequest(this, (BAbsTime)bValue));
                    return;
                }
            }
            return;
        }
    }

    public boolean setDateAttribute(BAbsTime bAbsTime) {
        PupWriteAttributeMessage pupWriteAttributeMessage = new PupWriteAttributeMessage(this.pupDevice().getUnitNumber(), this.getChannel(), this.getAttribute(), this.getAttributeType(), bAbsTime);
        PupResponse pupResponse = (PupResponse)this.pupNetwork().sendSync(pupWriteAttributeMessage);
        if (!this.isValidWriteResponse(pupResponse)) {
            return false;
        }
        if (pupResponse instanceof PupAckResponse) {
            this.getPupLog().trace("Write Succeeded on " + this);
            this.writeOk((BStatusValue)new BStatusString(bAbsTime.toString(null)));
            return true;
        }
        if (pupResponse instanceof PupErrorResponse) {
            PupErrorResponse pupErrorResponse = (PupErrorResponse)pupResponse;
            this.getPupLog().trace("Received error response writing " + this);
            this.writeFail(pupErrorResponse.getError());
            return false;
        }
        this.getPupLog().trace("Received invalid message type writing " + this);
        this.writeFail("invalid message type");
        return false;
    }

    private final void checkCvOverrideAction() {
        if (this.getAttribute().equals("CV") && !this.getParentPoint().isWritablePoint()) {
            this.setFlags((Slot)prewriteAttribute, this.getFlags((Slot)prewriteAttribute) & 0xFFFFFFFB);
        }
        BControlPoint bControlPoint = this.getParentPoint();
        Class clazz = class$com$tridium$aapup$point$BCvOverrideAction;
        if (clazz == null) {
            clazz = class$com$tridium$aapup$point$BCvOverrideAction = BPupProxyExt.class("[Lcom.tridium.aapup.point.BCvOverrideAction;", false);
        }
        BCvOverrideAction[] bCvOverrideActionArray = (BCvOverrideAction[])bControlPoint.getChildren(clazz);
        BControlPoint bControlPoint2 = this.getParentPoint();
        Class clazz2 = class$com$tridium$aapup$point$BCvResetOverrideAction;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$aapup$point$BCvResetOverrideAction = BPupProxyExt.class("[Lcom.tridium.aapup.point.BCvResetOverrideAction;", false);
        }
        BCvResetOverrideAction[] bCvResetOverrideActionArray = (BCvResetOverrideAction[])bControlPoint2.getChildren(clazz2);
        int n = 0;
        while (n < bCvOverrideActionArray.length) {
            this.getParentPoint().remove((BComplex)bCvOverrideActionArray[n]);
            ++n;
        }
        n = 0;
        while (n < bCvResetOverrideActionArray.length) {
            this.getParentPoint().remove((BComplex)bCvResetOverrideActionArray[n]);
            ++n;
        }
        if (!this.getParentPoint().isWritablePoint() && this.getAttribute().equals("CV") && this.getPrewriteAttribute().prewriteRequired()) {
            if (bCvOverrideActionArray.length == 0) {
                BCvOverrideAction bCvOverrideAction = new BCvOverrideAction();
                bCvOverrideAction.setParameterTypeSpec(this.getParentPoint().getStatusValue().getValueValue().getType().getTypeSpec());
                if (this.getPrewriteAttribute().getAttribute().equals("OI")) {
                    this.getParentPoint().add("Override", (BValue)bCvOverrideAction, 2);
                } else {
                    this.getParentPoint().add("Manual", (BValue)bCvOverrideAction, 2);
                }
            }
            if (bCvResetOverrideActionArray.length == 0) {
                BCvResetOverrideAction bCvResetOverrideAction = new BCvResetOverrideAction();
                if (this.getPrewriteAttribute().getAttribute().equals("OI")) {
                    this.getParentPoint().add("CancelOverride", (BValue)bCvResetOverrideAction, 2);
                } else {
                    this.getParentPoint().add("Auto", (BValue)bCvResetOverrideAction, 2);
                }
            }
        }
    }

    public void setCvOverride(BValue bValue, Context context) {
        this.getPupLog().trace("Set CV override on " + this + ":value=" + bValue);
        if (!this.getParentPoint().isWritablePoint() && this.getAttribute().equals("CV") && this.getPrewriteAttribute().prewriteRequired()) {
            this.pupNetwork().postWrite(new CvOverrideRequest(this, bValue));
        }
    }

    public void resetCvOverride(BValue bValue, Context context) {
        this.getPupLog().trace("Reset CV override on " + this);
        if (!this.getParentPoint().isWritablePoint() && this.getAttribute().equals("CV") && this.getPrewriteAttribute().prewriteRequired()) {
            this.pupNetwork().postAsync(new Runnable(){

                public final void run() {
                    PupWriteAttributeMessage pupWriteAttributeMessage = new PupWriteAttributeMessage(BPupProxyExt.this.pupDevice().getUnitNumber(), BPupProxyExt.this.getChannel(), BPupProxyExt.this.getPrewriteAttribute().getAttribute(), 254, BPupProxyExt.this.getPrewriteAttribute().getMakeUnwritableValue());
                    PupResponse pupResponse = (PupResponse)BPupProxyExt.this.pupNetwork().sendSync(pupWriteAttributeMessage);
                    if (!BPupProxyExt.this.isValidWriteResponse(pupResponse)) {
                        return;
                    }
                    if (pupResponse instanceof PupAckResponse) {
                        return;
                    }
                    if (pupResponse instanceof PupErrorResponse) {
                        PupErrorResponse pupErrorResponse = (PupErrorResponse)pupResponse;
                        BPupProxyExt.this.getPupLog().trace("Received error response while clearing override on " + this);
                        BPupProxyExt.this.writeFail("error response while clearing override:" + pupErrorResponse.getError());
                        return;
                    }
                    BPupProxyExt.this.getPupLog().trace("Received invalid message type while clearing " + this);
                    BPupProxyExt.this.writeFail("invalid response while clearing override");
                }
            });
        }
    }

    public boolean getOverriddenState() {
        return this.overriddenState;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.overriddenState = false;
    }

    public BPupProxyExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$aapup$point$BPupProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$aapup$point$BPupProxyExt = BPupProxyExt.class("[Lcom.tridium.aapup.point.BPupProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

