/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupMessage;
import com.tridium.aapup.messages.PupOutputStream;
import com.tridium.aapup.messages.PupReceivedMessage;
import com.tridium.aapup.messages.PupResponse;

public class PupWriteRegionDataMessage
extends PupMessage
implements AaPupConst {
    private int regionNumber;
    private int offset;
    private byte[] data;

    public int getRegionNumber() {
        return this.regionNumber;
    }

    public void setRegionNumber(int n) {
        this.regionNumber = n;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        this.data = byArray2;
    }

    void writeBytes(PupOutputStream pupOutputStream) {
        pupOutputStream.write(0);
        pupOutputStream.write(6);
        pupOutputStream.writeInt(this.data.length + 10);
        pupOutputStream.write(this.regionNumber);
        pupOutputStream.writeInt(this.offset);
        pupOutputStream.write(this.data);
    }

    PupResponse getResponse(PupReceivedMessage pupReceivedMessage) {
        if (!this.getResponseExpected()) {
            return null;
        }
        if (pupReceivedMessage.getData()[4] == -128) {
            return new PupErrorResponse(pupReceivedMessage);
        }
        if (pupReceivedMessage.getData()[4] == -127) {
            return new PupAckResponse(pupReceivedMessage);
        }
        return new PupErrorResponse(pupReceivedMessage);
    }

    public String toString() {
        return "PupWriteRegionDataMessage::unit:" + this.unitNumber + " region number:" + this.regionNumber + " offset:" + this.offset;
    }

    public PupWriteRegionDataMessage(int n, int n2, int n3, byte[] byArray) {
        super(n);
        this.regionNumber = n2;
        this.offset = n3;
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        this.data = byArray2;
    }
}

