/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.messages.PupAckResponse;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupMessage;
import com.tridium.aapup.messages.PupOutputStream;
import com.tridium.aapup.messages.PupReceivedMessage;
import com.tridium.aapup.messages.PupResponse;
import javax.baja.sys.BAbsTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PupWriteAttributeMessage
extends PupMessage
implements AaPupConst {
    private int channel;
    private String attribute;
    private int attributeType;
    private double data;
    private int[] outData;
    private BAbsTime timedata;

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String string) {
        this.attribute = string.substring(0, 2);
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int n) {
        this.channel = n;
    }

    void writeBytes(PupOutputStream pupOutputStream) {
        pupOutputStream.write(13);
        pupOutputStream.write(2);
        pupOutputStream.writeInt(this.channel);
        pupOutputStream.writeAttribute(this.attribute, false, false);
        this.convertData();
        int n = 0;
        while (n < 4) {
            pupOutputStream.write(this.outData[n]);
            ++n;
        }
    }

    public void convertData() {
        switch (this.attributeType) {
            case 255: {
                this.convert(this.data);
                return;
            }
            case 254: {
                if (this.data < 0.0) {
                    this.convert(0.0);
                }
                this.convert(this.data);
                return;
            }
            case 253: {
                this.convert(this.data * 10.0);
                return;
            }
            case 252: {
                if (this.data < 0.0) {
                    this.convert(0.0);
                }
                this.convert(this.data * 10.0);
                return;
            }
            case 251: {
                this.convert(this.data * 100.0);
                return;
            }
            case 250: {
                if (this.data < 0.0) {
                    this.convert(0.0);
                }
                this.convert(this.data * 100.0);
                return;
            }
            case 249: {
                this.convert(this.data * 1000.0);
                return;
            }
            case 248: {
                if (this.data < 0.0) {
                    this.convert(0.0);
                }
                this.convert(this.data * 1000.0);
                return;
            }
            case 247: {
                this.convert(this.data * 10000.0);
                return;
            }
            case 246: {
                if (this.data < 0.0) {
                    this.convert(0.0);
                }
                this.convert(this.data * 10000.0);
                return;
            }
            case 245: {
                this.convert(this.data * 100000.0);
                return;
            }
            case 244: {
                if (this.data < 0.0) {
                    this.convert(0.0);
                }
                this.convert(this.data * 100000.0);
                return;
            }
            case 243: {
                this.convert(this.data * 1000000.0);
                return;
            }
            case 242: {
                if (this.data < 0.0) {
                    this.convert(0.0);
                }
                this.convert(this.data * 1000000.0);
                return;
            }
            case 241: {
                this.convert(this.data * 1.0E7);
                return;
            }
            case 240: {
                if (this.data < 0.0) {
                    this.convert(0.0);
                }
                this.convert(this.data * 1.0E7);
                return;
            }
            case 239: {
                this.convert(this.data * 1.0E8);
                return;
            }
            case 238: {
                if (this.data < 0.0) {
                    this.convert(0.0);
                }
                this.convert(this.data * 1.0E8);
                return;
            }
            case 237: {
                this.convert(this.data * 1.0E9);
                return;
            }
            case 236: {
                if (this.data < 0.0) {
                    this.convert(0.0);
                }
                this.convert(this.data * 1.0E9);
                return;
            }
            case 235: {
                this.convert(this.data * 1.0E10);
                return;
            }
            case 234: {
                if (this.data < 0.0) {
                    this.convert(0.0);
                }
                this.convert(this.data * 1.0E10);
                return;
            }
            case 232: 
            case 233: {
                this.convert(this.data);
                return;
            }
            case 231: {
                long l = (long)this.data;
                this.outData[0] = (int)(l / 3600L) / 10 << 4 | (int)(l / 3600L) % 10;
                this.outData[1] = (int)(l % 3600L / 60L) / 10 << 4 | (int)(l % 3600L / 60L) % 10;
                this.outData[2] = (int)(l % 3600L % 60L) / 10 << 4 | (int)(l % 3600L % 60L) % 10;
                this.outData[3] = 0;
                return;
            }
            case 230: {
                long l = (long)this.data;
                this.outData[0] = (int)(l / 3600L) / 10 << 4 | (int)(l / 3600L) % 10;
                this.outData[1] = (int)(l % 3600L / 60L) / 10 << 4 | (int)(l % 3600L / 60L) % 10;
                this.outData[2] = 0;
                this.outData[3] = 0;
                return;
            }
            case 229: {
                long l = (long)this.data;
                this.outData[0] = (int)(l % 10L) | (int)(l / 10L % 10L << 4);
                this.outData[1] = (int)(l / 100L % 10L) | (int)(l / 1000L % 10L << 4);
                this.outData[2] = (int)(l / 10000L % 10L) | (int)(l / 100000L % 10L << 4);
                this.outData[3] = (int)(l / 1000000L % 10L) | (int)(l / 10000000L % 10L << 4);
                return;
            }
            case 228: {
                if (this.timedata == null) {
                    this.outData[3] = 0;
                    this.outData[2] = 0;
                    this.outData[1] = 0;
                    this.outData[0] = 0;
                }
                int n = this.timedata.getYear();
                int n2 = this.timedata.getMonth().getOrdinal() + 1;
                int n3 = this.timedata.getDay();
                this.outData[0] = n3 % 10 | n3 / 10 << 4;
                this.outData[1] = n2 % 10 | n2 / 10 << 4;
                this.outData[2] = n % 10 | n / 10 % 10 << 4;
                this.outData[3] = n / 100 % 10 | n / 1000 << 4;
                return;
            }
            case 227: {
                if (this.timedata == null) {
                    this.outData[3] = 0;
                    this.outData[2] = 0;
                    this.outData[1] = 0;
                    this.outData[0] = 0;
                }
                int n = this.timedata.getYear();
                int n4 = this.timedata.getMonth().getOrdinal() + 1;
                int n5 = this.timedata.getDay();
                this.outData[0] = n5 & 0xFF;
                this.outData[1] = n4 & 0xFF;
                this.outData[2] = n & 0xFF;
                this.outData[3] = (n & 0xFF00) >>> 8;
                return;
            }
            case 224: {
                int n = Float.floatToIntBits((float)this.data);
                this.outData[0] = n & 0xFF;
                this.outData[1] = n >>> 8 & 0xFF;
                this.outData[2] = n >>> 16 & 0xFF;
                this.outData[3] = n >>> 24 & 0xFF;
                return;
            }
            case 223: {
                this.outData[0] = 32;
                this.outData[1] = 32;
                this.outData[2] = 32;
                this.outData[3] = 32;
                return;
            }
        }
    }

    private final void convert(double d) {
        long l = (long)d;
        this.outData[0] = (int)(l & 0xFFL);
        this.outData[1] = (int)(l >>> 8) & 0xFF;
        this.outData[2] = (int)(l >>> 16) & 0xFF;
        this.outData[3] = (int)(l >>> 24) & 0xFF;
    }

    PupResponse getResponse(PupReceivedMessage pupReceivedMessage) {
        if (!this.getResponseExpected()) {
            return null;
        }
        if (pupReceivedMessage.getData()[4] == -128) {
            return new PupErrorResponse(pupReceivedMessage);
        }
        if (pupReceivedMessage.getData()[4] == -127) {
            return new PupAckResponse(pupReceivedMessage);
        }
        return new PupErrorResponse(pupReceivedMessage);
    }

    public String toString() {
        return "PupWriteAttributeMessage::unit:" + this.unitNumber + " [" + this.channel + ':' + this.attribute + ']';
    }

    private final /* synthetic */ void this() {
        this.outData = new int[4];
    }

    public PupWriteAttributeMessage(int n, int n2, String string, int n3, double d) {
        super(n);
        this.this();
        this.channel = n2;
        this.attribute = string;
        this.attributeType = n3;
        this.data = d;
    }

    public PupWriteAttributeMessage(int n, int n2, String string, int n3, BAbsTime bAbsTime) {
        super(n);
        this.this();
        this.channel = n2;
        this.attribute = string;
        this.attributeType = n3;
        this.timedata = bAbsTime;
    }

    public PupWriteAttributeMessage(int n, int n2, String string, int n3, boolean bl) {
        super(n);
        this.this();
        this.channel = n2;
        this.attribute = string;
        this.attributeType = n3;
        this.data = bl ? 1.0 : 0.0;
    }
}

