/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupMessage;
import com.tridium.aapup.messages.PupOutputStream;
import com.tridium.aapup.messages.PupReceivedMessage;
import com.tridium.aapup.messages.PupRegionNameResponse;
import com.tridium.aapup.messages.PupResponse;

public class PupLookupNamedRegionMessage
extends PupMessage
implements AaPupConst {
    private String regionName;
    private int regionNameLength;
    private int regionNumber;

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String string) {
        this.regionName = string.length() > 8 ? string.substring(0, 8) : string;
        this.regionNameLength = this.regionName.length();
        this.regionNumber = 0;
    }

    public int getRegionNumber() {
        return this.regionNumber;
    }

    public void setRegionNumber(int n) {
        this.regionNumber = n;
        if (n < 0) {
            this.regionNumber = 0;
        }
        if (n > 255) {
            this.regionNumber = 255;
        }
        this.regionName = "";
        this.regionNameLength = 0;
    }

    void writeBytes(PupOutputStream pupOutputStream) {
        if (this.regionNameLength == 0) {
            pupOutputStream.write(7);
        } else {
            pupOutputStream.write(6 + this.regionNameLength);
        }
        pupOutputStream.write(8);
        pupOutputStream.write(this.regionNameLength);
        if (this.regionNameLength == 0) {
            pupOutputStream.write(this.regionNumber);
        } else {
            pupOutputStream.writeString(this.regionName);
        }
    }

    PupResponse getResponse(PupReceivedMessage pupReceivedMessage) {
        if (!this.getResponseExpected()) {
            return null;
        }
        if (pupReceivedMessage.getData()[4] == -128) {
            return new PupErrorResponse(pupReceivedMessage);
        }
        if (pupReceivedMessage.getData()[4] == -121) {
            return new PupRegionNameResponse(pupReceivedMessage);
        }
        return new PupErrorResponse(pupReceivedMessage);
    }

    public String toString() {
        return "PupLookupNamedRegionMessage::unit:" + this.unitNumber + " regionName:" + this.regionName + " regionNumber:" + this.regionNumber;
    }

    public PupLookupNamedRegionMessage(int n, String string) {
        super(n);
        this.regionName = string.length() > 8 ? string.substring(0, 8) : string;
        this.regionNameLength = this.regionName.length();
        this.regionNumber = 0;
    }

    public PupLookupNamedRegionMessage(int n, int n2) {
        super(n);
        this.regionNumber = n2;
        if (n2 < 0) {
            this.regionNumber = 0;
        }
        if (n2 > 255) {
            this.regionNumber = 255;
        }
        this.regionName = "";
        this.regionNameLength = 0;
    }
}

