/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.messages;

import com.tridium.aapup.AaPupConst;
import com.tridium.aapup.messages.PupErrorResponse;
import com.tridium.aapup.messages.PupMessage;
import com.tridium.aapup.messages.PupOutputStream;
import com.tridium.aapup.messages.PupReceivedMessage;
import com.tridium.aapup.messages.PupRegionNameResponse;
import com.tridium.aapup.messages.PupResponse;

public class PupCreateNamedRegionMessage
extends PupMessage
implements AaPupConst {
    private String regionName;
    private int regionNameLength;
    private int regionType;
    private int regionSize;

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String string) {
        String string2 = string.trim();
        this.regionName = string2.length() > 8 ? string2.substring(0, 8) : (string2.length() == 0 ? "?" : string2);
        this.regionNameLength = this.regionName.length();
    }

    public int getRegionType() {
        return this.regionType;
    }

    public void setRegionType(int n) {
        this.regionType = n;
        if (n < 0) {
            this.regionType = 0;
        }
        if (n > 127) {
            this.regionType = 127;
        }
    }

    public int getRegionSize() {
        return this.regionSize;
    }

    public void setRegionSize(int n) {
        this.regionSize = n;
        if (n < 0) {
            this.regionSize = 0;
        }
        if (n > (char)-1) {
            this.regionSize = (char)-1;
        }
    }

    void writeBytes(PupOutputStream pupOutputStream) {
        pupOutputStream.write(9 + this.regionNameLength);
        pupOutputStream.write(7);
        pupOutputStream.write(this.regionType);
        pupOutputStream.writeInt(this.regionSize);
        pupOutputStream.write(this.regionNameLength);
        pupOutputStream.writeString(this.regionName);
    }

    PupResponse getResponse(PupReceivedMessage pupReceivedMessage) {
        if (!this.getResponseExpected()) {
            return null;
        }
        if (pupReceivedMessage.getData()[4] == -128) {
            return new PupErrorResponse(pupReceivedMessage);
        }
        if (pupReceivedMessage.getData()[4] == -121) {
            return new PupRegionNameResponse(pupReceivedMessage);
        }
        return new PupErrorResponse(pupReceivedMessage);
    }

    public String toString() {
        return "PupCreateNamedRegionMessage::unit:" + this.unitNumber + " regionName:" + this.regionName + " regionType:" + this.regionType + " regionSize:" + this.regionSize;
    }

    public PupCreateNamedRegionMessage(int n, String string, int n2, int n3) {
        super(n);
        String string2 = string.trim();
        this.regionName = string2.length() > 8 ? string2.substring(0, 8) : (string2.length() == 0 ? "?" : string2);
        this.regionNameLength = this.regionName.length();
        this.regionType = n2;
        this.regionSize = n3;
    }
}

