/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup.datatypes;

import com.tridium.aapup.BPupNetwork;
import com.tridium.aapup.enums.BPupPeerTypeEnum;
import javax.baja.data.BIDataValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPupTokenPassConfig
extends BComponent {
    public static final Property tokenPassingEnabled = BPupTokenPassConfig.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"enabled", (String)"disabled"));
    public static final Property passToDownDevices = BPupTokenPassConfig.newProperty((int)0, (boolean)false, null);
    public static final Property peerType = BPupTokenPassConfig.newProperty((int)1, (BValue)BPupPeerTypeEnum.fullAdminRoundRobin, null);
    public static final Property tokenRecovery = BPupTokenPassConfig.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"enabled", (String)"disabled"));
    public static final Property tokenRecoveryType = BPupTokenPassConfig.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"No Token Passes Detected", (String)"No Bus Activity Detected"));
    public static final Property tokenRecoveryTimeout = BPupTokenPassConfig.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)500L), (String)"max", (BIDataValue)BRelTime.make((long)Long.MAX_VALUE)));
    public static final Property tokenRecoveryCount = BPupTokenPassConfig.newProperty((int)3, (int)0, null);
    public static final Property passTokenOnTransactionCount = BPupTokenPassConfig.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"enabled", (String)"disabled"));
    public static final Property transactionsPerToken = BPupTokenPassConfig.newProperty((int)0, (int)10, null);
    public static final Property passTokenOnTimeout = BPupTokenPassConfig.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"enabled", (String)"disabled"));
    public static final Property timePerToken = BPupTokenPassConfig.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)200L), (String)"max", (BIDataValue)BRelTime.make((long)Long.MAX_VALUE)));
    public static final Property tokenSnoop = BPupTokenPassConfig.newProperty((int)3, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE, (String)"fieldWidth", (BIDataValue)BInteger.make((int)64)));
    public static final Property logTokenSnoopOnTokenRecovery = BPupTokenPassConfig.newProperty((int)0, (boolean)false, null);
    public static final Action resetTokenRecoveryCount = BPupTokenPassConfig.newAction((int)0, null);
    public static final Action logTokenSnoop = BPupTokenPassConfig.newAction((int)0, null);
    public static final Action clearTokenSnoop = BPupTokenPassConfig.newAction((int)0, null);
    public static final Type TYPE;
    private static int TOKEN_SNOOP_SIZE;
    private String[] snoops;
    static /* synthetic */ Class class$com$tridium$aapup$datatypes$BPupTokenPassConfig;

    public boolean getTokenPassingEnabled() {
        return this.getBoolean(tokenPassingEnabled);
    }

    public void setTokenPassingEnabled(boolean bl) {
        this.setBoolean(tokenPassingEnabled, bl, null);
    }

    public boolean getPassToDownDevices() {
        return this.getBoolean(passToDownDevices);
    }

    public void setPassToDownDevices(boolean bl) {
        this.setBoolean(passToDownDevices, bl, null);
    }

    public BPupPeerTypeEnum getPeerType() {
        return (BPupPeerTypeEnum)this.get(peerType);
    }

    public void setPeerType(BPupPeerTypeEnum bPupPeerTypeEnum) {
        this.set(peerType, (BValue)bPupPeerTypeEnum, null);
    }

    public boolean getTokenRecovery() {
        return this.getBoolean(tokenRecovery);
    }

    public void setTokenRecovery(boolean bl) {
        this.setBoolean(tokenRecovery, bl, null);
    }

    public boolean getTokenRecoveryType() {
        return this.getBoolean(tokenRecoveryType);
    }

    public void setTokenRecoveryType(boolean bl) {
        this.setBoolean(tokenRecoveryType, bl, null);
    }

    public BRelTime getTokenRecoveryTimeout() {
        return (BRelTime)this.get(tokenRecoveryTimeout);
    }

    public void setTokenRecoveryTimeout(BRelTime bRelTime) {
        this.set(tokenRecoveryTimeout, (BValue)bRelTime, null);
    }

    public int getTokenRecoveryCount() {
        return this.getInt(tokenRecoveryCount);
    }

    public void setTokenRecoveryCount(int n) {
        this.setInt(tokenRecoveryCount, n, null);
    }

    public boolean getPassTokenOnTransactionCount() {
        return this.getBoolean(passTokenOnTransactionCount);
    }

    public void setPassTokenOnTransactionCount(boolean bl) {
        this.setBoolean(passTokenOnTransactionCount, bl, null);
    }

    public int getTransactionsPerToken() {
        return this.getInt(transactionsPerToken);
    }

    public void setTransactionsPerToken(int n) {
        this.setInt(transactionsPerToken, n, null);
    }

    public boolean getPassTokenOnTimeout() {
        return this.getBoolean(passTokenOnTimeout);
    }

    public void setPassTokenOnTimeout(boolean bl) {
        this.setBoolean(passTokenOnTimeout, bl, null);
    }

    public BRelTime getTimePerToken() {
        return (BRelTime)this.get(timePerToken);
    }

    public void setTimePerToken(BRelTime bRelTime) {
        this.set(timePerToken, (BValue)bRelTime, null);
    }

    public String getTokenSnoop() {
        return this.getString(tokenSnoop);
    }

    public void setTokenSnoop(String string) {
        this.setString(tokenSnoop, string, null);
    }

    public boolean getLogTokenSnoopOnTokenRecovery() {
        return this.getBoolean(logTokenSnoopOnTokenRecovery);
    }

    public void setLogTokenSnoopOnTokenRecovery(boolean bl) {
        this.setBoolean(logTokenSnoopOnTokenRecovery, bl, null);
    }

    public void resetTokenRecoveryCount() {
        this.invoke(resetTokenRecoveryCount, null, null);
    }

    public void logTokenSnoop() {
        this.invoke(logTokenSnoop, null, null);
    }

    public void clearTokenSnoop() {
        this.invoke(clearTokenSnoop, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.snoops = new String[TOKEN_SNOOP_SIZE];
        int n = 0;
        while (n < this.snoops.length) {
            this.snoops[n] = "";
            ++n;
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        BPupNetwork bPupNetwork = (BPupNetwork)this.getParent();
        if (bPupNetwork != null) {
            if (property == tokenPassingEnabled) {
                if (this.getTokenPassingEnabled()) {
                    if (this.getPassTokenOnTimeout()) {
                        if (this.getTokenPassingEnabled()) {
                            bPupNetwork.initializeTokenTimer();
                        } else {
                            bPupNetwork.cancelTokenTimer();
                        }
                    }
                } else {
                    bPupNetwork.cancelTokenTimer();
                    bPupNetwork.cancelTokenRecoveryTimer();
                }
            }
            if (property == passTokenOnTimeout) {
                if (this.getPassTokenOnTimeout()) {
                    bPupNetwork.initializeTokenTimer();
                } else {
                    bPupNetwork.cancelTokenTimer();
                }
            } else if (property == timePerToken) {
                bPupNetwork.initializeTokenTimer();
            } else if (property == tokenRecovery || property == tokenRecoveryTimeout) {
                if (this.getTokenRecovery()) {
                    bPupNetwork.initializeTokenRecoveryTimer();
                } else {
                    bPupNetwork.cancelTokenRecoveryTimer();
                }
            }
        }
    }

    public void doResetTokenRecoveryCount() {
        this.setTokenRecoveryCount(0);
    }

    public void incrementTokenRecoveryCount() {
        this.setTokenRecoveryCount(this.getTokenRecoveryCount() + 1);
    }

    public void appendTokenSnoop(String string) {
        this.snoops[0] = this.snoops[0] + string;
        if (string.endsWith("\n") || string.endsWith("*recover*") || this.snoops[0].length() > 60) {
            System.arraycopy(this.snoops, 0, this.snoops, 1, this.snoops.length - 1);
            this.snoops[0] = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = TOKEN_SNOOP_SIZE;
        while (n > 0) {
            stringBuffer.append(this.snoops[n - 1]);
            --n;
        }
        this.setTokenSnoop(stringBuffer.toString());
    }

    public void doLogTokenSnoop() {
        BPupNetwork bPupNetwork = (BPupNetwork)this.getParent();
        if (bPupNetwork != null) {
            bPupNetwork.getPupLog().message("TokenSnoop:\n" + this.getTokenSnoop());
        }
    }

    public void doClearTokenSnoop() {
        int n = 0;
        while (n < TOKEN_SNOOP_SIZE) {
            this.snoops[n] = "";
            ++n;
        }
        this.setTokenSnoop("");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$aapup$datatypes$BPupTokenPassConfig;
        if (clazz == null) {
            clazz = class$com$tridium$aapup$datatypes$BPupTokenPassConfig = BPupTokenPassConfig.class("[Lcom.tridium.aapup.datatypes.BPupTokenPassConfig;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        TOKEN_SNOOP_SIZE = 8;
    }
}

