/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aapup;

import com.tridium.aapup.BPupDevice;
import com.tridium.aapup.BPupDeviceFolder;
import com.tridium.aapup.BPupPeerListFolder;
import com.tridium.aapup.comm.BPupUnsolicitedReceive;
import com.tridium.aapup.comm.PupCommReceiver;
import com.tridium.aapup.datatypes.BPupDeviceDiscoveryConfig;
import com.tridium.aapup.datatypes.BPupTokenPassConfig;
import com.tridium.aapup.job.BPupDiscoverDevicesJob;
import com.tridium.aapup.messages.PupPassTokenMessage;
import com.tridium.aapup.messages.PupTimeSyncMessage;
import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.serial.BSerialNetwork;
import com.tridium.basicdriver.serial.SerialComm;
import java.io.InputStream;
import javax.baja.file.BIFile;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IntHashMap;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPupNetwork
extends BSerialNetwork {
    public static final Property unitNumber = BPupNetwork.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)1, (int)((char)-1)));
    public static final Property tokenPassConfig = BPupNetwork.newProperty((int)0, (BValue)new BPupTokenPassConfig(), null);
    public static final Property peerList = BPupNetwork.newProperty((int)2, (BValue)new BPupPeerListFolder(), null);
    public static final Property unsolicitedReceiveHandler = BPupNetwork.newProperty((int)4, (BValue)new BPupUnsolicitedReceive(), null);
    public static final Property allowTimeSyncBroadcast = BPupNetwork.newProperty((int)0, (boolean)true, null);
    public static final Property timeSyncFrequency = BPupNetwork.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)1), null);
    public static final Property holiday = BPupNetwork.newProperty((int)0, (BValue)new BStatusBoolean(false), null);
    public static final Property deviceTypesFile = BPupNetwork.newProperty((int)0, (BValue)BOrd.make((String)"module://aapup/com/tridium/aapup/deviceTypes.xml"), null);
    public static final Action submitDeviceDiscoveryJob = BPupNetwork.newAction((int)4, (BValue)new BPupDeviceDiscoveryConfig(), null);
    public static final Action syncTime = BPupNetwork.newAction((int)0, null);
    public static final Action expireToken = BPupNetwork.newAction((int)4, null);
    public static final Action recoverToken = BPupNetwork.newAction((int)4, null);
    public static final Type TYPE;
    private PupToken token;
    private Object tokenMonitor;
    Object responseMonitor;
    private Clock.Ticket timeSyncTicket;
    private Clock.Ticket tokenTimerTicket;
    private Clock.Ticket tokenRecoveryTicket;
    private IntHashMap controllerMap;
    static /* synthetic */ Class class$com$tridium$aapup$BPupNetwork;

    public int getUnitNumber() {
        return this.getInt(unitNumber);
    }

    public void setUnitNumber(int n) {
        this.setInt(unitNumber, n, null);
    }

    public BPupTokenPassConfig getTokenPassConfig() {
        return (BPupTokenPassConfig)this.get(tokenPassConfig);
    }

    public void setTokenPassConfig(BPupTokenPassConfig bPupTokenPassConfig) {
        this.set(tokenPassConfig, (BValue)bPupTokenPassConfig, null);
    }

    public BPupPeerListFolder getPeerList() {
        return (BPupPeerListFolder)this.get(peerList);
    }

    public void setPeerList(BPupPeerListFolder bPupPeerListFolder) {
        this.set(peerList, (BValue)bPupPeerListFolder, null);
    }

    public BPupUnsolicitedReceive getUnsolicitedReceiveHandler() {
        return (BPupUnsolicitedReceive)this.get(unsolicitedReceiveHandler);
    }

    public void setUnsolicitedReceiveHandler(BPupUnsolicitedReceive bPupUnsolicitedReceive) {
        this.set(unsolicitedReceiveHandler, (BValue)bPupUnsolicitedReceive, null);
    }

    public boolean getAllowTimeSyncBroadcast() {
        return this.getBoolean(allowTimeSyncBroadcast);
    }

    public void setAllowTimeSyncBroadcast(boolean bl) {
        this.setBoolean(allowTimeSyncBroadcast, bl, null);
    }

    public BRelTime getTimeSyncFrequency() {
        return (BRelTime)this.get(timeSyncFrequency);
    }

    public void setTimeSyncFrequency(BRelTime bRelTime) {
        this.set(timeSyncFrequency, (BValue)bRelTime, null);
    }

    public BStatusBoolean getHoliday() {
        return (BStatusBoolean)this.get(holiday);
    }

    public void setHoliday(BStatusBoolean bStatusBoolean) {
        this.set(holiday, (BValue)bStatusBoolean, null);
    }

    public BOrd getDeviceTypesFile() {
        return (BOrd)this.get(deviceTypesFile);
    }

    public void setDeviceTypesFile(BOrd bOrd) {
        this.set(deviceTypesFile, (BValue)bOrd, null);
    }

    public BOrd submitDeviceDiscoveryJob(BPupDeviceDiscoveryConfig bPupDeviceDiscoveryConfig) {
        return (BOrd)this.invoke(submitDeviceDiscoveryJob, (BValue)bPupDeviceDiscoveryConfig, null);
    }

    public void syncTime() {
        this.invoke(syncTime, null, null);
    }

    public void expireToken() {
        this.invoke(expireToken, null, null);
    }

    public void recoverToken() {
        this.invoke(recoverToken, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "aapup");
    }

    public void started() throws Exception {
        super.started();
        this.initializeTimerTickets();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            if (this.getEnabled()) {
                this.initializeTimerTickets();
            } else {
                this.cancelTimerTickets();
            }
        }
        if (property == allowTimeSyncBroadcast || property == timeSyncFrequency) {
            if (this.timeSyncTicket != null) {
                this.timeSyncTicket.cancel();
            }
            if (this.getAllowTimeSyncBroadcast()) {
                this.timeSyncTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getTimeSyncFrequency(), (Action)syncTime, null);
            }
            return;
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        this.cancelTimerTickets();
    }

    public void initializeTimerTickets() {
        this.token = new PupToken();
        if (this.getAllowTimeSyncBroadcast()) {
            this.timeSyncTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getTimeSyncFrequency(), (Action)syncTime, null);
        }
        if (this.getTokenPassConfig().getTokenPassingEnabled()) {
            this.initializeTokenTimer();
        } else {
            this.receivedToken(this.getUnitNumber());
        }
    }

    public void cancelTimerTickets() {
        if (this.timeSyncTicket != null) {
            this.timeSyncTicket.cancel();
        }
        this.timeSyncTicket = null;
        if (this.tokenTimerTicket != null) {
            this.tokenTimerTicket.cancel();
        }
        this.tokenTimerTicket = null;
    }

    public Type getDeviceType() {
        return BPupDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BPupDeviceFolder.TYPE;
    }

    protected Comm makeComm() {
        return new SerialComm((BSerialNetwork)this, (CommReceiver)new PupCommReceiver());
    }

    public Message sendSync(Message message, BRelTime bRelTime, int n) {
        if (!this.isCommActive() || message == null) {
            return null;
        }
        boolean bl = message.getResponseExpected();
        TokenManagedDispatchRequest tokenManagedDispatchRequest = new TokenManagedDispatchRequest((BBasicNetwork)this, message, bRelTime, n);
        if (bl) {
            this.dispatch(tokenManagedDispatchRequest);
            return tokenManagedDispatchRequest.getResponse(0);
        }
        this.dispatch(tokenManagedDispatchRequest);
        return null;
    }

    public BOrd doSubmitDeviceDiscoveryJob(BPupDeviceDiscoveryConfig bPupDeviceDiscoveryConfig, Context context) {
        return new BPupDiscoverDevicesJob(this, bPupDeviceDiscoveryConfig).submit(context);
    }

    public void doExpireToken() {
        this.token.setTimerExpired(true);
        this.sendSync(new PupPassTokenMessage(0, this.getUnitNumber()), BRelTime.DEFAULT, 0);
        this.initializeTokenRecoveryTimer();
    }

    public void doRecoverToken() {
        this.getTokenPassConfig().incrementTokenRecoveryCount();
        this.receivedToken(this.getUnitNumber());
        this.getPupLog().message("recovered token");
        if (this.getTokenPassConfig().getLogTokenSnoopOnTokenRecovery()) {
            this.getTokenPassConfig().doLogTokenSnoop();
        }
        this.getTokenPassConfig().appendTokenSnoop("\n*recover*");
        this.getPeerList().lastTokenFailed();
    }

    public void doPassToken() {
        if (this.getTokenPassConfig().getTokenPassingEnabled()) {
            int n = this.getNextPeer();
            if (n != -1) {
                this.getTokenPassConfig().appendTokenSnoop("[" + this.getUnitNumber() + '>' + n + ']');
                this.token.setHasToken(false);
                PupPassTokenMessage pupPassTokenMessage = new PupPassTokenMessage(n, this.getUnitNumber());
                this.getComm().transmit((Message)pupPassTokenMessage);
            } else {
                this.getTokenPassConfig().appendTokenSnoop("\n[no peers]");
                this.initializeTokenTimer();
                this.cancelTokenRecoveryTimer();
            }
        } else {
            this.token.setHasToken(true);
            this.cancelTokenRecoveryTimer();
        }
    }

    public void doSyncTime() {
        PupTimeSyncMessage pupTimeSyncMessage = new PupTimeSyncMessage(this.getHoliday().getBoolean());
        this.sendSync(pupTimeSyncMessage, BRelTime.make((long)0L), 0);
    }

    public String getControllerDescription(int n, int n2) {
        this.populateControllerMap();
        String string = (String)this.controllerMap.get(n << 16 | n2);
        if (string == null) {
            string = "Unknown, manuf:" + n + " code:" + n2;
        }
        return string;
    }

    public void populateControllerMap() {
        try {
            BOrd bOrd = this.getDeviceTypesFile();
            BIFile bIFile = (BIFile)bOrd.resolve().get();
            XElem xElem = XParser.make((InputStream)bIFile.getInputStream()).parse();
            XElem[] xElemArray = xElem.elems("device");
            int n = 0;
            while (n < xElemArray.length) {
                int n2 = xElemArray[n].geti("cm", 0);
                int n3 = xElemArray[n].geti("ct", 0);
                String string = xElemArray[n].get("controllerType", "unknown");
                this.controllerMap.put((n2 << 16) + n3, (Object)string);
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("Error Loading PUP Device Types!");
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void receivedToken(int n) {
        if (!this.getTokenPassConfig().getTokenPassingEnabled() && n != this.getUnitNumber()) {
            this.getPupLog().error("received token from " + n + " while token passing is disabled");
        }
        Object object = this.tokenMonitor;
        synchronized (object) {
            this.token.setHasToken(true);
            this.initializeTokenTimer();
            this.cancelTokenRecoveryTimer();
            this.tokenMonitor.notifyAll();
            this.getPeerList().setLastTokenTime(n);
            return;
        }
    }

    public void initializeTokenTimer() {
        if (this.getTokenPassConfig().getPassTokenOnTimeout() && this.getTokenPassConfig().getTokenPassingEnabled()) {
            if (this.tokenTimerTicket != null) {
                this.tokenTimerTicket.cancel();
            }
            if (this.getTokenPassConfig().getPassTokenOnTimeout()) {
                this.tokenTimerTicket = Clock.schedule((BComponent)this, (BRelTime)this.getTokenPassConfig().getTimePerToken(), (Action)expireToken, null);
            }
        }
    }

    public void cancelTokenTimer() {
        if (this.tokenTimerTicket != null) {
            this.tokenTimerTicket.cancel();
        }
        this.tokenTimerTicket = null;
    }

    public void initializeTokenRecoveryTimer() {
        if (this.getTokenPassConfig().getTokenRecovery() && this.getTokenPassConfig().getTokenPassingEnabled()) {
            if (this.tokenRecoveryTicket != null) {
                this.tokenRecoveryTicket.cancel();
            }
            this.tokenRecoveryTicket = Clock.schedule((BComponent)this, (BRelTime)this.getTokenPassConfig().getTokenRecoveryTimeout(), (Action)recoverToken, null);
        }
    }

    public void cancelTokenRecoveryTimer() {
        if (this.tokenRecoveryTicket != null) {
            this.tokenRecoveryTicket.cancel();
        }
        this.tokenRecoveryTicket = null;
    }

    public int getNextPeer() {
        return this.getPeerList().getOldest(this.getTokenPassConfig().getPassToDownDevices());
    }

    public Log getPupLog() {
        return this.getNetwork().getLog();
    }

    public boolean hasToken() {
        return this.token.hasToken();
    }

    static /* synthetic */ Object access$0(BPupNetwork bPupNetwork) {
        return bPupNetwork.tokenMonitor;
    }

    static /* synthetic */ PupToken access$1(BPupNetwork bPupNetwork) {
        return bPupNetwork.token;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.tokenMonitor = new Object();
        this.responseMonitor = new Object();
        this.controllerMap = new IntHashMap();
    }

    public BPupNetwork() {
        this.this();
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
        this.setFlags((Slot)ping, 4);
        this.setFlags((Slot)alarmSourceInfo, 4);
        this.setFlags((Slot)health, 4);
    }

    static {
        Class clazz = class$com$tridium$aapup$BPupNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$aapup$BPupNetwork = BPupNetwork.class("[Lcom.tridium.aapup.BPupNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class PupToken {
        private boolean hasToken = true;
        private int sentMessageCount = 0;
        private boolean timerExpired;

        public boolean hasToken() {
            return this.hasToken;
        }

        public void setHasToken(boolean bl) {
            this.hasToken = bl;
            this.sentMessageCount = 0;
            this.timerExpired = false;
        }

        public void incrementSentMessageCount() {
            if (this.sentMessageCount == Short.MAX_VALUE) {
                this.sentMessageCount = 0;
            }
            ++this.sentMessageCount;
        }

        public int getSentMessageCount() {
            return this.sentMessageCount;
        }

        public boolean isExpired() {
            if (BPupNetwork.this.getTokenPassConfig().getPassTokenOnTransactionCount()) {
                boolean bl = false;
                if (this.sentMessageCount >= BPupNetwork.this.getTokenPassConfig().getTransactionsPerToken() || this.timerExpired) {
                    bl = true;
                }
                return bl;
            }
            return this.timerExpired;
        }

        public void setTimerExpired(boolean bl) {
            this.timerExpired = bl;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" hasToken=" + this.hasToken).append(" sentCnt =" + this.sentMessageCount).append(" expired =" + this.timerExpired);
            return stringBuffer.toString();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class TokenManagedDispatchRequest
    implements Runnable {
        Message msg;
        Message response;
        boolean complete;
        BBasicNetwork basicNet;
        BRelTime responseTimeout;
        int retryCount;

        public void run() {
            this.execute();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void execute() {
            var1_1 = BPupNetwork.access$0(BPupNetwork.this);
            synchronized (var1_1) {
                if (BPupNetwork.access$1(BPupNetwork.this).isExpired()) {
                    BPupNetwork.this.doPassToken();
                }
                if (this.msg instanceof PupPassTokenMessage) {
                    return;
                }
                while (true) {
                    if (BPupNetwork.access$1(BPupNetwork.this).hasToken()) {
                        break;
                    }
                    try {
                        BPupNetwork.access$0(BPupNetwork.this).wait();
                    }
                    catch (InterruptedException var3_2) {
                        System.out.println("interrupted while waiting for token");
                    }
                }
            }
            var1_1 = BPupNetwork.this.responseMonitor;
            synchronized (var1_1) {
                block19: {
                    this.response = null;
                    ** try [egrp 4[TRYBLOCK] [6 : 110->186)] { 
lbl27:
                    // 1 sources

                    {
                        if (this.msg == null) {
                            return;
                        }
                        BPupNetwork.access$1(BPupNetwork.this).incrementSentMessageCount();
                        if (!this.msg.getResponseExpected()) {
                            this.basicNet.getComm().transmitNoResponse(this.msg);
                            break block19;
                        } else {
                            this.response = this.basicNet.getComm().transmit(this.msg, this.responseTimeout, this.retryCount);
                        }
                    }
lbl38:
                    // 1 sources

                    catch (Exception var3_3) {
                        this.basicNet.getLog().error("DispatchRequest caught exception in execute(): ", (Throwable)var3_3);
                    }
                }
                this.complete = true;
                BPupNetwork.this.responseMonitor.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        Message getResponse(int n) {
            Object object = BPupNetwork.this.responseMonitor;
            synchronized (object) {
                while (!this.complete) {
                    try {
                        BPupNetwork.this.responseMonitor.wait(n);
                        continue;
                    }
                    catch (Exception exception) {
                        this.basicNet.getLog().error("exception waiting in getResponse from TokenManagedDispatchRequest: ", (Throwable)exception);
                        continue;
                    }
                    break;
                }
                return this.response;
            }
        }

        private final /* synthetic */ void this() {
            this.response = null;
            this.complete = false;
        }

        public TokenManagedDispatchRequest(BBasicNetwork bBasicNetwork, Message message, BRelTime bRelTime, int n) {
            this.this();
            this.basicNet = bBasicNetwork;
            this.msg = message;
            this.responseTimeout = bRelTime;
            this.retryCount = n;
        }
    }
}

