/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.server.point;

import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.modbusCore.ModbusErrorCodes;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BRegisterTypesEnum;
import com.tridium.modbusCore.point.BModbusProxyExt;
import com.tridium.modbusCore.server.point.BModbusServerPointDeviceExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BModbusServerProxyExt
extends BModbusProxyExt
implements ModbusErrorCodes,
BIBasicPollable {
    public static final Type TYPE;
    protected boolean configFault;
    BStatusValue lastReadValue;
    static /* synthetic */ Class class$com$tridium$modbusCore$server$point$BModbusServerProxyExt;

    public Type getType() {
        return TYPE;
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    public Type getDeviceExtType() {
        return BModbusServerPointDeviceExt.TYPE;
    }

    public boolean write(Context context) throws Exception {
        if (this.configFault) {
            return false;
        }
        return super.write(context);
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)dataAddress)) {
            this.setStale(true, null);
            this.checkConfiguration();
            if (this.getParentPoint().isWritablePoint()) {
                this.getTuning().writeDesired();
            }
        }
    }

    protected void convertDeviceToProxy(BStatusValue bStatusValue, BStatusValue bStatusValue2) {
        this.lastReadValue = bStatusValue;
        super.convertDeviceToProxy(bStatusValue, bStatusValue2);
    }

    protected final void checkConfiguration() {
        if (!this.isValidAddress(this.getDataAddress())) {
            this.configFault = true;
            String string = "Illegal Modbus address " + (Object)((Object)this.getDataAddress()) + " for this point's configuration.";
            this.readFail(string);
            if (Sys.atSteadyState() && this.modbusNet() != null) {
                this.modbusNet().getModbusLog().error("Illegal Modbus address for point " + this.getParent().getName() + ": Modbus Address does not match Object type.");
            }
        } else {
            this.configFault = false;
        }
    }

    protected boolean isValidAddress(BFlexAddress bFlexAddress) {
        return bFlexAddress.isValid();
    }

    public abstract BRegisterTypesEnum determineRegisterType();

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.configFault = false;
        this.lastReadValue = null;
    }

    public BModbusServerProxyExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$modbusCore$server$point$BModbusServerProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$modbusCore$server$point$BModbusServerProxyExt = BModbusServerProxyExt.class("[Lcom.tridium.modbusCore.server.point.BModbusServerProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

