/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.server.messages;

import com.tridium.modbusCore.messages.ModbusInputStream;
import java.util.Vector;

public class ModbusServerWriteFileRequest {
    public int deviceAddress;
    public int functionCode;
    private int subRequestCount;
    private int[] fileNumber;
    private int[] startingRecNumber;
    private int[] recLength;
    private Vector recData;

    public int getNumSubRequests() {
        return this.subRequestCount;
    }

    public int getFileNumber(int n) {
        return this.fileNumber[n];
    }

    public int getStartingRecordNumber(int n) {
        return this.startingRecNumber[n];
    }

    public int getRecordLength(int n) {
        return this.recLength[n];
    }

    public byte[] getRecordData(int n) {
        return (byte[])this.recData.elementAt(n);
    }

    public ModbusServerWriteFileRequest(byte[] byArray) {
        ModbusInputStream modbusInputStream = new ModbusInputStream(byArray);
        this.deviceAddress = modbusInputStream.read() & 0xFF;
        this.functionCode = modbusInputStream.read() & 0xFF;
        int n = modbusInputStream.read() & 0xFF;
        int n2 = n / 7;
        this.fileNumber = new int[n2];
        this.startingRecNumber = new int[n2];
        this.recLength = new int[n2];
        this.recData = new Vector(n2);
        this.subRequestCount = 0;
        while (n > 6) {
            int n3 = modbusInputStream.read();
            this.fileNumber[this.subRequestCount] = modbusInputStream.readWord();
            this.startingRecNumber[this.subRequestCount] = modbusInputStream.readWord();
            this.recLength[this.subRequestCount] = modbusInputStream.readWord();
            n -= 7;
            byte[] byArray2 = new byte[this.recLength[this.subRequestCount] * 2];
            int n4 = 0;
            while (n4 < byArray2.length) {
                byArray2[n4] = (byte)(modbusInputStream.read() & 0xFF);
                --n;
                ++n4;
            }
            this.recData.addElement(byArray2);
            ++this.subRequestCount;
        }
    }
}

