/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.server;

import com.tridium.modbusCore.BModbusDevice;
import com.tridium.modbusCore.ModbusErrorCodes;
import com.tridium.modbusCore.ModbusException;
import com.tridium.modbusCore.messages.ModbusMessageConst;
import com.tridium.modbusCore.server.datatypes.BModbusRegisterRangeEntry;
import com.tridium.modbusCore.server.datatypes.BModbusRegisterRangeTable;
import com.tridium.modbusCore.server.datatypes.BModbusServerStringRecord;
import com.tridium.modbusCore.server.point.BModbusServerPointDeviceExt;
import java.util.ArrayList;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IntHashMap;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BModbusServerDevice
extends BModbusDevice
implements ModbusMessageConst,
ModbusErrorCodes {
    public static Lexicon lex = Lexicon.make((String)"modbusCore");
    public static final Property validCoilsRange = BModbusServerDevice.newProperty((int)0, (BValue)new BModbusRegisterRangeTable(new BModbusRegisterRangeEntry(), lex.getText("device.strings.defaultRange")), null);
    public static final Property validStatusRange = BModbusServerDevice.newProperty((int)0, (BValue)new BModbusRegisterRangeTable(new BModbusRegisterRangeEntry(), lex.getText("device.strings.defaultRange")), null);
    public static final Property validHoldingRegistersRange = BModbusServerDevice.newProperty((int)0, (BValue)new BModbusRegisterRangeTable(new BModbusRegisterRangeEntry(), lex.getText("device.strings.defaultRange")), null);
    public static final Property validInputRegistersRange = BModbusServerDevice.newProperty((int)0, (BValue)new BModbusRegisterRangeTable(new BModbusRegisterRangeEntry(), lex.getText("device.strings.defaultRange")), null);
    public static final Property points = BModbusServerDevice.newProperty((int)0, (BValue)new BModbusServerPointDeviceExt(), null);
    public static final Type TYPE;
    private static final BIcon icon;
    private IntHashMap inputRegisterByteArray;
    private IntHashMap holdingRegisterByteArray;
    private IntHashMap coilStatusBitSet;
    private IntHashMap inputStatusBitSet;
    static /* synthetic */ Class class$com$tridium$modbusCore$server$BModbusServerDevice;

    public BModbusRegisterRangeTable getValidCoilsRange() {
        return (BModbusRegisterRangeTable)this.get(validCoilsRange);
    }

    public void setValidCoilsRange(BModbusRegisterRangeTable bModbusRegisterRangeTable) {
        this.set(validCoilsRange, (BValue)bModbusRegisterRangeTable, null);
    }

    public BModbusRegisterRangeTable getValidStatusRange() {
        return (BModbusRegisterRangeTable)this.get(validStatusRange);
    }

    public void setValidStatusRange(BModbusRegisterRangeTable bModbusRegisterRangeTable) {
        this.set(validStatusRange, (BValue)bModbusRegisterRangeTable, null);
    }

    public BModbusRegisterRangeTable getValidHoldingRegistersRange() {
        return (BModbusRegisterRangeTable)this.get(validHoldingRegistersRange);
    }

    public void setValidHoldingRegistersRange(BModbusRegisterRangeTable bModbusRegisterRangeTable) {
        this.set(validHoldingRegistersRange, (BValue)bModbusRegisterRangeTable, null);
    }

    public BModbusRegisterRangeTable getValidInputRegistersRange() {
        return (BModbusRegisterRangeTable)this.get(validInputRegistersRange);
    }

    public void setValidInputRegistersRange(BModbusRegisterRangeTable bModbusRegisterRangeTable) {
        this.set(validInputRegistersRange, (BValue)bModbusRegisterRangeTable, null);
    }

    public BModbusServerPointDeviceExt getPoints() {
        return (BModbusServerPointDeviceExt)this.get(points);
    }

    public void setPoints(BModbusServerPointDeviceExt bModbusServerPointDeviceExt) {
        this.set(points, (BValue)bModbusServerPointDeviceExt, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        Integer[] integerArray = this.getValidCoilsRange().getValidAddressArray();
        int n = integerArray.length;
        if (n <= 0) {
            n = 1;
        }
        this.coilStatusBitSet = new IntHashMap(n);
        int n2 = 0;
        while (n2 < integerArray.length) {
            this.coilStatusBitSet.put(integerArray[n2].intValue(), (Object)new Boolean(false));
            ++n2;
        }
        integerArray = this.getValidStatusRange().getValidAddressArray();
        n = integerArray.length;
        if (n <= 0) {
            n = 1;
        }
        this.inputStatusBitSet = new IntHashMap(n);
        n2 = 0;
        while (n2 < integerArray.length) {
            this.inputStatusBitSet.put(integerArray[n2].intValue(), (Object)new Boolean(false));
            ++n2;
        }
        integerArray = this.getValidHoldingRegistersRange().getValidAddressArray();
        n = integerArray.length * 2;
        if (n <= 0) {
            n = 1;
        }
        this.holdingRegisterByteArray = new IntHashMap(n);
        n2 = 0;
        while (n2 < integerArray.length) {
            this.holdingRegisterByteArray.put(integerArray[n2] * 2, (Object)new Byte(0));
            this.holdingRegisterByteArray.put(integerArray[n2] * 2 + 1, (Object)new Byte(0));
            ++n2;
        }
        integerArray = this.getValidInputRegistersRange().getValidAddressArray();
        n = integerArray.length * 2;
        if (n <= 0) {
            n = 1;
        }
        this.inputRegisterByteArray = new IntHashMap(n);
        n2 = 0;
        while (n2 < integerArray.length) {
            this.inputRegisterByteArray.put(integerArray[n2] * 2, (Object)new Byte(0));
            this.inputRegisterByteArray.put(integerArray[n2] * 2 + 1, (Object)new Byte(0));
            ++n2;
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)validCoilsRange)) {
            if (this.coilStatusBitSet == null) {
                return;
            }
            Integer[] integerArray = this.getValidCoilsRange().getValidAddressArray();
            int n = integerArray.length;
            if (n <= 0) {
                n = 1;
            }
            IntHashMap intHashMap = new IntHashMap(n);
            int n2 = 0;
            while (n2 < integerArray.length) {
                Object object = this.coilStatusBitSet.get(integerArray[n2].intValue());
                if (object != null) {
                    intHashMap.put(integerArray[n2].intValue(), object);
                } else {
                    intHashMap.put(integerArray[n2].intValue(), (Object)new Boolean(false));
                }
                ++n2;
            }
            this.coilStatusBitSet = intHashMap;
        } else if (property.equals((Object)validStatusRange)) {
            if (this.inputStatusBitSet == null) {
                return;
            }
            Integer[] integerArray = this.getValidStatusRange().getValidAddressArray();
            int n = integerArray.length;
            if (n <= 0) {
                n = 1;
            }
            IntHashMap intHashMap = new IntHashMap(n);
            int n3 = 0;
            while (n3 < integerArray.length) {
                Object object = this.inputStatusBitSet.get(integerArray[n3].intValue());
                if (object != null) {
                    intHashMap.put(integerArray[n3].intValue(), object);
                } else {
                    intHashMap.put(integerArray[n3].intValue(), (Object)new Boolean(false));
                }
                ++n3;
            }
            this.inputStatusBitSet = intHashMap;
        } else if (property.equals((Object)validHoldingRegistersRange)) {
            if (this.holdingRegisterByteArray == null) {
                return;
            }
            Integer[] integerArray = this.getValidHoldingRegistersRange().getValidAddressArray();
            int n = integerArray.length * 2;
            if (n <= 0) {
                n = 1;
            }
            IntHashMap intHashMap = new IntHashMap(n);
            int n4 = 0;
            while (n4 < integerArray.length) {
                Object object = this.holdingRegisterByteArray.get(integerArray[n4] * 2);
                if (object != null) {
                    intHashMap.put(integerArray[n4] * 2, object);
                } else {
                    intHashMap.put(integerArray[n4] * 2, (Object)new Byte(0));
                }
                object = this.holdingRegisterByteArray.get(integerArray[n4] * 2 + 1);
                if (object != null) {
                    intHashMap.put(integerArray[n4] * 2 + 1, object);
                } else {
                    intHashMap.put(integerArray[n4] * 2 + 1, (Object)new Byte(0));
                }
                ++n4;
            }
            this.holdingRegisterByteArray = intHashMap;
        } else if (property.equals((Object)validInputRegistersRange)) {
            if (this.inputRegisterByteArray == null) {
                return;
            }
            Integer[] integerArray = this.getValidInputRegistersRange().getValidAddressArray();
            int n = integerArray.length * 2;
            if (n <= 0) {
                n = 1;
            }
            IntHashMap intHashMap = new IntHashMap(n);
            int n5 = 0;
            while (n5 < integerArray.length) {
                Object object = this.inputRegisterByteArray.get(integerArray[n5] * 2);
                if (object != null) {
                    intHashMap.put(integerArray[n5] * 2, object);
                } else {
                    intHashMap.put(integerArray[n5] * 2, (Object)new Byte(0));
                }
                object = this.inputRegisterByteArray.get(integerArray[n5] * 2 + 1);
                if (object != null) {
                    intHashMap.put(integerArray[n5] * 2 + 1, object);
                } else {
                    intHashMap.put(integerArray[n5] * 2 + 1, (Object)new Byte(0));
                }
                ++n5;
            }
            this.inputRegisterByteArray = intHashMap;
        }
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName()).append("[" + this.getDeviceAddress() + ']');
        return stringBuffer.toString();
    }

    public void doPing() {
        if (this.isDisabled() || this.isFault()) {
            return;
        }
        if (this.modbusNet() == null) {
            this.pingFail("No modbus network found");
            return;
        }
        if (this.modbusNet().getModbusLog().isTraceOn()) {
            this.modbusNet().getModbusLog().trace("ping(): ModbusServerDevice " + this.getName() + '[' + this.getDeviceAddress() + "] is up");
        }
        this.pingOk();
    }

    public boolean isHoldingRegisterAddressValid(int n, int n2) {
        int n3 = n * 2;
        while (n3 < (n + n2) * 2) {
            if (this.holdingRegisterByteArray.get(n3) == null) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public byte[] getHoldingRegisterValues(int n, int n2) throws ModbusException {
        byte[] byArray = new byte[n2 * 2];
        int n3 = n * 2;
        while (n3 < (n + n2) * 2) {
            if (this.holdingRegisterByteArray.get(n3) == null) {
                throw new ModbusException(103);
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2 * 2) {
            byArray[n3] = (Byte)this.holdingRegisterByteArray.get(n * 2 + n3);
            ++n3;
        }
        return byArray;
    }

    public void setHoldingRegisterValues(int n, byte[] byArray) throws ModbusException {
        int n2 = 0;
        while (n2 < byArray.length) {
            if (this.holdingRegisterByteArray.get(n * 2 + n2) == null) {
                throw new ModbusException(103);
            }
            this.holdingRegisterByteArray.put(n * 2 + n2, (Object)new Byte(byArray[n2]));
            ++n2;
        }
    }

    public boolean isInputRegisterAddressValid(int n, int n2) {
        int n3 = n * 2;
        while (n3 < (n + n2) * 2) {
            if (this.inputRegisterByteArray.get(n3) == null) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public byte[] getInputRegisterValues(int n, int n2) throws ModbusException {
        byte[] byArray = new byte[n2 * 2];
        int n3 = n * 2;
        while (n3 < (n + n2) * 2) {
            if (this.inputRegisterByteArray.get(n3) == null) {
                throw new ModbusException(103);
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2 * 2) {
            byArray[n3] = (Byte)this.inputRegisterByteArray.get(n * 2 + n3);
            ++n3;
        }
        return byArray;
    }

    public void setInputRegisterValues(int n, byte[] byArray) throws ModbusException {
        int n2 = 0;
        while (n2 < byArray.length) {
            if (this.inputRegisterByteArray.get(n * 2 + n2) == null) {
                throw new ModbusException(103);
            }
            this.inputRegisterByteArray.put(n * 2 + n2, (Object)new Byte(byArray[n2]));
            ++n2;
        }
    }

    public boolean isCoilAddressValid(int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            if (this.coilStatusBitSet.get(n3) == null) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public byte[] getCoilStatusValues(int n, int n2) throws ModbusException {
        int n3 = n2 / 8;
        if (n2 % 8 != 0) {
            ++n3;
        }
        byte[] byArray = new byte[n3];
        int n4 = n;
        while (n4 < n + n2) {
            if (this.coilStatusBitSet.get(n4) == null) {
                throw new ModbusException(103);
            }
            ++n4;
        }
        n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = 1 << n4;
            byArray[n5] = (Boolean)this.coilStatusBitSet.get(n + n6) != false ? (byte)(byArray[n5] | n7) : (byte)(byArray[n5] & ~n7);
            if (++n4 == 8) {
                n4 = 0;
                ++n5;
            }
            ++n6;
        }
        return byArray;
    }

    public void setCoilStatusValue(int n, boolean bl) throws ModbusException {
        if (this.coilStatusBitSet.get(n) == null) {
            throw new ModbusException(103);
        }
        this.coilStatusBitSet.put(n, (Object)new Boolean(bl));
    }

    public void setCoilStatusValue(int n, int n2, byte[] byArray) throws ModbusException {
        block7: {
            try {
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                while (n5 < n2) {
                    int n6 = 1 << n3;
                    boolean bl = false;
                    if ((byArray[n4] & n6) != 0) {
                        bl = true;
                    }
                    this.setCoilStatusValue(n, bl);
                    ++n;
                    if (++n3 >= 8) {
                        n3 = 0;
                        ++n4;
                    }
                    ++n5;
                }
            }
            catch (ModbusException modbusException) {
                if (this.modbusNet() != null && this.modbusNet().getModbusLog().isTraceOn()) {
                    this.modbusNet().getModbusLog().trace(this.getName() + ".setCoilStatusValue() caught Exception: ", (Throwable)((Object)modbusException));
                }
                throw modbusException;
            }
            catch (Exception exception) {
                if (this.modbusNet() == null) break block7;
                this.modbusNet().getModbusLog().error(this.getName() + ".setCoilStatusValue() caught Exception: ", (Throwable)exception);
            }
        }
    }

    public boolean isStatusAddressValid(int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            if (this.inputStatusBitSet.get(n3) == null) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public byte[] getInputStatusValues(int n, int n2) throws ModbusException {
        int n3 = n2 / 8;
        if (n2 % 8 != 0) {
            ++n3;
        }
        byte[] byArray = new byte[n3];
        int n4 = n;
        while (n4 < n + n2) {
            if (this.inputStatusBitSet.get(n4) == null) {
                throw new ModbusException(103);
            }
            ++n4;
        }
        n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = 1 << n4;
            byArray[n5] = (Boolean)this.inputStatusBitSet.get(n + n6) != false ? (byte)(byArray[n5] | n7) : (byte)(byArray[n5] & ~n7);
            if (++n4 == 8) {
                n4 = 0;
                ++n5;
            }
            ++n6;
        }
        return byArray;
    }

    public void setInputStatusValue(int n, boolean bl) throws ModbusException {
        if (this.inputStatusBitSet.get(n) == null) {
            throw new ModbusException(103);
        }
        this.inputStatusBitSet.put(n, (Object)new Boolean(bl));
    }

    public byte[] getFileRecordData(int n, int n2, int n3) throws ModbusException {
        BModbusServerStringRecord[] bModbusServerStringRecordArray = this.getStringFileRecords();
        if (bModbusServerStringRecordArray == null) {
            throw new ModbusException(103);
        }
        int n4 = 0;
        while (n4 < bModbusServerStringRecordArray.length) {
            if (bModbusServerStringRecordArray[n4] != null && bModbusServerStringRecordArray[n4].getFileNumber() == n && bModbusServerStringRecordArray[n4].containsRecords(n2, n3)) {
                return bModbusServerStringRecordArray[n4].getBytes(n2, n3);
            }
            ++n4;
        }
        throw new ModbusException(103);
    }

    public byte[] setFileRecordData(int n, int n2, int n3, byte[] byArray) throws ModbusException {
        BModbusServerStringRecord[] bModbusServerStringRecordArray = this.getStringFileRecords();
        if (bModbusServerStringRecordArray == null) {
            throw new ModbusException(103);
        }
        int n4 = 0;
        while (n4 < bModbusServerStringRecordArray.length) {
            if (bModbusServerStringRecordArray[n4] != null && bModbusServerStringRecordArray[n4].getFileNumber() == n && bModbusServerStringRecordArray[n4].containsRecords(n2, n3)) {
                return bModbusServerStringRecordArray[n4].setBytes(byArray, n2, n3);
            }
            ++n4;
        }
        throw new ModbusException(103);
    }

    private final BModbusServerStringRecord[] getStringFileRecords() {
        ArrayList arrayList = new ArrayList();
        this.getFileRecords((BComponent)this, BModbusServerStringRecord.TYPE, arrayList);
        return arrayList.toArray(new BModbusServerStringRecord[arrayList.size()]);
    }

    private final void getFileRecords(BComponent bComponent, Type type, ArrayList arrayList) {
        SlotCursor slotCursor = bComponent.loadSlots().getProperties();
        while (slotCursor.nextComponent()) {
            BComponent bComponent2 = slotCursor.get().asComponent();
            if (bComponent2.getType().is(type)) {
                arrayList.add(bComponent2);
            }
            this.getFileRecords(bComponent2, type, arrayList);
        }
    }

    public BPointDeviceExt getPointDeviceExt() {
        return this.getPoints();
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.inputRegisterByteArray = null;
        this.holdingRegisterByteArray = null;
        this.coilStatusBitSet = null;
        this.inputStatusBitSet = null;
    }

    public BModbusServerDevice() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$modbusCore$server$BModbusServerDevice;
        if (clazz == null) {
            clazz = class$com$tridium$modbusCore$server$BModbusServerDevice = BModbusServerDevice.class("[Lcom.tridium.modbusCore.server.BModbusServerDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"deviceLocal.png");
    }
}

