/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.messages;

import com.tridium.modbusCore.BModbusDevice;
import com.tridium.modbusCore.messages.ModbusMessage;
import com.tridium.modbusCore.messages.ModbusOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.baja.util.ByteArrayUtil;

public class ModbusWriteRequest
extends ModbusMessage {
    public int byteCount;
    public byte[] data;

    public float getFloat(int n, int n2, boolean bl) {
        if (n >= this.numberPoints) {
            throw new IllegalArgumentException("Point not returned: " + n);
        }
        int n3 = n * n2;
        if (n3 >= this.byteCount) {
            throw new IllegalArgumentException("Point not returned: " + n);
        }
        long l = bl ? (long)(this.data[n3 + 3] & 0xFF | (this.data[n3 + 2] & 0xFF) << 8 | (this.data[n3 + 1] & 0xFF) << 16 | (this.data[n3] & 0xFF) << 24) : (long)(this.data[n3 + 1] & 0xFF | (this.data[n3] & 0xFF) << 8 | (this.data[n3 + 3] & 0xFF) << 16 | (this.data[n3 + 2] & 0xFF) << 24);
        return Float.intBitsToFloat((int)l);
    }

    public int getRegister(int n, int n2, boolean bl) {
        long l = 0L;
        if (n >= this.numberPoints) {
            throw new IllegalArgumentException("Point not returned: " + n);
        }
        int n3 = n * n2;
        if (n3 >= this.byteCount) {
            throw new IllegalArgumentException("Point not returned: " + n);
        }
        switch (n2) {
            case 2: {
                return this.data[n3 + 1] & 0xFF | (this.data[n3] & 0xFF) << 8;
            }
            case 4: {
                l = bl ? (long)(this.data[n3 + 3] & 0xFF | (this.data[n3 + 2] & 0xFF) << 8 | (this.data[n3 + 1] & 0xFF) << 16 | (this.data[n3] & 0xFF) << 24) : (long)(this.data[n3 + 1] & 0xFF | (this.data[n3] & 0xFF) << 8 | (this.data[n3 + 3] & 0xFF) << 16 | (this.data[n3 + 2] & 0xFF) << 24);
                return (int)(l &= (long)-1);
            }
        }
        throw new IllegalArgumentException("Unsupported data size: " + n2);
    }

    public final void writeRtu(OutputStream outputStream) throws IOException {
        ModbusOutputStream modbusOutputStream = this.formatMessage();
        modbusOutputStream.writeCRC();
        outputStream.write(modbusOutputStream.toByteArray());
    }

    public final void writeTcp(OutputStream outputStream) throws IOException {
        byte[] byArray = this.formatMessage().toByteArray();
        ModbusOutputStream modbusOutputStream = new ModbusOutputStream();
        if (this.transactionIdentifier < 0) {
            this.transactionIdentifier = ModbusWriteRequest.getNextTransactionId(this.getMaxTransactionId());
        }
        modbusOutputStream.write((byte)((this.transactionIdentifier & 0xFF00) >> 8));
        modbusOutputStream.write((byte)(this.transactionIdentifier & 0xFF));
        modbusOutputStream.write((byte)0);
        modbusOutputStream.write((byte)0);
        int n = byArray.length;
        modbusOutputStream.write((byte)((n & 0xFF00) >> 8));
        modbusOutputStream.write((byte)(n & 0xFF));
        modbusOutputStream.write(byArray);
        outputStream.write(modbusOutputStream.toByteArray());
    }

    public final void writeAscii(OutputStream outputStream) throws IOException {
        ModbusOutputStream modbusOutputStream = this.formatMessage();
        modbusOutputStream.writeLRC();
        outputStream.write(modbusOutputStream.toAsciiHexByteArray());
    }

    private final ModbusOutputStream formatMessage() {
        ModbusOutputStream modbusOutputStream = new ModbusOutputStream();
        modbusOutputStream.write((byte)this.deviceAddress);
        modbusOutputStream.write((byte)this.functionCode);
        modbusOutputStream.write((byte)((this.startAddress & 0xFF00) >> 8));
        modbusOutputStream.write((byte)(this.startAddress & 0xFF));
        if (this.functionCode == 5) {
            this.byteCount = 2;
            modbusOutputStream.write(this.data, 0, this.byteCount);
        } else if (this.functionCode == 6) {
            this.byteCount = 2;
            modbusOutputStream.write(this.data, 0, this.byteCount);
        } else if (this.functionCode == 16 || this.functionCode == 15) {
            this.byteCount = this.data.length;
            modbusOutputStream.write((byte)((this.numberPoints & 0xFF00) >> 8));
            modbusOutputStream.write((byte)(this.numberPoints & 0xFF));
            modbusOutputStream.write((byte)this.byteCount);
            modbusOutputStream.write(this.data, 0, this.byteCount);
        }
        return modbusOutputStream;
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toDebugString());
        stringBuffer.append("\n  Modbus Byte Count = " + this.byteCount);
        stringBuffer.append("\n  Modbus Data = " + ByteArrayUtil.toHexString((byte[])this.data));
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.write(byteArrayOutputStream);
            stringBuffer.append("\n  Raw Bytes = " + ByteArrayUtil.toHexString((byte[])byteArrayOutputStream.toByteArray()));
        }
        catch (Exception exception) {}
        return stringBuffer.toString();
    }

    public ModbusWriteRequest(int n, BModbusDevice bModbusDevice) {
        super(n, bModbusDevice);
    }

    public ModbusWriteRequest(int n, BModbusDevice bModbusDevice, int n2, int n3, int n4, int n5, byte[] byArray) {
        super(n, bModbusDevice);
        this.deviceAddress = n2;
        this.functionCode = n3;
        this.startAddress = n4;
        this.numberPoints = n5;
        this.data = byArray;
    }
}

