/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.messages;

import com.tridium.modbusCore.BModbusDevice;
import com.tridium.modbusCore.messages.ModbusMessage;
import com.tridium.modbusCore.messages.ModbusOutputStream;
import com.tridium.modbusCore.messages.ModbusWriteRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.baja.util.ByteArrayUtil;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ModbusResponse
extends ModbusMessage {
    public int exceptionCode;
    public int startAddress;
    public int numberPoints;
    public int byteCount;
    public byte[] data;

    public final void writeRtu(OutputStream outputStream) throws IOException {
        ModbusOutputStream modbusOutputStream = this.formatBaseMessage();
        modbusOutputStream.writeCRC();
        outputStream.write(modbusOutputStream.toByteArray());
    }

    public void writeAscii(OutputStream outputStream) throws IOException {
        ModbusOutputStream modbusOutputStream = this.formatBaseMessage();
        modbusOutputStream.writeLRC();
        outputStream.write(modbusOutputStream.toAsciiHexByteArray());
    }

    public void writeTcp(OutputStream outputStream) throws IOException {
        ModbusOutputStream modbusOutputStream = this.formatBaseMessage();
        byte[] byArray = modbusOutputStream.toByteArray();
        modbusOutputStream = new ModbusOutputStream();
        modbusOutputStream.write((byte)((this.transactionIdentifier & 0xFF00) >> 8));
        modbusOutputStream.write((byte)(this.transactionIdentifier & 0xFF));
        modbusOutputStream.write((byte)0);
        modbusOutputStream.write((byte)0);
        int n = byArray.length;
        modbusOutputStream.write((byte)((n & 0xFF00) >> 8));
        modbusOutputStream.write((byte)(n & 0xFF));
        modbusOutputStream.write(byArray);
        outputStream.write(modbusOutputStream.toByteArray());
    }

    protected ModbusOutputStream formatBaseMessage() throws IOException {
        ModbusOutputStream modbusOutputStream = new ModbusOutputStream();
        modbusOutputStream.write((byte)this.deviceAddress);
        modbusOutputStream.write((byte)this.functionCode);
        switch (this.functionCode) {
            case 5: 
            case 6: {
                modbusOutputStream.writeWord(this.startAddress);
                modbusOutputStream.write(this.data);
                break;
            }
            case 15: 
            case 16: {
                modbusOutputStream.writeWord(this.startAddress);
                modbusOutputStream.writeWord(this.numberPoints);
                break;
            }
            default: {
                modbusOutputStream.write((byte)this.byteCount);
                if ((this.functionCode & 0x80) != 0) break;
                modbusOutputStream.write(this.data);
            }
        }
        return modbusOutputStream;
    }

    public boolean isError() {
        boolean bl = false;
        if (this.exceptionCode != 0) {
            bl = true;
        }
        return bl;
    }

    public String getString(int n) {
        if (n > this.byteCount) {
            throw new IllegalArgumentException("Incomplete string returned: ");
        }
        byte[] byArray = new byte[this.byteCount];
        int n2 = 0;
        while (n2 < this.byteCount) {
            byArray[n2] = this.data[n2];
            ++n2;
        }
        return new String(byArray, 0);
    }

    public boolean getBinary(int n) {
        if (n >= this.numberPoints) {
            throw new IllegalArgumentException("Point not returned: " + n);
        }
        int n2 = n / 8;
        int n3 = n % 8;
        if (n2 >= this.byteCount) {
            throw new IllegalArgumentException("Point not returned: " + n);
        }
        boolean bl = false;
        if ((this.data[n2] & 1 << n3) != 0) {
            bl = true;
        }
        return bl;
    }

    public int getRegister(int n, int n2) {
        return this.getRegister(n, n2, false);
    }

    public int getRegister(int n, int n2, boolean bl) {
        return this.getRegister(n, n2, bl, false);
    }

    public int getRegister(int n, int n2, boolean bl, boolean bl2) {
        long l = 0L;
        if (n >= this.numberPoints) {
            throw new IllegalArgumentException("Point not returned: " + n);
        }
        int n3 = n * n2;
        if (n3 >= this.byteCount) {
            throw new IllegalArgumentException("Point not returned: " + n);
        }
        switch (n2) {
            case 2: {
                int n4 = this.data[n3 + 1] & 0xFF | (this.data[n3] & 0xFF) << 8;
                if (bl2 && n4 >= 32768) {
                    n4 |= 0xFFFF0000;
                }
                return n4;
            }
            case 4: {
                l = bl ? (long)(this.data[n3 + 3] & 0xFF | (this.data[n3 + 2] & 0xFF) << 8 | (this.data[n3 + 1] & 0xFF) << 16 | (this.data[n3] & 0xFF) << 24) : (long)(this.data[n3 + 1] & 0xFF | (this.data[n3] & 0xFF) << 8 | (this.data[n3 + 3] & 0xFF) << 16 | (this.data[n3 + 2] & 0xFF) << 24);
                return (int)(l &= (long)-1);
            }
        }
        throw new IllegalArgumentException("Unsupported data size: " + n2);
    }

    public float getFloat(int n, int n2, boolean bl) {
        if (n >= this.numberPoints) {
            throw new IllegalArgumentException("Point not returned: " + n);
        }
        int n3 = n * n2;
        if (n3 >= this.byteCount) {
            throw new IllegalArgumentException("Point not returned: " + n);
        }
        long l = bl ? (long)(this.data[n3 + 3] & 0xFF | (this.data[n3 + 2] & 0xFF) << 8 | (this.data[n3 + 1] & 0xFF) << 16 | (this.data[n3] & 0xFF) << 24) : (long)(this.data[n3 + 1] & 0xFF | (this.data[n3] & 0xFF) << 8 | (this.data[n3 + 3] & 0xFF) << 16 | (this.data[n3 + 2] & 0xFF) << 24);
        return Float.intBitsToFloat((int)l);
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "RTU";
        if (this.comType == 0) {
            string = "ASCII";
        } else if (this.comType == 2) {
            string = "TCP";
        }
        stringBuffer.append("Modbus " + string + " Response Message = " + TextUtil.getClassName(this.getClass()));
        stringBuffer.append("\n  Tag = " + this.getTag());
        stringBuffer.append("\n  Modbus Device Address = " + (this.deviceAddress & 0xFF));
        stringBuffer.append("\n  Modbus Function Code = " + this.functionCode);
        stringBuffer.append("\n  Modbus Exception Code = " + this.exceptionCode);
        stringBuffer.append("\n  Modbus Data Starting Address = " + this.startAddress);
        stringBuffer.append("\n  Modbus Number of Data Points = " + this.numberPoints);
        stringBuffer.append("\n  Modbus Byte Count = " + this.byteCount);
        stringBuffer.append("\n  Modbus Transaction ID = " + this.transactionIdentifier);
        stringBuffer.append("\n  Modbus Data = " + ByteArrayUtil.toHexString((byte[])this.data));
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.write(byteArrayOutputStream);
            stringBuffer.append("\n  Raw Bytes = " + ByteArrayUtil.toHexString((byte[])byteArrayOutputStream.toByteArray()));
        }
        catch (Exception exception) {}
        return stringBuffer.toString();
    }

    public String getExceptionString() {
        switch (this.exceptionCode) {
            case 0: {
                return "ok";
            }
            case 1: {
                return "illegal function";
            }
            case 2: {
                return "illegal data address";
            }
            case 3: {
                return "illegal data value";
            }
            case 4: {
                return "slave device failure";
            }
            case 5: {
                return "acknowledge";
            }
            case 6: {
                return "slave device busy";
            }
            case 7: {
                return "negative acknowledge";
            }
            case 8: {
                return "memory parity error";
            }
            case 9: {
                return "device timeout";
            }
            case 10: {
                return "gateway path unavailable";
            }
            case 11: {
                return "gateway target device failed to respond";
            }
            case -1: {
                return "crc error";
            }
            case -5: {
                return "lrc error";
            }
            case -2: {
                return "ok not active";
            }
            case -3: {
                return "unknown";
            }
            case -6: {
                return "down";
            }
            case -7: {
                return "fault";
            }
            case -8: {
                return "disabled";
            }
        }
        return "other error";
    }

    private final /* synthetic */ void this() {
        this.data = new byte[255];
    }

    public ModbusResponse(int n, BModbusDevice bModbusDevice) {
        super(n, bModbusDevice);
        this.this();
    }

    public ModbusResponse(int n, BModbusDevice bModbusDevice, ModbusWriteRequest modbusWriteRequest) {
        super(n, bModbusDevice);
        this.this();
        this.deviceAddress = modbusWriteRequest.deviceAddress;
        this.functionCode = modbusWriteRequest.functionCode;
        this.startAddress = modbusWriteRequest.startAddress;
        this.numberPoints = modbusWriteRequest.numberPoints;
        this.byteCount = modbusWriteRequest.byteCount;
        this.data = new byte[modbusWriteRequest.data.length];
        int n2 = 0;
        while (n2 < modbusWriteRequest.data.length) {
            this.data[n2] = modbusWriteRequest.data[n2];
            ++n2;
        }
    }
}

