/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.messages;

import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.modbusCore.BModbusDevice;
import com.tridium.modbusCore.messages.ModbusInputStream;
import com.tridium.modbusCore.messages.ModbusReceivedMessage;
import com.tridium.modbusCore.messages.ModbusResponse;

public class ModbusReadExceptionStatusResponse
extends ModbusResponse {
    int returnBytes;
    int statusData;

    public double getDouble() {
        return this.statusData;
    }

    public boolean getStatusBit(int n) {
        int n2 = 1 << n;
        boolean bl = false;
        if ((this.statusData & n2) != 0) {
            bl = true;
        }
        return bl;
    }

    public ModbusReadExceptionStatusResponse(int n, BModbusDevice bModbusDevice, ReceivedMessage receivedMessage, int n2, boolean bl) {
        super(n, bModbusDevice);
        this.returnBytes = n2;
        ModbusReceivedMessage modbusReceivedMessage = (ModbusReceivedMessage)receivedMessage;
        ModbusInputStream modbusInputStream = new ModbusInputStream(modbusReceivedMessage.getBytes(), 0, modbusReceivedMessage.getLength());
        if (!bl) {
            this.deviceAddress = modbusInputStream.read() & 0xFF;
            this.functionCode = modbusInputStream.read() & 0xFF;
            if ((this.functionCode & 0x80) != 0) {
                this.exceptionCode = modbusInputStream.read() & 0xFF;
            } else {
                this.exceptionCode = 0;
                this.statusData = 0;
                if (n2 == 2) {
                    this.statusData = (modbusInputStream.read() & 0xFF) << 8;
                }
                this.statusData = this.statusData & 0xFF00 | modbusInputStream.read() & 0xFF;
                System.out.println("    StatusData = 0x" + Integer.toHexString(this.statusData));
            }
        } else if (modbusInputStream.read() != 58) {
            this.exceptionCode = -4;
        } else {
            this.deviceAddress = modbusInputStream.readHexByte() & 0xFF;
            this.functionCode = modbusInputStream.readHexByte() & 0xFF;
            if ((this.functionCode & 0x80) != 0) {
                this.exceptionCode = modbusInputStream.readHexByte();
            } else {
                this.exceptionCode = 0;
                this.statusData = 0;
                if (n2 == 2) {
                    this.statusData = (modbusInputStream.readHexByte() & 0xFF) << 8;
                }
                this.statusData = this.statusData & 0xFF00 | modbusInputStream.readHexByte() & 0xFF;
            }
        }
    }
}

